/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cache;

import fr.gouv.vitam.common.ParametersChecker;
import java.time.Instant;

public class LRUCacheEntry<T> {
    private final T key;
    private final long weight;
    private final Instant lastAccessInstant;

    public LRUCacheEntry(T key, long weight, Instant lastAccessInstant) throws IllegalArgumentException {
        ParametersChecker.checkParameter((String)"Key must not be null", (Object[])new Object[]{key});
        ParametersChecker.checkParameter((String)"last access instant must not be null", (Object[])new Object[]{lastAccessInstant});
        ParametersChecker.checkValue((String)"Entry weight must be positive", (long)weight, (long)1L);
        this.key = key;
        this.weight = weight;
        this.lastAccessInstant = lastAccessInstant;
    }

    public T getKey() {
        return this.key;
    }

    public long getWeight() {
        return this.weight;
    }

    public Instant getLastAccessInstant() {
        return this.lastAccessInstant;
    }
}

