/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.storage.tapelibrary.TapeDriveConf;
import fr.gouv.vitam.common.storage.tapelibrary.TapeLibraryConf;
import fr.gouv.vitam.common.storage.tapelibrary.TapeLibraryConfiguration;
import fr.gouv.vitam.common.storage.tapelibrary.TapeRobotConf;
import fr.gouv.vitam.storage.engine.common.collection.OfferCollections;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestManager;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheEvictionController;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.BackupFileStorage;
import fr.gouv.vitam.storage.offers.tape.cas.BasicFileStorage;
import fr.gouv.vitam.storage.offers.tape.cas.BucketTopologyHelper;
import fr.gouv.vitam.storage.offers.tape.cas.FileBucketTarCreatorManager;
import fr.gouv.vitam.storage.offers.tape.cas.IncompleteWriteOrderBootstrapRecovery;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.TapeLibraryContentAddressableStorage;
import fr.gouv.vitam.storage.offers.tape.cas.TarFileRapairer;
import fr.gouv.vitam.storage.offers.tape.cas.WriteOrderCreator;
import fr.gouv.vitam.storage.offers.tape.cas.WriteOrderCreatorBootstrapRecovery;
import fr.gouv.vitam.storage.offers.tape.dto.TapeLibrarySpec;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCommandException;
import fr.gouv.vitam.storage.offers.tape.impl.TapeDriveManager;
import fr.gouv.vitam.storage.offers.tape.impl.TapeRobotManager;
import fr.gouv.vitam.storage.offers.tape.impl.catalog.TapeCatalogRepository;
import fr.gouv.vitam.storage.offers.tape.impl.catalog.TapeCatalogServiceImpl;
import fr.gouv.vitam.storage.offers.tape.impl.queue.QueueRepositoryImpl;
import fr.gouv.vitam.storage.offers.tape.metrics.AccessRequestMetrics;
import fr.gouv.vitam.storage.offers.tape.metrics.ArchiveCacheMetrics;
import fr.gouv.vitam.storage.offers.tape.metrics.DriveWorkerMetrics;
import fr.gouv.vitam.storage.offers.tape.metrics.OrderQueueMetrics;
import fr.gouv.vitam.storage.offers.tape.metrics.TapeCatalogMetrics;
import fr.gouv.vitam.storage.offers.tape.pool.TapeLibraryPoolImpl;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLibraryPool;
import fr.gouv.vitam.storage.offers.tape.spec.TapeRobotService;
import fr.gouv.vitam.storage.offers.tape.worker.TapeDriveWorkerManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class TapeLibraryFactory {
    private static final TapeLibraryFactory instance = new TapeLibraryFactory();
    private static final long MB_BYTES = 1000000L;
    private final ConcurrentMap<String, TapeLibraryPool> tapeLibraryPool = new ConcurrentHashMap<String, TapeLibraryPool>();
    private final TapeServiceCreator defaultTapeServiceCreator = new TapeServiceCreatorImpl();
    private final ConcurrentMap<String, TapeDriveWorkerManager> tapeDriveWorkerManagers = new ConcurrentHashMap<String, TapeDriveWorkerManager>();
    private TapeLibraryContentAddressableStorage tapeLibraryContentAddressableStorage;
    private BackupFileStorage backupFileStorage;
    private TapeCatalogService tapeCatalogService;
    private AccessRequestManager accessRequestManager;
    private ArchiveCacheStorage archiveCacheStorage;
    private TapeServiceCreator tapeServiceCreator = this.defaultTapeServiceCreator;

    private TapeLibraryFactory() {
    }

    public void initialize(TapeLibraryConfiguration configuration, MongoDatabase mongoDatabase) throws IOException, IllegalPathException {
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{configuration, mongoDatabase});
        ParametersChecker.checkParameter((String)"Missing cache capacity configuration settings", (Object[])new Object[]{configuration.getCachedTarMaxStorageSpaceInMB(), configuration.getCachedTarEvictionStorageSpaceThresholdInMB(), configuration.getCachedTarSafeStorageSpaceThresholdInMB()});
        this.createWorkingDirectories(configuration);
        Map libraries = configuration.getTapeLibraries();
        TapeCatalogRepository tapeCatalogRepository = new TapeCatalogRepository((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.TAPE_CATALOG.getName()));
        this.tapeCatalogService = new TapeCatalogServiceImpl(tapeCatalogRepository);
        BucketTopologyHelper bucketTopologyHelper = new BucketTopologyHelper(configuration.getTopology());
        ObjectReferentialRepository objectReferentialRepository = new ObjectReferentialRepository((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.TAPE_OBJECT_REFERENTIAL.getName()));
        ArchiveReferentialRepository archiveReferentialRepository = new ArchiveReferentialRepository((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.TAPE_ARCHIVE_REFERENTIAL.getName()));
        AccessRequestReferentialRepository accessRequestReferentialRepository = new AccessRequestReferentialRepository((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.ACCESS_REQUEST_REFERENTIAL.getName()));
        QueueRepositoryImpl readWriteQueue = new QueueRepositoryImpl((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.TAPE_QUEUE_MESSAGE.getName()));
        ArchiveCacheEvictionController archiveCacheEvictionController = new ArchiveCacheEvictionController(accessRequestReferentialRepository, objectReferentialRepository, bucketTopologyHelper);
        this.archiveCacheStorage = new ArchiveCacheStorage(configuration.getCachedTarStorageFolder(), bucketTopologyHelper, archiveCacheEvictionController, configuration.getCachedTarMaxStorageSpaceInMB() * 1000000L, configuration.getCachedTarEvictionStorageSpaceThresholdInMB() * 1000000L, configuration.getCachedTarSafeStorageSpaceThresholdInMB() * 1000000L);
        WriteOrderCreator writeOrderCreator = new WriteOrderCreator(archiveReferentialRepository, readWriteQueue);
        TarFileRapairer tarFileRapairer = new TarFileRapairer(objectReferentialRepository);
        WriteOrderCreatorBootstrapRecovery writeOrderCreatorBootstrapRecovery = new WriteOrderCreatorBootstrapRecovery(configuration.getInputTarStorageFolder(), archiveReferentialRepository, bucketTopologyHelper, writeOrderCreator, tarFileRapairer, this.archiveCacheStorage);
        this.backupFileStorage = new BackupFileStorage(archiveReferentialRepository, writeOrderCreator, "backup", "backup-db", configuration.getInputTarStorageFolder());
        BasicFileStorage basicFileStorage = new BasicFileStorage(configuration.getInputFileStorageFolder());
        FileBucketTarCreatorManager fileBucketTarCreatorManager = new FileBucketTarCreatorManager(configuration, basicFileStorage, bucketTopologyHelper, objectReferentialRepository, archiveReferentialRepository, writeOrderCreator);
        this.accessRequestManager = new AccessRequestManager(objectReferentialRepository, archiveReferentialRepository, accessRequestReferentialRepository, this.archiveCacheStorage, bucketTopologyHelper, readWriteQueue, configuration.getMaxAccessRequestSize(), configuration.getReadyAccessRequestExpirationDelay(), configuration.getReadyAccessRequestExpirationUnit(), configuration.getReadyAccessRequestPurgeDelay(), configuration.getReadyAccessRequestPurgeUnit(), configuration.getAccessRequestCleanupTaskIntervalDelay(), configuration.getAccessRequestCleanupTaskIntervalUnit());
        this.tapeLibraryContentAddressableStorage = new TapeLibraryContentAddressableStorage(basicFileStorage, objectReferentialRepository, archiveReferentialRepository, this.accessRequestManager, fileBucketTarCreatorManager, this.archiveCacheStorage, archiveCacheEvictionController, bucketTopologyHelper);
        this.accessRequestManager.startExpirationHandler();
        readWriteQueue.initializeOnBootstrap();
        writeOrderCreatorBootstrapRecovery.initializeOnBootstrap();
        fileBucketTarCreatorManager.initializeOnBootstrap();
        IncompleteWriteOrderBootstrapRecovery incompleteWriteOrderBootstrapRecovery = new IncompleteWriteOrderBootstrapRecovery(configuration.getTmpTarOutputStorageFolder());
        incompleteWriteOrderBootstrapRecovery.initializeOnBootstrap();
        for (String tapeLibraryIdentifier : libraries.keySet()) {
            Map<Integer, TapeCatalog> driveTape;
            TapeLibraryPool libraryPool;
            TapeLibraryConf tapeLibraryConf;
            block13: {
                tapeLibraryConf = (TapeLibraryConf)libraries.get(tapeLibraryIdentifier);
                ArrayBlockingQueue<TapeRobotService> robotServices = new ArrayBlockingQueue<TapeRobotService>(tapeLibraryConf.getRobots().size(), true);
                ConcurrentHashMap<Integer, TapeDriveService> driveServices = new ConcurrentHashMap<Integer, TapeDriveService>();
                for (TapeRobotConf tapeRobotConf : tapeLibraryConf.getRobots()) {
                    TapeRobotService robotService = this.tapeServiceCreator.createRobotService(tapeRobotConf);
                    robotServices.add(robotService);
                }
                for (TapeDriveConf tapeDriveConf : tapeLibraryConf.getDrives()) {
                    TapeDriveService tapeDriveService = this.tapeServiceCreator.createTapeDriveService(configuration, tapeDriveConf);
                    driveServices.put(tapeDriveConf.getIndex(), tapeDriveService);
                }
                if (robotServices.size() > 0 && driveServices.size() > 0) {
                    this.tapeLibraryPool.putIfAbsent(tapeLibraryIdentifier, new TapeLibraryPoolImpl(tapeLibraryIdentifier, robotServices, driveServices));
                }
                libraryPool = (TapeLibraryPool)this.tapeLibraryPool.get(tapeLibraryIdentifier);
                driveTape = new HashMap<Integer, TapeCatalog>();
                try {
                    TapeRobotService robot = libraryPool.checkoutRobotService();
                    if (robot == null) break block13;
                    try {
                        TapeLibrarySpec libraryState = robot.getLoadUnloadService().status();
                        driveTape = this.tapeCatalogService.init(tapeLibraryIdentifier, libraryState);
                    }
                    catch (TapeCommandException e) {
                        throw new RuntimeException("Robot status command return ko :" + JsonHandler.unprettyPrint((Object)e.getDetails()), e);
                    }
                    finally {
                        libraryPool.pushRobotService(robot);
                    }
                }
                catch (TapeCatalogException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            TapeDriveWorkerManager tapeDriveWorkerManager = new TapeDriveWorkerManager(readWriteQueue, archiveReferentialRepository, this.accessRequestManager, libraryPool, driveTape, configuration.getInputTarStorageFolder(), configuration.isForceOverrideNonEmptyCartridges(), this.archiveCacheStorage, this.tapeCatalogService, tapeLibraryConf.getFullCartridgeDetectionThresholdInMB());
            tapeDriveWorkerManager.initializeOnBootstrap();
            this.tapeDriveWorkerManagers.put(tapeLibraryIdentifier, tapeDriveWorkerManager);
        }
        writeOrderCreator.startListener();
        fileBucketTarCreatorManager.startListeners();
        for (TapeDriveWorkerManager tapeDriveWorkerManager : this.tapeDriveWorkerManagers.values()) {
            tapeDriveWorkerManager.startWorkers();
        }
        ArchiveCacheMetrics.initializeMetrics(this.archiveCacheStorage);
        AccessRequestMetrics.initializeMetrics(accessRequestReferentialRepository);
        OrderQueueMetrics.initializeMetrics(readWriteQueue);
        TapeCatalogMetrics.initializeMetrics(tapeCatalogRepository);
        for (String tapeLibrary : this.tapeDriveWorkerManagers.keySet()) {
            DriveWorkerMetrics.initializeMetrics(tapeLibrary, (TapeDriveWorkerManager)this.tapeDriveWorkerManagers.get(tapeLibrary));
        }
    }

    public TapeLibraryContentAddressableStorage getTapeLibraryContentAddressableStorage() {
        return this.tapeLibraryContentAddressableStorage;
    }

    public static TapeLibraryFactory getInstance() {
        return instance;
    }

    public ConcurrentMap<String, TapeLibraryPool> getTapeLibraryPool() {
        return this.tapeLibraryPool;
    }

    public TapeLibraryPool getFirstTapeLibraryPool() {
        return (TapeLibraryPool)this.tapeLibraryPool.values().iterator().next();
    }

    private void createWorkingDirectories(TapeLibraryConfiguration configuration) throws IOException {
        if (StringUtils.isBlank((String)configuration.getInputFileStorageFolder()) || StringUtils.isBlank((String)configuration.getInputTarStorageFolder()) || StringUtils.isBlank((String)configuration.getTmpTarOutputStorageFolder()) || StringUtils.isBlank((String)configuration.getCachedTarStorageFolder())) {
            throw new VitamRuntimeException("Tape storage configuration");
        }
        this.createDirectory(configuration.getInputFileStorageFolder());
        this.createDirectory(configuration.getInputTarStorageFolder());
        this.createDirectory(configuration.getTmpTarOutputStorageFolder());
        this.createDirectory(configuration.getCachedTarStorageFolder());
    }

    private void createDirectory(String pathStr) throws IOException {
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public BackupFileStorage getBackupFileStorage() {
        return this.backupFileStorage;
    }

    public TapeCatalogService getTapeCatalogService() {
        return this.tapeCatalogService;
    }

    public AccessRequestManager getAccessRequestManager() {
        return this.accessRequestManager;
    }

    public ArchiveCacheStorage getArchiveCacheStorage() {
        return this.archiveCacheStorage;
    }

    @VisibleForTesting
    public void overrideTapeServiceCreatorForTesting(TapeServiceCreator tapeServiceCreator) {
        this.tapeServiceCreator = tapeServiceCreator;
    }

    @VisibleForTesting
    public void resetTapeLibraryFactoryAfterTests() {
        this.tapeLibraryPool.clear();
        this.tapeDriveWorkerManagers.clear();
        this.tapeLibraryContentAddressableStorage = null;
        this.backupFileStorage = null;
        this.tapeCatalogService = null;
        this.accessRequestManager = null;
        this.archiveCacheStorage = null;
        this.tapeServiceCreator = this.defaultTapeServiceCreator;
    }

    private static final class TapeServiceCreatorImpl
    implements TapeServiceCreator {
        private TapeServiceCreatorImpl() {
        }

        @Override
        public TapeRobotService createRobotService(TapeRobotConf tapeRobotConf) {
            return new TapeRobotManager(tapeRobotConf);
        }

        @Override
        public TapeDriveService createTapeDriveService(TapeLibraryConfiguration configuration, TapeDriveConf tapeDriveConf) {
            return new TapeDriveManager(tapeDriveConf, configuration.getInputTarStorageFolder(), configuration.getTmpTarOutputStorageFolder());
        }
    }

    public static interface TapeServiceCreator {
        public TapeRobotService createRobotService(TapeRobotConf var1);

        public TapeDriveService createTapeDriveService(TapeLibraryConfiguration var1, TapeDriveConf var2);
    }
}

