/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;

public class MetadataDocumentHelper {
    public static final String STORAGE_KEY = "_storage";
    public static final String STRATEGY_KEY = "strategyId";
    private static final List<String> computedGraphUnitFields = ListUtils.unmodifiableList(Arrays.stream(ComputedGraphUnitFields.values()).map(ComputedGraphUnitFields::getFieldName).collect(Collectors.toList()));
    private static final List<String> computedGraphObjectGroupFields = ListUtils.unmodifiableList(Arrays.stream(ComputedGraphObjectGroupFields.values()).map(ComputedGraphObjectGroupFields::getFieldName).collect(Collectors.toList()));
    private static final Set<String> temporaryUnitFields = SetUtils.unmodifiableSet(Arrays.stream(TemporaryUnitFields.values()).map(TemporaryUnitFields::getFieldName).collect(Collectors.toSet()));
    private static final Set<String> computedUnitFields;
    private static final Set<String> temporaryObjectGroupFields;
    private static final Set<String> computedObjectGroupFields;
    private static final Set<String> securedUnitFields;
    private static final Set<String> securedObjectGroupFields;

    public static List<String> getComputedGraphUnitFields() {
        return computedGraphUnitFields;
    }

    public static List<String> getComputedGraphObjectGroupFields() {
        return computedGraphObjectGroupFields;
    }

    public static Set<String> getTemporaryUnitFields() {
        return temporaryUnitFields;
    }

    public static Set<String> getComputedUnitFields() {
        return computedUnitFields;
    }

    public static Set<String> getComputedObjectGroupFields() {
        return computedObjectGroupFields;
    }

    public static void removeComputedFieldsFromUnit(JsonNode unitJson) {
        if (!unitJson.isObject()) {
            throw new IllegalArgumentException("Expected unit object json");
        }
        ObjectNode unit = (ObjectNode)unitJson;
        unit.remove(computedUnitFields);
    }

    public static void removeComputedFieldsFromObjectGroup(JsonNode objectGroupJson) {
        if (!objectGroupJson.isObject()) {
            throw new IllegalArgumentException("Expected object group object json");
        }
        ObjectNode objectGroup = (ObjectNode)objectGroupJson;
        objectGroup.remove(computedObjectGroupFields);
    }

    public static String getStrategyIdFromRawUnitOrGot(JsonNode documentJson) {
        if (documentJson == null || !documentJson.isObject()) {
            throw new IllegalArgumentException("Expected object json");
        }
        ObjectNode document = (ObjectNode)documentJson;
        if (!(document.has(STORAGE_KEY) && document.get(STORAGE_KEY).has(STRATEGY_KEY) && document.get(STORAGE_KEY).get(STRATEGY_KEY).isTextual())) {
            throw new IllegalArgumentException("Expected storage/strategy information in MD document");
        }
        return document.get(STORAGE_KEY).get(STRATEGY_KEY).asText();
    }

    public static String getStrategyIdFromUnit(JsonNode unitJson) {
        if (unitJson == null || !unitJson.isObject()) {
            throw new IllegalArgumentException("Expected unit object json");
        }
        ObjectNode unit = (ObjectNode)unitJson;
        if (!(unit.has(VitamFieldsHelper.storage()) && unit.get(VitamFieldsHelper.storage()).has(STRATEGY_KEY) && unit.get(VitamFieldsHelper.storage()).get(STRATEGY_KEY).isTextual())) {
            throw new IllegalArgumentException("Expected storage/strategy information in unit");
        }
        return unit.get(VitamFieldsHelper.storage()).get(STRATEGY_KEY).asText();
    }

    public static Set<String> getSecuredUnitFields() {
        return securedUnitFields;
    }

    public static Set<String> getSecuredObjectGroupFields() {
        return securedObjectGroupFields;
    }

    static {
        temporaryObjectGroupFields = SetUtils.unmodifiableSet(Arrays.stream(TemporaryObjectGroupFields.values()).map(TemporaryObjectGroupFields::getFieldName).collect(Collectors.toSet()));
        computedUnitFields = SetUtils.unmodifiableSet(new HashSet(CollectionUtils.union(computedGraphUnitFields, temporaryUnitFields)));
        computedObjectGroupFields = SetUtils.unmodifiableSet(new HashSet(CollectionUtils.union(computedGraphObjectGroupFields, temporaryObjectGroupFields)));
        securedUnitFields = SetUtils.unmodifiableSet(Arrays.stream(SecuredUnitFields.values()).map(SecuredUnitFields::getFieldName).collect(Collectors.toSet()));
        securedObjectGroupFields = SetUtils.unmodifiableSet(Arrays.stream(SecuredObjectGroupFields.values()).map(SecuredObjectGroupFields::getFieldName).collect(Collectors.toSet()));
    }

    private static enum ComputedGraphUnitFields {
        US("_us"),
        SPS("_sps"),
        GRAPH("_graph"),
        GRAPH_LAST_PERSISTED_DATE("_glpd"),
        MIN("_min"),
        MAX("_max"),
        UDS("_uds"),
        COMPUTEDINHERITEDRULES("_computedInheritedRules"),
        VALIDCOMPUTEDINHERITEDRULES("_validComputedInheritedRules");

        private final String fieldName;

        private ComputedGraphUnitFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    private static enum ComputedGraphObjectGroupFields {
        SPS("_sps"),
        US("_us"),
        GRAPH_LAST_PERSISTED_DATE("_glpd");

        private final String fieldName;

        private ComputedGraphObjectGroupFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    private static enum TemporaryUnitFields {
        ELIMINATION("_elimination"),
        COMPUTEDINHERITEDRULES("_computedInheritedRules"),
        VALIDCOMPUTEDINHERITEDRULES("_validComputedInheritedRules"),
        ATOMIC_VERSION("_av"),
        APPROXIMATE_CREATION_DATE("_acd"),
        APPROXIMATE_UPDATE_DATE("_aud"),
        TRANSFER_OPERATION("_opts"),
        COLLECT_BATCH_ID("_batchId"),
        COLLECT_UPLOAD_PATH("_uploadPath");

        private final String fieldName;

        private TemporaryUnitFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    private static enum TemporaryObjectGroupFields {
        ATOMIC_VERSION("_av"),
        APPROXIMATE_CREATION_DATE("_acd"),
        APPROXIMATE_UPDATE_DATE("_aud"),
        COLLECT_BATCH_ID("_batchId");

        private final String fieldName;

        private TemporaryObjectGroupFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    private static enum SecuredUnitFields {
        ID("_id"),
        TENANT("_tenant"),
        VERSION("_v"),
        UP("_up"),
        SP("_sp"),
        OBJECT_GROUP("_og"),
        IMPLEMENTATION_VERSION("_implementationVersion"),
        SEDA_VERSION("_sedaVersion"),
        NBC("_nbc"),
        HISTORY("_history"),
        STORAGE("_storage"),
        MANAGEMENT("_mgt"),
        INITIAL_OPERATION("_opi"),
        OPERATIONS("_ops"),
        UNIT_TYPE("_unitType");

        private final String fieldName;

        private SecuredUnitFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    private static enum SecuredObjectGroupFields {
        ID("_id"),
        TENANT("_tenant"),
        VERSION("_v"),
        UP("_up"),
        SP("_sp"),
        NBC("_nbc"),
        STORAGE("_storage"),
        INITIAL_OPERATION("_opi"),
        OPERATIONS("_ops"),
        QUALIFIERS("_qualifiers"),
        PROFIL("_profil");

        private final String fieldName;

        private SecuredObjectGroupFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

