/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.utils;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.utils.AccessRightType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.RuleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessContractRestrictionHelper {
    private static final Logger log = LoggerFactory.getLogger(AccessContractRestrictionHelper.class);

    private AccessContractRestrictionHelper() {
    }

    public static JsonNode applyAccessContractRestrictionForUnitForSelect(JsonNode queryDsl, AccessContractModel accessContract) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, accessContract, true, true);
        return parser.getRequest().getFinalSelect();
    }

    public static JsonNode applyAccessContractRestrictionForObjectGroupForSelect(JsonNode queryDsl, AccessContractModel accessContract) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, accessContract, false, true);
        return parser.getRequest().getFinalSelect();
    }

    public static JsonNode applyAccessContractExceptRuleRestrictionsForObjectGroupForSelect(JsonNode queryDsl, AccessContractModel accessContract) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, accessContract, false, false);
        return parser.getRequest().getFinalSelect();
    }

    public static JsonNode applyAccessContractRestrictionForUnitForUpdate(JsonNode queryDsl, AccessContractModel accessContract) throws InvalidParseOperationException, InvalidCreateOperationException {
        UpdateParserMultiple parser = new UpdateParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, accessContract, true, true);
        return parser.getRequest().getFinalUpdate();
    }

    private static void applyAccessContractRestriction(RequestParserMultiple parser, AccessContractModel accessContract, boolean isUnit, boolean applyRuleRestrictions) throws InvalidCreateOperationException {
        Set excludedRootUnits;
        accessContract.initializeDefaultValue();
        BooleanQuery restrictionsForQuery = QueryHelper.and();
        String fieldToQuery = isUnit ? BuilderToken.PROJECTIONARGS.ID.exactToken() : BuilderToken.PROJECTIONARGS.UNITUPS.exactToken();
        Set rootUnits = accessContract.getRootUnits();
        if (CollectionUtils.isNotEmpty((Collection)rootUnits)) {
            restrictionsForQuery.add(new Query[]{AccessContractRestrictionHelper.getRootUnitsRestriction(rootUnits, fieldToQuery)});
        }
        if (CollectionUtils.isNotEmpty((Collection)(excludedRootUnits = accessContract.getExcludedRootUnits()))) {
            restrictionsForQuery.add(new Query[]{AccessContractRestrictionHelper.getExcludedRootUnitsRestriction(excludedRootUnits, fieldToQuery)});
        }
        AccessRightType accessRightType = AccessContractRestrictionHelper.getAccessRightType(accessContract);
        switch (accessRightType) {
            case ACCESS_FULL: {
                log.debug("no restriction on originating agencies");
                break;
            }
            case ACCESS_BY_PRODUCERS: {
                AccessContractRestrictionHelper.addRestrictionForOriginatingAgency(restrictionsForQuery, accessContract, isUnit);
                break;
            }
            case ACCESS_BY_EXPIRED_MANAGEMENT_RULES: {
                if (!applyRuleRestrictions) break;
                AccessContractRestrictionHelper.addRestrictionForManagementRules(restrictionsForQuery, accessContract);
                break;
            }
            case ACCESS_BY_PRODUCERS_AND_EXPIRED_MANAGEMENT_RULES: {
                if (applyRuleRestrictions) {
                    AccessContractRestrictionHelper.addRestrictionForOriginatingAgencyAndManagementRules(restrictionsForQuery, accessContract, isUnit);
                    break;
                }
                AccessContractRestrictionHelper.addRestrictionForOriginatingAgency(restrictionsForQuery, accessContract, isUnit);
                break;
            }
            case ACCESS_BY_PRODUCERS_OR_EXPIRED_MANAGEMENT_RULES: {
                if (applyRuleRestrictions) {
                    AccessContractRestrictionHelper.addRestrictionForOriginatingAgencyOrManagementRules(restrictionsForQuery, accessContract);
                    break;
                }
                if (!isUnit) break;
                AccessContractRestrictionHelper.addRestrictionForOriginatingAgency(restrictionsForQuery, accessContract, isUnit);
                break;
            }
            default: {
                throw new IllegalStateException("Access contract is ambigous: " + String.valueOf((Object)accessRightType));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)restrictionsForQuery.getQueries())) {
            ArrayList queryList = new ArrayList(parser.getRequest().getQueries());
            if (queryList.isEmpty()) {
                parser.getRequest().getQueries().add(restrictionsForQuery.setDepthLimit(0));
            } else {
                for (int i = 0; i < queryList.size(); ++i) {
                    Query query = (Query)queryList.get(i);
                    int depth = query.getParserRelativeDepth();
                    Query restrictedQuery = QueryHelper.and().add(new Query[]{restrictionsForQuery, query}).setDepthLimit(depth);
                    parser.getRequest().getQueries().set(i, restrictedQuery);
                }
            }
        }
    }

    private static Query getRootUnitsRestriction(Set<String> rootUnits, String fieldToQuery) throws InvalidCreateOperationException {
        String[] rootUnitsArray = rootUnits.toArray(new String[0]);
        return QueryHelper.or().add(new Query[]{QueryHelper.in((String)fieldToQuery, (String[])rootUnitsArray), QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ALLUNITUPS.exactToken(), (String[])rootUnitsArray)});
    }

    private static void addRestrictionForOriginatingAgency(BooleanQuery restrictionsForQuery, AccessContractModel accessContract, boolean isUnit) throws InvalidCreateOperationException {
        Query originatingAgencyRestriction = AccessContractRestrictionHelper.getOriginatingAgencyRestriction(accessContract);
        if (isUnit) {
            originatingAgencyRestriction = QueryHelper.or().add(new Query[]{AccessContractRestrictionHelper.skipFiling(accessContract.getDoNotFilterFilingSchemes()), originatingAgencyRestriction});
        }
        restrictionsForQuery.add(new Query[]{originatingAgencyRestriction});
    }

    private static void addRestrictionForManagementRules(BooleanQuery restrictionsForQuery, AccessContractModel accessContract) throws InvalidCreateOperationException {
        restrictionsForQuery.add(new Query[]{QueryHelper.or().add(new Query[]{AccessContractRestrictionHelper.skipFiling((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{accessContract.getSkipFilingSchemeRuleCategoryFilter(), accessContract.getDoNotFilterFilingSchemes()})), AccessContractRestrictionHelper.getRuleCategoryRestriction(accessContract)})});
    }

    private static void addRestrictionForOriginatingAgencyOrManagementRules(BooleanQuery restrictionsForQuery, AccessContractModel accessContract) throws InvalidCreateOperationException {
        BooleanQuery categoryRestrictionOrSkipedUnit = QueryHelper.or().add(new Query[]{AccessContractRestrictionHelper.skipFiling((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{accessContract.getSkipFilingSchemeRuleCategoryFilter(), accessContract.getDoNotFilterFilingSchemes()})), AccessContractRestrictionHelper.getRuleCategoryForTheOtherOriginatingAgenciesRestriction(accessContract)});
        BooleanQuery originatingAgencyRestrictionOrSkipedUnit = QueryHelper.or().add(new Query[]{AccessContractRestrictionHelper.skipFiling(accessContract.getDoNotFilterFilingSchemes()), AccessContractRestrictionHelper.getOriginatingAgencyRestriction(accessContract)});
        restrictionsForQuery.add(new Query[]{QueryHelper.or().add(new Query[]{originatingAgencyRestrictionOrSkipedUnit, categoryRestrictionOrSkipedUnit})});
    }

    private static void addRestrictionForOriginatingAgencyAndManagementRules(BooleanQuery restrictionsForQuery, AccessContractModel accessContract, boolean isUnit) throws InvalidCreateOperationException {
        BooleanQuery categoryRestrictionOrSkipedUnit = QueryHelper.or().add(new Query[]{AccessContractRestrictionHelper.skipFiling((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{accessContract.getSkipFilingSchemeRuleCategoryFilter(), accessContract.getDoNotFilterFilingSchemes()})), AccessContractRestrictionHelper.getRuleCategoryRestriction(accessContract)});
        Query originatingAgencyRestrictionOrSkipedUnit = AccessContractRestrictionHelper.getOriginatingAgencyRestriction(accessContract);
        if (isUnit) {
            originatingAgencyRestrictionOrSkipedUnit = QueryHelper.or().add(new Query[]{AccessContractRestrictionHelper.skipFiling(accessContract.getDoNotFilterFilingSchemes()), originatingAgencyRestrictionOrSkipedUnit});
        }
        restrictionsForQuery.add(new Query[]{originatingAgencyRestrictionOrSkipedUnit, categoryRestrictionOrSkipedUnit});
    }

    private static Query getExcludedRootUnitsRestriction(Set<String> excludedRootUnits, String fieldToQuery) throws InvalidCreateOperationException {
        String[] excludedRootUnitsArray = excludedRootUnits.toArray(new String[0]);
        return QueryHelper.and().add(new Query[]{QueryHelper.nin((String)fieldToQuery, (String[])excludedRootUnitsArray), QueryHelper.nin((String)BuilderToken.PROJECTIONARGS.ALLUNITUPS.exactToken(), (String[])excludedRootUnitsArray)});
    }

    private static Query getRuleRestriction(Set<RuleType> rules) throws InvalidCreateOperationException {
        if (rules.size() == 1) {
            return QueryHelper.lt((String)AccessContractRestrictionHelper.fieldName(rules.iterator().next()), (String)LocalDateUtil.todayFormatted());
        }
        BooleanQuery categoryRestriction = QueryHelper.and();
        for (RuleType ruleType : rules) {
            categoryRestriction.add(new Query[]{QueryHelper.lt((String)AccessContractRestrictionHelper.fieldName(ruleType), (String)LocalDateUtil.todayFormatted())});
        }
        return categoryRestriction;
    }

    private static Query getRuleCategoryRestriction(AccessContractModel accessContract) throws InvalidCreateOperationException {
        return AccessContractRestrictionHelper.getRuleRestriction(accessContract.getRuleCategoryToFilter());
    }

    private static Query getRuleCategoryForTheOtherOriginatingAgenciesRestriction(AccessContractModel accessContract) throws InvalidCreateOperationException {
        return AccessContractRestrictionHelper.getRuleRestriction(accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies());
    }

    private static String fieldName(RuleType ruleType) {
        return BuilderToken.PROJECTIONARGS.COMPUTED_INHERITED_RULES.exactToken() + "." + ruleType.name() + ".MaxEndDate";
    }

    private static Query getOriginatingAgencyRestriction(AccessContractModel accessContract) throws InvalidCreateOperationException {
        return QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ORIGINATING_AGENCIES.exactToken(), (String[])accessContract.getOriginatingAgencies().toArray(new String[0]));
    }

    private static Query skipFiling(boolean skipFilingScheme) throws InvalidCreateOperationException {
        if (skipFilingScheme) {
            return QueryHelper.in((String)VitamFieldsHelper.unitType(), (String[])new String[]{UnitType.FILING_UNIT.name(), UnitType.HOLDING_UNIT.name()});
        }
        return QueryHelper.eq((String)VitamFieldsHelper.unitType(), (String)UnitType.HOLDING_UNIT.name());
    }

    public static AccessRightType getAccessRightType(AccessContractModel accessContract) {
        if (accessContract.getEveryOriginatingAgency().booleanValue() && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilter()) && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies())) {
            return AccessRightType.ACCESS_FULL;
        }
        if (accessContract.getEveryOriginatingAgency().booleanValue() && CollectionUtils.isNotEmpty((Collection)accessContract.getRuleCategoryToFilter()) && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies())) {
            return AccessRightType.ACCESS_BY_EXPIRED_MANAGEMENT_RULES;
        }
        if (!accessContract.getEveryOriginatingAgency().booleanValue() && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilter()) && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies())) {
            return AccessRightType.ACCESS_BY_PRODUCERS;
        }
        if (!accessContract.getEveryOriginatingAgency().booleanValue() && CollectionUtils.isNotEmpty((Collection)accessContract.getRuleCategoryToFilter()) && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies())) {
            return AccessRightType.ACCESS_BY_PRODUCERS_AND_EXPIRED_MANAGEMENT_RULES;
        }
        if (!accessContract.getEveryOriginatingAgency().booleanValue() && CollectionUtils.isEmpty((Collection)accessContract.getRuleCategoryToFilter()) && CollectionUtils.isNotEmpty((Collection)accessContract.getRuleCategoryToFilterForTheOtherOriginatingAgencies())) {
            return AccessRightType.ACCESS_BY_PRODUCERS_OR_EXPIRED_MANAGEMENT_RULES;
        }
        return AccessRightType.UNKNOWN;
    }
}

