/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.elasticsearch;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class QueryToElasticsearch {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(QueryToElasticsearch.class);

    private QueryToElasticsearch() {
    }

    public static Query getRoots(String field, Collection<String> roots) {
        return ElasticsearchUtil.termsQuery(field, roots);
    }

    public static void addRoots(BoolQuery.Builder query, String field, Collection<String> roots, int depth) {
        query.filter(ElasticsearchUtil.boolShould(IntStream.rangeClosed(1, depth).mapToObj(i -> ElasticsearchUtil.termsQuery(field + "." + i, roots)).collect(Collectors.toList())), new Query[0]);
    }

    public static Query getFullCommand(Query command, Query roots) {
        return ElasticsearchUtil.boolMust(command, roots);
    }

    public static List<SortOptions> getSorts(AbstractParser<?> requestParser, boolean score, DynamicParserTokens parserTokens) {
        int size;
        JsonNode orderby = requestParser.getRequest().getFilter().get(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
        int n = size = score && requestParser.hasFullTextQuery() ? 1 : 0;
        if (orderby != null && !orderby.isEmpty()) {
            size += orderby.size();
        }
        ArrayList<SortOptions> sorts = new ArrayList<SortOptions>(size);
        if (orderby == null || orderby.isEmpty()) {
            if (score && requestParser.hasFullTextQuery()) {
                sorts.add(ElasticsearchUtil.getScoreSort(SortOrder.Desc));
                return sorts;
            }
            return null;
        }
        Iterator iterator = orderby.fields();
        if (!iterator.hasNext()) {
            if (score && requestParser.hasFullTextQuery()) {
                sorts.add(ElasticsearchUtil.getScoreSort(SortOrder.Desc));
                return sorts;
            }
            return null;
        }
        boolean scoreNotAdded = true;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            if (scoreNotAdded && score && requestParser.hasFullTextQuery() && !parserTokens.isNotAnalyzed((String)entry.getKey())) {
                scoreNotAdded = false;
                if ("_score".equals(entry.getKey()) || "#score".equals(entry.getKey())) {
                    if (((JsonNode)entry.getValue()).asInt() < 0) {
                        sorts.add(ElasticsearchUtil.getScoreSort(SortOrder.Desc));
                        continue;
                    }
                    sorts.add(ElasticsearchUtil.getScoreSort(SortOrder.Asc));
                    continue;
                }
                sorts.add(ElasticsearchUtil.getScoreSort(SortOrder.Desc));
            }
            if (((JsonNode)entry.getValue()).asInt() < 0) {
                sorts.add(ElasticsearchUtil.getFieldSorts(key, SortOrder.Desc));
                continue;
            }
            sorts.add(ElasticsearchUtil.getFieldSorts(key, SortOrder.Asc));
        }
        if (scoreNotAdded && score && requestParser.hasFullTextQuery()) {
            sorts.add(ElasticsearchUtil.getScoreSort(SortOrder.Desc));
        }
        return sorts;
    }

    public static Query getCommand(fr.gouv.vitam.common.database.builder.query.Query query, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        BuilderToken.QUERY req = query.getQUERY();
        JsonNode content = query.getNode(req.exactToken());
        switch (req) {
            case AND: 
            case NOT: 
            case OR: {
                return QueryToElasticsearch.andOrNotCommand(req, query, adapter, parserTokens);
            }
            case EXISTS: 
            case MISSING: {
                return QueryToElasticsearch.existsMissingCommand(req, content);
            }
            case MATCH: 
            case MATCH_ALL: 
            case MATCH_PHRASE: 
            case MATCH_PHRASE_PREFIX: {
                return QueryToElasticsearch.matchCommand(req, content, parserTokens);
            }
            case SEARCH: {
                return QueryToElasticsearch.searchCommand(req, content, parserTokens);
            }
            case SUBOBJECT: {
                return QueryToElasticsearch.nestedSearchCommand(req, content, adapter, parserTokens);
            }
            case NIN: 
            case IN: {
                return QueryToElasticsearch.inCommand(req, content, parserTokens);
            }
            case RANGE: {
                return QueryToElasticsearch.rangeCommand(req, content, parserTokens);
            }
            case REGEX: {
                return QueryToElasticsearch.regexCommand(req, content, parserTokens);
            }
            case TERM: {
                return QueryToElasticsearch.termCommand(req, content, parserTokens);
            }
            case WILDCARD: {
                return QueryToElasticsearch.wildcardCommand(req, content, parserTokens);
            }
            case EQ: 
            case NE: {
                return QueryToElasticsearch.eqCommand(req, content, parserTokens);
            }
            case GT: 
            case GTE: 
            case LT: 
            case LTE: {
                return QueryToElasticsearch.compareCommand(req, content, parserTokens);
            }
            case ISNULL: {
                return QueryToElasticsearch.isNullCommand(req, content);
            }
            case SIZE: {
                return QueryToElasticsearch.sizeCommand(req, content);
            }
            case NOP: {
                return ElasticsearchUtil.matchAll();
            }
        }
        throw new InvalidParseOperationException("Invalid command: " + req.exactToken());
    }

    private static Query sizeCommand(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        Script script = Script.of(s -> s.inline(i -> i.source("doc['" + (String)element.getKey() + "'].values.length == " + String.valueOf(element.getValue()))));
        if (((String)element.getKey()).equals("_id")) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        return QueryBuilders.script().script(script).build()._toQuery();
    }

    private static Query compareCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        JsonNode node = (JsonNode)element.getValue();
        Object value = GlobalDatasParser.getValue(node);
        switch (query) {
            case GT: {
                return ElasticsearchUtil.gtQuery(key, value);
            }
            case GTE: {
                return ElasticsearchUtil.gteQuery(key, value);
            }
            case LT: {
                return ElasticsearchUtil.ltQuery(key, value);
            }
        }
        return ElasticsearchUtil.lteQuery(key, value);
    }

    private static Query searchCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String attribute = (String)element.getKey();
        if (parserTokens.isNotAnalyzed(attribute)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Not_analyzed field: '" + attribute + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        return ElasticsearchUtil.simpleQueryString(attribute, ((JsonNode)element.getValue()).asText());
    }

    private static Query nestedSearchCommand(BuilderToken.QUERY query, JsonNode content, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        fr.gouv.vitam.common.database.builder.query.Query subQuery;
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String attribute = (String)element.getKey();
        if (parserTokens.isNotAnalyzed(attribute)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Not_analyzed field: '" + attribute + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        if (content == null || !content.fields().hasNext() || !((JsonNode)((Map.Entry)content.fields().next()).getValue()).fields().hasNext()) {
            throw new InvalidParseOperationException("$subobject query is not valid");
        }
        String path = (String)((Map.Entry)content.fields().next()).getKey();
        JsonNode subQueryJson = (JsonNode)((Map.Entry)content.fields().next()).getValue();
        try {
            subQuery = QueryParserHelper.query((String)((Map.Entry)subQueryJson.fields().next()).getKey(), (JsonNode)((Map.Entry)subQueryJson.fields().next()).getValue(), adapter);
        }
        catch (InvalidCreateOperationException e) {
            throw new InvalidParseOperationException("$subobject query is not valid");
        }
        return ElasticsearchUtil.nestedQuery(path, QueryToElasticsearch.getCommand(subQuery, adapter, parserTokens));
    }

    private static Query matchCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        JsonNode max = ((ObjectNode)content).remove(BuilderToken.QUERYARGS.MAX_EXPANSIONS.exactToken());
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String attribute = (String)element.getKey();
        if (parserTokens.isNotAnalyzed(attribute)) {
            return QueryToElasticsearch.matchCommandOverNonAnalyzedField(query, content, element, attribute);
        }
        if (max != null && !max.isMissingNode()) {
            return QueryToElasticsearch.matchCommandWithMaxExpansions(query, content, max, element);
        }
        QueryToElasticsearch.logCommand(query, content);
        switch (query) {
            case MATCH: {
                return ElasticsearchUtil.matchQuery((String)element.getKey(), ((JsonNode)element.getValue()).asText());
            }
            case MATCH_ALL: {
                return ElasticsearchUtil.matchAllQuery((String)element.getKey(), ((JsonNode)element.getValue()).asText());
            }
            case MATCH_PHRASE: {
                return ElasticsearchUtil.matchPhraseQuery((String)element.getKey(), ((JsonNode)element.getValue()).asText());
            }
            case MATCH_PHRASE_PREFIX: {
                return ElasticsearchUtil.matchPhrasePrefixQuery((String)element.getKey(), ((JsonNode)element.getValue()).asText());
            }
        }
        throw new InvalidParseOperationException("Not correctly parsed: " + String.valueOf(query));
    }

    private static Query matchCommandWithMaxExpansions(BuilderToken.QUERY query, JsonNode content, JsonNode max, Map.Entry<String, JsonNode> element) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Unsupported max_expansions operator");
        switch (query) {
            case MATCH: {
                return ElasticsearchUtil.matchQuery(element.getKey(), element.getValue().asText(), max.asInt());
            }
            case MATCH_ALL: {
                return ElasticsearchUtil.matchAllQuery(element.getKey(), element.getValue().asText(), max.asInt());
            }
            case MATCH_PHRASE: {
                return ElasticsearchUtil.matchPhraseQuery(element.getKey(), element.getValue().asText());
            }
            case MATCH_PHRASE_PREFIX: {
                return ElasticsearchUtil.matchPhrasePrefixQuery(element.getKey(), element.getValue().asText(), max.asInt());
            }
        }
        throw new InvalidParseOperationException("Not correctly parsed: " + String.valueOf(query));
    }

    private static Query matchCommandOverNonAnalyzedField(BuilderToken.QUERY query, JsonNode content, Map.Entry<String, JsonNode> element, String attribute) {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Not_analyzed field: '" + attribute + "'");
        switch (query) {
            case MATCH: {
                return ElasticsearchUtil.termsQuery(element.getKey(), element.getValue().toString().split(" "));
            }
        }
        return ElasticsearchUtil.termQuery(element.getKey(), element.getValue().toString());
    }

    private static Query inCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            return QueryToElasticsearch.inCommandOverAnalyzedField(query, content);
        }
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        JsonNode node = (JsonNode)element.getValue();
        if (node instanceof ArrayNode) {
            QueryToElasticsearch.logCommand(query, content);
            for (Object jsonNode : node) {
                nodes.add((JsonNode)jsonNode);
            }
        } else {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Expecting value list");
            nodes.add(node);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (JsonNode value : nodes) {
            set.add(QueryToElasticsearch.getAsObject(value));
        }
        Query query2 = QueryBuilders.terms().field(key).terms(tt -> tt.value(set.stream().map(value -> FieldValue.of((JsonData)JsonData.of((Object)value))).collect(Collectors.toList()))).build()._toQuery();
        if (query == BuilderToken.QUERY.NIN) {
            return ElasticsearchUtil.mustNot(query2);
        }
        return query2;
    }

    private static Query inCommandOverAnalyzedField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        ArrayList<Object> nodes = new ArrayList<Object>();
        JsonNode node = (JsonNode)element.getValue();
        if (node instanceof ArrayNode) {
            for (Object jsonNode : node) {
                nodes.add(jsonNode);
            }
        } else {
            nodes.add(node);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (JsonNode jsonNode : nodes) {
            set.add(QueryToElasticsearch.getAsObject(jsonNode));
        }
        BoolQuery.Builder builder = new BoolQuery.Builder().minimumShouldMatch("1");
        for (Object e : set) {
            builder.should(QueryBuilders.match(m -> m.field(key).query(FieldValue.of((JsonData)JsonData.of((Object)object))).operator(Operator.Or)), new Query[0]);
        }
        Query query2 = builder.build()._toQuery();
        if (query == BuilderToken.QUERY.NIN) {
            return ElasticsearchUtil.mustNot(query2);
        }
        return query2;
    }

    private static Query rangeCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        if ("_id".equals(key)) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        RangeQuery.Builder range = QueryBuilders.range().field(key);
        Iterator iterator = ((JsonNode)element.getValue()).fields();
        block7: while (iterator.hasNext()) {
            BuilderToken.RANGEARGS arg;
            Map.Entry requestItem = (Map.Entry)iterator.next();
            try {
                String skey = (String)requestItem.getKey();
                if (!skey.startsWith("$")) {
                    throw new InvalidParseOperationException("Invalid Range query command: " + String.valueOf(requestItem));
                }
                arg = BuilderToken.RANGEARGS.valueOf((String)skey.substring(1).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidParseOperationException("Invalid Range query command: " + String.valueOf(requestItem), (Throwable)e);
            }
            JsonNode node = (JsonNode)requestItem.getValue();
            switch (arg) {
                case GT: {
                    range.gt(JsonData.of((Object)QueryToElasticsearch.getAsObject(node)));
                    continue block7;
                }
                case GTE: {
                    range.gte(JsonData.of((Object)QueryToElasticsearch.getAsObject(node)));
                    continue block7;
                }
                case LT: {
                    range.lt(JsonData.of((Object)QueryToElasticsearch.getAsObject(node)));
                    continue block7;
                }
            }
            range.lte(JsonData.of((Object)QueryToElasticsearch.getAsObject(node)));
        }
        return range.build()._toQuery();
    }

    private static Query regexCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            return QueryToElasticsearch.regexCommandOverAnalyzedField(query, content);
        }
        if (key.equals("_id")) {
            return QueryToElasticsearch.regexCommandOverIdField(query, content);
        }
        String value = ((JsonNode)entry.getValue()).asText();
        QueryToElasticsearch.logCommand(query, content);
        return ElasticsearchUtil.regex(key, value);
    }

    private static Query regexCommandOverIdField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Unsupported ID field");
        String value = ((JsonNode)entry.getValue()).asText().replaceAll("[\\.\\?\\+\\*\\|\\{\\}\\[\\]\\(\\)\\\"\\\\\\#\\@\\&\\<\\>\\~]", " ");
        String[] values = QueryToElasticsearch.removeAllDoubleSpace(value).split(" ");
        return QueryBuilders.terms(t -> t.field(key).terms(tt -> tt.value(Arrays.stream(values).map(FieldValue::of).collect(Collectors.toList()))));
    }

    private static Query regexCommandOverAnalyzedField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        String value = "/" + ((JsonNode)entry.getValue()).asText() + "/";
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        return ElasticsearchUtil.regex(key, value);
    }

    private static Query termCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
        boolean multiple = false;
        BoolQuery.Builder query2 = null;
        if (content.size() > 1) {
            multiple = true;
            query2 = QueryBuilders.bool();
        }
        Iterator iterator = content.fields();
        while (iterator.hasNext()) {
            JsonNode node;
            Map.Entry requestItem = (Map.Entry)iterator.next();
            String key = (String)requestItem.getKey();
            if ("_id".equals(key)) {
                QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
            }
            if ((node = (JsonNode)requestItem.getValue()).isNumber()) {
                if (!multiple) {
                    return QueryBuilders.term(t -> t.field(key).value(FieldValue.of((JsonData)JsonData.of((Object)QueryToElasticsearch.getAsObject(node)))));
                }
                query2.must(QueryBuilders.term(t -> t.field(key).value(FieldValue.of((JsonData)JsonData.of((Object)QueryToElasticsearch.getAsObject(node))))), new Query[0]);
                continue;
            }
            String val = node.asText();
            Query query3 = parserTokens.isNotAnalyzed(key) ? ElasticsearchUtil.termQuery(key, val) : ElasticsearchUtil.matchAllQuery(key, val);
            if (!multiple) {
                return query3;
            }
            query2.must(query3, new Query[0]);
        }
        return query2.build()._toQuery();
    }

    private static Query wildcardCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        JsonNode node = (JsonNode)entry.getValue();
        String val = node.asText();
        if (!parserTokens.isNotAnalyzed(key)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        } else if (key.equals("_id")) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Unsupported ID field");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        return ElasticsearchUtil.wildcard(key, val);
    }

    @Deprecated
    private static String removeAllDoubleSpace(String value) {
        String oldValue = value;
        String newValue = oldValue.replace("  ", " ");
        while (newValue.length() != oldValue.length()) {
            oldValue = newValue;
            newValue = oldValue.replace("  ", " ");
        }
        return newValue;
    }

    private static Query eqCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        JsonNode node = (JsonNode)entry.getValue();
        if (!parserTokens.isNotAnalyzed(key)) {
            return QueryToElasticsearch.eqCommandOverAnalyzedField(query, content);
        }
        QueryToElasticsearch.logCommand(query, content);
        Query query2 = QueryBuilders.term(t -> t.field(key).value(FieldValue.of((JsonData)JsonData.of((Object)QueryToElasticsearch.getAsObject(node)))));
        if (query == BuilderToken.QUERY.NE) {
            return ElasticsearchUtil.mustNot(query2);
        }
        return query2;
    }

    private static Query eqCommandOverAnalyzedField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        JsonNode node = (JsonNode)entry.getValue();
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        Query query2 = QueryBuilders.match(m -> m.field(key).query(FieldValue.of((JsonData)JsonData.of((Object)QueryToElasticsearch.getAsObject(node)))).operator(Operator.And));
        if (query == BuilderToken.QUERY.NE) {
            return ElasticsearchUtil.mustNot(query2);
        }
        return query2;
    }

    private static Query existsMissingCommand(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        String fieldname = content.asText();
        if ("_id".equals(fieldname)) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        Query existsQuery = ElasticsearchUtil.exists(fieldname);
        switch (query) {
            case MISSING: {
                QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
                return ElasticsearchUtil.mustNot(existsQuery);
            }
            case EXISTS: {
                QueryToElasticsearch.logCommand(query, content);
                return existsQuery;
            }
        }
        throw new InvalidParseOperationException("Not correctly parsed: " + String.valueOf(query));
    }

    private static Query isNullCommand(BuilderToken.QUERY query, JsonNode content) {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
        String fieldname = content.asText();
        if ("_id".equals(fieldname)) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        return ElasticsearchUtil.mustNot(ElasticsearchUtil.exists(fieldname));
    }

    private static Query andOrNotCommand(BuilderToken.QUERY query, fr.gouv.vitam.common.database.builder.query.Query req, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        QueryToElasticsearch.logCommand(query, req.getCurrentObject());
        BooleanQuery nthrequest = (BooleanQuery)req;
        List sub = nthrequest.getQueries();
        BoolQuery.Builder boolQueryBuilder = QueryBuilders.bool();
        block4: for (fr.gouv.vitam.common.database.builder.query.Query value : sub) {
            switch (query) {
                case AND: {
                    boolQueryBuilder.must(QueryToElasticsearch.getCommand(value, adapter, parserTokens), new Query[0]);
                    continue block4;
                }
                case NOT: {
                    boolQueryBuilder.mustNot(QueryToElasticsearch.getCommand(value, adapter, parserTokens), new Query[0]);
                    continue block4;
                }
            }
            boolQueryBuilder.minimumShouldMatch("1").should(QueryToElasticsearch.getCommand(value, adapter, parserTokens), new Query[0]);
        }
        return boolQueryBuilder.build()._toQuery();
    }

    public static Map<String, Aggregation> getFacets(AbstractParser<?> requestParser, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        HashMap<String, Aggregation> aggregations = new HashMap<String, Aggregation>();
        if (requestParser.getRequest() instanceof SelectMultiQuery) {
            List facets = ((SelectMultiQuery)requestParser.getRequest()).getFacets();
            block5: for (Facet facet : facets) {
                switch (facet.getCurrentTokenFACET()) {
                    case TERMS: {
                        QueryToElasticsearch.termsFacet(aggregations, facet);
                        continue block5;
                    }
                    case DATE_RANGE: {
                        QueryToElasticsearch.dateRangeFacet(aggregations, facet);
                        continue block5;
                    }
                    case FILTERS: {
                        QueryToElasticsearch.filtersFacet(aggregations, facet, requestParser.getAdapter(), parserTokens);
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf(facet.getCurrentTokenFACET()));
            }
        }
        return aggregations;
    }

    private static void dateRangeFacet(Map<String, Aggregation> aggregations, Facet facet) {
        JsonNode dateRange = facet.getCurrentFacet().get(facet.getCurrentTokenFACET().exactToken());
        DateRangeAggregation.Builder dateRangeBuilder = AggregationBuilders.dateRange();
        dateRangeBuilder.field(dateRange.get(BuilderToken.FACETARGS.FIELD.exactToken()).asText());
        dateRangeBuilder.format(dateRange.get(BuilderToken.FACETARGS.FORMAT.exactToken()).asText());
        JsonNode ranges = dateRange.get(BuilderToken.FACETARGS.RANGES.exactToken());
        ranges.forEach(item -> {
            JsonNode from = item.get(BuilderToken.FACETARGS.FROM.exactToken());
            JsonNode to = item.get(BuilderToken.FACETARGS.TO.exactToken());
            if (from != null && !(from instanceof NullNode) && to != null && !(to instanceof NullNode)) {
                dateRangeBuilder.ranges(r -> r.from(o -> o.expr(from.asText())).to(o -> o.expr(to.asText())));
            } else if (from != null && !(from instanceof NullNode)) {
                dateRangeBuilder.ranges(r -> r.from(o -> o.expr(from.asText())));
            } else if (to != null && !(to instanceof NullNode)) {
                dateRangeBuilder.ranges(r -> r.to(o -> o.expr(to.asText())));
            }
        });
        if (dateRange.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()) != null) {
            aggregations.put(facet.getName(), new Aggregation.Builder().nested(n -> n.path(dateRange.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()).asText())).aggregations(facet.getName(), dateRangeBuilder.build()._toAggregation()).build());
            return;
        }
        aggregations.put(facet.getName(), dateRangeBuilder.build()._toAggregation());
    }

    private static void termsFacet(Map<String, Aggregation> aggregations, Facet facet) {
        JsonNode terms = facet.getCurrentFacet().get(facet.getCurrentTokenFACET().exactToken());
        String fieldName = terms.get(BuilderToken.FACETARGS.FIELD.exactToken()).asText();
        TermsAggregation.Builder termsBuilder = AggregationBuilders.terms();
        termsBuilder.field(fieldName);
        if (terms.has(BuilderToken.FACETARGS.SIZE.exactToken())) {
            int size = terms.get(BuilderToken.FACETARGS.SIZE.exactToken()).asInt();
            termsBuilder.size(Integer.valueOf(size));
            termsBuilder.shardSize(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, (long)size * 3L + 10L)));
        }
        if (terms.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()) != null) {
            aggregations.put(facet.getName(), new Aggregation.Builder().nested(n -> n.path(terms.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()).asText())).aggregations(facet.getName(), termsBuilder.build()._toAggregation()).build());
            return;
        }
        aggregations.put(facet.getName(), termsBuilder.build()._toAggregation());
    }

    private static void filtersFacet(Map<String, Aggregation> aggregations, Facet facet, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        JsonNode filtersFacetNode = facet.getCurrentFacet().get(facet.getCurrentTokenFACET().exactToken());
        HashMap<String, fr.gouv.vitam.common.database.builder.query.Query> filtersMap = new HashMap<String, fr.gouv.vitam.common.database.builder.query.Query>();
        ArrayNode filtersNode = (ArrayNode)filtersFacetNode.get(BuilderToken.FACETARGS.QUERY_FILTERS.exactToken());
        for (Object node : filtersNode) {
            String string = node.get(BuilderToken.FACETARGS.NAME.exactToken()).asText();
            JsonNode queryNode = node.get(BuilderToken.FACETARGS.QUERY.exactToken());
            Map.Entry queryItem = JsonHandler.checkUnicity((String)"RootRequest", (JsonNode)queryNode);
            try {
                fr.gouv.vitam.common.database.builder.query.Query query = QueryParserHelper.query((String)queryItem.getKey(), (JsonNode)queryItem.getValue(), adapter);
                filtersMap.put(string, query);
            }
            catch (InvalidCreateOperationException e) {
                throw new InvalidParseOperationException((Throwable)e);
            }
        }
        HashMap<String, Query> keyFilters = new HashMap<String, Query>();
        for (Map.Entry entry : filtersMap.entrySet()) {
            keyFilters.put((String)entry.getKey(), QueryToElasticsearch.getCommand((fr.gouv.vitam.common.database.builder.query.Query)entry.getValue(), adapter, parserTokens));
        }
        Aggregation filtersBuilder = AggregationBuilders.filters(f -> f.filters(b -> b.keyed(keyFilters)));
        aggregations.put(facet.getName(), filtersBuilder);
    }

    private static Object getAsObject(JsonNode value) {
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isInt() || value.isLong()) {
            return value.asLong();
        }
        if (value.isFloat() || value.isDouble()) {
            return value.asDouble();
        }
        return value.asText();
    }

    private static void logCommand(BuilderToken.QUERY query, JsonNode content) {
        LOGGER.debug(String.format("Command #QUERY: %s . Content: %s", query, content));
    }

    private static void logWarnUnsupportedIdForCommand(BuilderToken.QUERY query, JsonNode content) {
        LOGGER.warn(String.format("Command #QUERY: %s using id is not recommended. Content: %s", query, content));
    }

    private static void logUnsupportedCommand(BuilderToken.QUERY query, JsonNode content, String message) {
        LOGGER.warn(String.format("UNSUPPORTED command #QUERY: %s. Message: %s. Content: %s", query, message, content));
    }
}

