/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.mongodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.JsonFlattener;
import difflib.DiffUtils;
import difflib.Patch;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public abstract class VitamDocument<E>
extends Document {
    private static final long serialVersionUID = 4051636259488359930L;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamDocument.class);
    private static final String REGEX = "^[+\\-]\\s+.*";
    public static final String ID = "_id";
    public static final String VERSION = "_v";
    public static final String TENANT_ID = "_tenant";
    public static final String SCORE = "_score";
    public static final String SEDAVERSION = "_sedaVersion";
    public static final String IMPLEMENTATIONVERSION = "_implementationVersion";
    public static final String[] ES_FILTER_OUT = new String[]{"_id", "_tenant", "_score"};

    public VitamDocument() {
    }

    public VitamDocument(String content) {
        super((Map)Document.parse((String)content));
        this.checkId();
    }

    public VitamDocument(JsonNode content) {
        super((Map)Document.parse((String)JsonHandler.unprettyPrint((Object)content)));
        this.checkId();
    }

    public VitamDocument(Document content) {
        super((Map)content);
        this.checkId();
    }

    public abstract VitamDocument<E> newInstance(JsonNode var1);

    protected VitamDocument<E> checkId() {
        String id = this.getId();
        if (id == null) {
            id = this.getString(ID);
        }
        this.append(ID, id);
        try {
            GUIDReader.getGUID((String)id);
        }
        catch (InvalidGuidOperationException e) {
            LOGGER.error("ID is not a GUID: " + id, (Throwable)e);
            throw new IllegalArgumentException("ID is not a GUID: " + id, e);
        }
        return this;
    }

    public String getId() {
        return this.getString(ID);
    }

    public final Integer getTenantId() {
        return this.getInteger(TENANT_ID);
    }

    public final Integer getVersion() {
        return this.getInteger(VERSION);
    }

    public String toStringDirect() {
        return super.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + super.toString();
    }

    public static List<String> getUnifiedDiff(String original, String revised) {
        List<String> beforeList = Arrays.asList(VitamDocument.flattenJson(original).split(",\\n|\\n"));
        List<String> revisedList = Arrays.asList(VitamDocument.flattenJson(revised).split(",\\n|\\n"));
        Patch patch = DiffUtils.diff(beforeList, revisedList);
        return DiffUtils.generateUnifiedDiff((String)original, (String)revised, beforeList, (Patch)patch, (int)1);
    }

    private static String flattenJson(String original) {
        try {
            return JsonHandler.prettyPrint((Object)JsonHandler.getFromString((String)new JsonFlattener(original).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS).flatten()));
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<String> getConcernedDiffLines(List<String> diff) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : diff) {
            if (!line.matches(REGEX)) continue;
            if (line.endsWith("\",")) {
                result.add(StringUtils.substringBeforeLast((String)line, (String)"\","));
                continue;
            }
            if (line.endsWith(",")) {
                result.add(StringUtils.substringBeforeLast((String)line, (String)","));
                continue;
            }
            result.add(line);
        }
        return result;
    }

    public static List<String> getOriginalDiffLines(String diff) {
        List<String> diffArray = List.of(diff.split("\n"));
        List originalArray = diffArray.stream().filter(e -> !e.startsWith("+")).map(e -> e.replace("- ", "")).collect(Collectors.toList());
        List revisedArray = diffArray.stream().filter(e -> !e.startsWith("-")).map(e -> e.replace("+ ", "")).collect(Collectors.toList());
        String original = "--- " + originalArray.toString();
        String revised = "+++ " + revisedArray.toString();
        ArrayList<String> diffResult = new ArrayList<String>();
        diffResult.add(original);
        diffResult.add(revised);
        diffResult.addAll(diffArray);
        return diffResult;
    }
}

