/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.mongodb;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.Map;
import org.bson.Document;

public class BsonHelper {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = BsonHelper.buildObjectMapper();

    private static final ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper(JSON_FACTORY);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configOverride(Map.class).setIncludeAsProperty(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.ALWAYS, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true);
        objectMapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
        objectMapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        return objectMapper;
    }

    public static String stringify(Document document) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)document);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode fromDocumentToJsonNode(Document object) throws InvalidParseOperationException {
        try {
            return OBJECT_MAPPER.valueToTree((Object)object);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
    }

    public static <T> T fromDocumentToObject(Document document, Class<T> clasz) throws InvalidParseOperationException {
        try {
            return (T)OBJECT_MAPPER.convertValue((Object)document, clasz);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
    }

    public static <T> T fromDocumentToObject(Document document, TypeReference<T> typeReference) throws InvalidParseOperationException {
        try {
            return (T)OBJECT_MAPPER.convertValue((Object)document, typeReference);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
    }
}

