/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.json.JsonData;
import fr.gouv.vitam.common.exception.DatabaseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class ElasticsearchUtil {
    public static Query matchAll() {
        return QueryBuilders.matchAll().build()._toQuery();
    }

    public static Query termQuery(String key, int value) {
        return QueryBuilders.term(t -> t.field(key).value((long)value));
    }

    public static Query termQuery(String key, long value) {
        return QueryBuilders.term(t -> t.field(key).value(value));
    }

    public static Query termQuery(String key, boolean value) {
        return QueryBuilders.term(t -> t.field(key).value(value));
    }

    public static Query termQuery(String key, String value) {
        return QueryBuilders.term(t -> t.field(key).value(value));
    }

    public static Query termsQuery(String key, String ... values) {
        return QueryBuilders.terms(builder -> builder.field(key).terms(v -> v.value(Arrays.stream(values).map(FieldValue::of).collect(Collectors.toList()))));
    }

    public static Query termsQuery(String key, Collection<String> values) {
        return QueryBuilders.terms(builder -> builder.field(key).terms(v -> v.value(values.stream().map(FieldValue::of).collect(Collectors.toList()))));
    }

    public static Query lteQuery(String key, Object value) {
        return QueryBuilders.range(r -> r.field(key).lte(JsonData.of((Object)value)));
    }

    public static Query ltQuery(String key, Object value) {
        return QueryBuilders.range(r -> r.field(key).lt(JsonData.of((Object)value)));
    }

    public static Query gteQuery(String key, Object value) {
        return QueryBuilders.range(r -> r.field(key).gte(JsonData.of((Object)value)));
    }

    public static Query gtQuery(String key, Object value) {
        return QueryBuilders.range(r -> r.field(key).gt(JsonData.of((Object)value)));
    }

    public static Query rangeInclusiveQuery(String key, int minInclusive, int maxInclusive) {
        return QueryBuilders.range(r -> r.field(key).gte(JsonData.of((Object)minInclusive)).lte(JsonData.of((Object)maxInclusive)));
    }

    public static Query boolMust(Query ... queries) {
        BoolQuery.Builder bool = QueryBuilders.bool();
        for (Query query : queries) {
            bool.must(query, new Query[0]);
        }
        return bool.build()._toQuery();
    }

    public static Query boolShould(Query ... queries) {
        BoolQuery.Builder bool = QueryBuilders.bool();
        for (Query query : queries) {
            bool.should(query, new Query[0]);
        }
        return bool.build()._toQuery();
    }

    public static Query boolShould(Collection<Query> queries) {
        BoolQuery.Builder bool = QueryBuilders.bool();
        for (Query query : queries) {
            bool.should(query, new Query[0]);
        }
        return bool.build()._toQuery();
    }

    public static Query mustNot(Query query) {
        return QueryBuilders.bool(b -> b.mustNot(query, new Query[0]));
    }

    public static Query exists(String key) {
        return QueryBuilders.exists((T e) -> e.field(key));
    }

    public static Query regex(String key, String value) {
        return QueryBuilders.regexp(r -> r.field(key).value(value));
    }

    public static Query wildcard(String key, String val) {
        return QueryBuilders.wildcard(i -> i.field(key).wildcard(val));
    }

    public static Query simpleQueryString(String key, String value) {
        return QueryBuilders.simpleQueryString(i -> i.fields(key, new String[0]).query(value));
    }

    public static Query matchQuery(String key, String query) {
        return QueryBuilders.match(m -> m.field(key).query(query).operator(Operator.Or));
    }

    public static Query matchQuery(String key, String query, int maxExpansions) {
        return QueryBuilders.match(m -> m.field(key).query(query).maxExpansions(Integer.valueOf(maxExpansions)).operator(Operator.Or));
    }

    public static Query matchAllQuery(String key, String query) {
        return QueryBuilders.match(m -> m.field(key).query(query).operator(Operator.And));
    }

    public static Query matchAllQuery(String key, String query, int maxExpansions) {
        return QueryBuilders.match(m -> m.field(key).query(query).maxExpansions(Integer.valueOf(maxExpansions)).operator(Operator.And));
    }

    public static Query matchPhraseQuery(String key, String query) {
        return QueryBuilders.matchPhrase(m -> m.field(key).query(query));
    }

    public static Query matchPhrasePrefixQuery(String key, String query) {
        return QueryBuilders.matchPhrasePrefix(m -> m.field(key).query(query));
    }

    public static Query matchPhrasePrefixQuery(String key, String query, int maxExpansions) {
        return QueryBuilders.matchPhrasePrefix(m -> m.field(key).query(query).maxExpansions(Integer.valueOf(maxExpansions)));
    }

    public static Query nestedQuery(String path, Query command) {
        return QueryBuilders.nested().path(path).query(command).scoreMode(ChildScoreMode.Avg).build()._toQuery();
    }

    public static SortOptions getScoreSort(SortOrder order) {
        return SortOptions.of(so -> so.score(s -> s.order(order)));
    }

    public static SortOptions getFieldSorts(String key, SortOrder order) {
        return SortOptions.of(so -> so.field(f -> f.field(key).order(order)));
    }

    public static SortOptions getDocSorts(SortOrder order) {
        return SortOptions.of(so -> so.doc(d -> d.order(order)));
    }

    public static String transferJsonToMapping(InputStream is) throws IOException {
        String mapping;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is));){
            mapping = buffer.lines().collect(Collectors.joining("\n"));
        }
        return mapping;
    }

    public static Time timeOfMilliseconds(int duration) {
        return (Time)new Time.Builder().time(duration + "ms").build();
    }

    public static String buildFailureMessage(BulkResponse response) {
        StringBuilder sb = new StringBuilder();
        sb.append("Bulk execution failed: ");
        for (int i = 0; i < response.items().size(); ++i) {
            BulkResponseItem item = (BulkResponseItem)response.items().get(i);
            if (item.error() == null) continue;
            sb.append("\nat ").append(i).append("[").append(item.index()).append("] - ").append(item.operationType()).append(" - ").append(item.id()).append(" - ").append(item.error());
        }
        return sb.toString();
    }

    public static DatabaseException toDatabaseException(String msg, Exception e) {
        if (e instanceof ElasticsearchException) {
            return new DatabaseException(msg + " - " + String.valueOf(((ElasticsearchException)e).response()), (Throwable)e);
        }
        return new DatabaseException(msg, (Throwable)e);
    }

    public static DatabaseException toDatabaseException(Exception e) {
        if (e instanceof ElasticsearchException) {
            return new DatabaseException(e.getMessage() + " - " + String.valueOf(((ElasticsearchException)e).response()), (Throwable)e);
        }
        return new DatabaseException((Throwable)e);
    }
}

