/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import fr.gouv.vitam.common.model.FacetBucket;
import fr.gouv.vitam.common.model.FacetResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ElasticsearchFacetResultHelper {
    public static FacetResult transformFromEsAggregation(String name, Aggregate aggregation) {
        FacetResult facetResult = new FacetResult();
        facetResult.setName(name);
        Aggregate.Kind aggType = aggregation._kind();
        switch (aggType) {
            case DateRange: {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketDateRangeAggregation(aggregation));
                break;
            }
            case Sterms: {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketStringTermsAggregation(aggregation));
                break;
            }
            case Lterms: {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketLongTermsAggregation(aggregation));
                break;
            }
            case Filters: {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketFiltersAggregation(aggregation));
                break;
            }
            case Nested: {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketNestedAggregation(aggregation));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected aggregate type " + String.valueOf(aggType));
            }
        }
        return facetResult;
    }

    private static List<FacetBucket> extractBucketFiltersAggregation(Aggregate aggregation) {
        Map buckets = aggregation.filters().buckets().keyed();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach((key, bucket) -> facetBuckets.add(new FacetBucket(key, bucket.docCount())));
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketStringTermsAggregation(Aggregate aggregation) {
        List buckets = aggregation.sterms().buckets().array();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.key().stringValue(), bucket.docCount())));
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketLongTermsAggregation(Aggregate aggregation) {
        List buckets = aggregation.lterms().buckets().array();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> {
            String value = bucket.keyAsString() != null ? bucket.keyAsString() : Long.toString(bucket.key());
            facetBuckets.add(new FacetBucket(value, bucket.docCount()));
        });
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketNestedAggregation(Aggregate aggregation) {
        Map aggregations = aggregation.nested().aggregations();
        if (aggregations.isEmpty()) {
            return Collections.emptyList();
        }
        String key = (String)aggregations.keySet().iterator().next();
        return ElasticsearchFacetResultHelper.transformFromEsAggregation(key, (Aggregate)aggregations.get(key)).getBuckets();
    }

    private static List<FacetBucket> extractBucketDateRangeAggregation(Aggregate aggregation) {
        List buckets = aggregation.dateRange().buckets().array();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.key(), bucket.docCount())));
        return facetBuckets;
    }
}

