/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapterExternal;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.DeleteParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.InsertParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.RequestParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;

public class RequestParserHelperSingle {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RequestParserHelperSingle.class);

    private RequestParserHelperSingle() {
    }

    public static RequestParserSingle getParser(JsonNode jsonRequest) throws InvalidParseOperationException {
        return RequestParserHelperSingle.getParser(jsonRequest, new SingleVarNameAdapterExternal());
    }

    public static RequestParserSingle getParser(JsonNode jsonRequest, VarNameAdapter varNameAdapter) throws InvalidParseOperationException {
        if (jsonRequest.get(BuilderToken.GLOBAL.PROJECTION.exactToken()) != null) {
            LOGGER.debug("SELECT");
            SelectParserSingle selectParser = new SelectParserSingle(varNameAdapter);
            selectParser.parse(jsonRequest);
            return selectParser;
        }
        if (jsonRequest.get(BuilderToken.GLOBAL.DATA.exactToken()) != null) {
            LOGGER.debug("INSERT");
            InsertParserSingle insertParser = new InsertParserSingle(varNameAdapter);
            insertParser.parse(jsonRequest);
            return insertParser;
        }
        if (jsonRequest.get(BuilderToken.GLOBAL.ACTION.exactToken()) != null) {
            LOGGER.debug("UPDATE");
            UpdateParserSingle updateParser = new UpdateParserSingle(varNameAdapter);
            updateParser.parse(jsonRequest);
            return updateParser;
        }
        LOGGER.debug("DELETE");
        DeleteParserSingle deleteParser = new DeleteParserSingle(varNameAdapter);
        deleteParser.parse(jsonRequest);
        return deleteParser;
    }
}

