/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.facet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FacetHelper;
import fr.gouv.vitam.common.database.builder.facet.RangeFacetValue;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FacetParserHelper
extends FacetHelper {
    protected FacetParserHelper() {
    }

    public static final Facet terms(JsonNode facet, VarNameAdapter adapter) throws InvalidCreateOperationException, InvalidParseOperationException {
        String fieldName;
        String translatedFieldName;
        String nestedPath;
        String name = facet.get(BuilderToken.FACETARGS.NAME.exactToken()).asText();
        JsonNode terms = facet.get(BuilderToken.FACET.TERMS.exactToken());
        if (!terms.has(BuilderToken.FACETARGS.ORDER.exactToken())) {
            throw new InvalidCreateOperationException(String.format("facet must contain a %s parameter", BuilderToken.FACETARGS.ORDER.exactToken()));
        }
        if (!terms.has(BuilderToken.FACETARGS.SIZE.exactToken())) {
            throw new InvalidCreateOperationException(String.format("facet must contain a %s parameter", BuilderToken.FACETARGS.SIZE.exactToken()));
        }
        String translatedNestedPath = null;
        if (terms.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()) != null && (translatedNestedPath = adapter.getVariableName(nestedPath = terms.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()).asText())) == null) {
            translatedNestedPath = nestedPath;
        }
        if ((translatedFieldName = adapter.getVariableName(fieldName = terms.get(BuilderToken.FACETARGS.FIELD.exactToken()).asText())) == null) {
            translatedFieldName = fieldName;
        }
        Integer size = terms.get(BuilderToken.FACETARGS.SIZE.exactToken()).asInt();
        FacetOrder order = FacetOrder.valueOf((String)terms.get(BuilderToken.FACETARGS.ORDER.exactToken()).asText());
        return FacetHelper.terms((String)name, (String)translatedFieldName, (String)translatedNestedPath, (Integer)size, (FacetOrder)order);
    }

    public static final Facet dateRange(JsonNode facet, VarNameAdapter adapter) throws InvalidCreateOperationException, InvalidParseOperationException {
        String fieldName;
        String translatedFieldName;
        String nestedPath;
        String name = facet.get(BuilderToken.FACETARGS.NAME.exactToken()).asText();
        JsonNode dateRange = facet.get(BuilderToken.FACET.DATE_RANGE.exactToken());
        ArrayNode ranges = (ArrayNode)dateRange.get(BuilderToken.FACETARGS.RANGES.exactToken());
        String dateFormat = dateRange.get(BuilderToken.FACETARGS.FORMAT.exactToken()).asText();
        ArrayList rangesList = new ArrayList();
        ranges.forEach(item -> {
            JsonNode from = item.get(BuilderToken.FACETARGS.FROM.exactToken());
            JsonNode to = item.get(BuilderToken.FACETARGS.TO.exactToken());
            rangesList.add(new RangeFacetValue(from != null && !from.isNull() ? from.asText() : null, to != null && !to.isNull() ? to.asText() : null));
        });
        String translatedNestedPath = null;
        if (dateRange.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()) != null && (translatedNestedPath = adapter.getVariableName(nestedPath = dateRange.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()).asText())) == null) {
            translatedNestedPath = nestedPath;
        }
        if ((translatedFieldName = adapter.getVariableName(fieldName = dateRange.get(BuilderToken.FACETARGS.FIELD.exactToken()).asText())) == null) {
            translatedFieldName = fieldName;
        }
        return FacetHelper.dateRange((String)name, (String)translatedFieldName, (String)translatedNestedPath, (String)dateFormat, rangesList);
    }

    public static final Facet filters(JsonNode facet, VarNameAdapter adapter) throws InvalidCreateOperationException, InvalidParseOperationException {
        String name = facet.get(BuilderToken.FACETARGS.NAME.exactToken()).asText();
        JsonNode filtersFacetnode = facet.get(BuilderToken.FACET.FILTERS.exactToken());
        HashMap<String, Query> filters = new HashMap<String, Query>();
        ArrayNode filtersNode = (ArrayNode)filtersFacetnode.get(BuilderToken.FACETARGS.QUERY_FILTERS.exactToken());
        for (JsonNode node : filtersNode) {
            String key = node.get(BuilderToken.FACETARGS.NAME.exactToken()).asText();
            JsonNode queryNode = node.get(BuilderToken.FACETARGS.QUERY.exactToken());
            Map.Entry queryItem = JsonHandler.checkUnicity((String)"RootRequest", (JsonNode)queryNode);
            Query query = QueryParserHelper.query((String)queryItem.getKey(), (JsonNode)queryItem.getValue(), adapter);
            filters.put(key, query);
        }
        return FacetHelper.filters((String)name, filters);
    }
}

