/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.cas.container.builder;

import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.cas.container.swift.OpenstackSwift;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.common.storage.constants.StorageProvider;
import fr.gouv.vitam.common.storage.filesystem.FileSystem;
import fr.gouv.vitam.common.storage.filesystem.v2.HashFileSystem;
import fr.gouv.vitam.common.storage.s3.AmazonS3V1;
import fr.gouv.vitam.common.storage.swift.Swift;
import fr.gouv.vitam.common.storage.swift.SwiftKeystoneFactoryV2;
import fr.gouv.vitam.common.storage.swift.SwiftKeystoneFactoryV3;
import fr.gouv.vitam.storage.offers.tape.TapeLibraryFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.function.Supplier;

public class StoreContextBuilder {
    public static ContentAddressableStorage newStoreContext(StorageConfiguration configuration, MongoDatabase mongoDatabase) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, IllegalPathException {
        if (StorageProvider.SWIFT_AUTH_V1.getValue().equalsIgnoreCase(configuration.getProvider())) {
            return new OpenstackSwift(configuration);
        }
        if (StorageProvider.HASHFILESYSTEM.getValue().equalsIgnoreCase(configuration.getProvider())) {
            return new HashFileSystem(configuration);
        }
        if (StorageProvider.SWIFT_AUTH_V2.getValue().equalsIgnoreCase(configuration.getProvider())) {
            SwiftKeystoneFactoryV2 swiftKeystoneFactoryV2 = new SwiftKeystoneFactoryV2(configuration);
            return new Swift((Supplier)swiftKeystoneFactoryV2, configuration);
        }
        if (StorageProvider.SWIFT_AUTH_V3.getValue().equalsIgnoreCase(configuration.getProvider())) {
            SwiftKeystoneFactoryV3 swiftKeystoneFactoryV3 = new SwiftKeystoneFactoryV3(configuration);
            return new Swift((Supplier)swiftKeystoneFactoryV3, configuration);
        }
        if (StorageProvider.AMAZON_S3_V1.getValue().equalsIgnoreCase(configuration.getProvider())) {
            return new AmazonS3V1(configuration);
        }
        if (StorageProvider.TAPE_LIBRARY.getValue().equalsIgnoreCase(configuration.getProvider())) {
            TapeLibraryFactory tapeLibraryFactory = TapeLibraryFactory.getInstance();
            tapeLibraryFactory.initialize(configuration.getTapeLibraryConfiguration(), mongoDatabase);
            return tapeLibraryFactory.getTapeLibraryContentAddressableStorage();
        }
        return new FileSystem(configuration);
    }
}

