/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.helpers.SipHelper;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.manifest.ManifestBuilder;
import fr.gouv.vitam.common.manifest.naming.CollectFilenameResolver;
import fr.gouv.vitam.common.manifest.naming.FilenameResolver;
import fr.gouv.vitam.common.manifest.naming.FlatFolderResolver;
import fr.gouv.vitam.common.manifest.naming.FolderResolver;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.export.ExportRequestParameters;
import fr.gouv.vitam.common.model.export.ExportType;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.common.CompressInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.io.FileUtils;

public class SipService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SipService.class);
    private static final String SIP_EXTENSION = ".zip";
    private static final int DEFAULT_MAX_ELEMENT_IN_QUERY = 1000;
    private final int maxElementsInQuery;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final MetadataRepository metadataRepository;

    public SipService(WorkspaceClientFactory workspaceClientFactory, MetadataRepository metadataRepository) {
        this(workspaceClientFactory, metadataRepository, 1000);
    }

    @VisibleForTesting
    public SipService(WorkspaceClientFactory workspaceClientFactory, MetadataRepository metadataRepository, int maxElementsInQuery) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.metadataRepository = metadataRepository;
        this.maxElementsInQuery = maxElementsInQuery;
    }

    public String generateSip(TransactionModel transactionModel) throws CollectInternalException {
        File localDirectory = PropertiesUtils.fileFromTmpFolder((String)transactionModel.getId());
        File manifestFile = new File(localDirectory.getAbsolutePath().concat("/").concat("manifest.xml"));
        boolean isCreated = manifestFile.getParentFile().mkdir();
        if (!isCreated) {
            LOGGER.debug("An error occurs when trying to create manifest parent directory");
            throw new CollectInternalException("An error occurs when trying to create manifest parent directory");
        }
        try (FileOutputStream outputStream = new FileOutputStream(manifestFile);
             ManifestBuilder manifestBuilder = new ManifestBuilder((OutputStream)outputStream, null);){
            ExportRequestParameters exportRequestParameters = SipHelper.buildExportRequestParameters(transactionModel);
            ExportRequest exportRequest = SipHelper.buildExportRequest(transactionModel, exportRequestParameters);
            manifestBuilder.startDocument(transactionModel.getManifestContext().getMessageIdentifier(), ExportType.ArchiveTransfer, exportRequestParameters);
            ArrayListMultimap multimap = ArrayListMultimap.create();
            HashSet originatingAgencies = new HashSet();
            HashMap ogs = new HashMap();
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(exportRequest.getDslRequest());
            SelectMultiQuery request = parser.getRequest();
            ScrollSpliterator<JsonNode> scrollRequest = this.metadataRepository.selectUnits(request, transactionModel.getId());
            StreamSupport.stream(scrollRequest, false).forEach(arg_0 -> SipService.lambda$generateSip$0((ListMultimap)multimap, originatingAgencies, ogs, arg_0));
            manifestBuilder.startDataObjectPackage();
            Select select = new Select();
            Iterable partitions = Iterables.partition(ogs.entrySet(), (int)this.maxElementsInQuery);
            HashSet<String> exportedObjectGroupIds = new HashSet<String>();
            for (List partition : partitions) {
                ListMultimap unitsForObjectGroupId = (ListMultimap)partition.stream().collect(ArrayListMultimap::create, (map, entry) -> map.put((Object)((String)entry.getValue()), (Object)((String)entry.getKey())), (list1, list2) -> list1.putAll((Multimap)list2));
                InQuery in = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])((String[])partition.stream().map(Map.Entry::getValue).toArray(String[]::new)));
                select.setQuery((Query)in);
                JsonNode response = this.metadataRepository.selectObjectGroups((JsonNode)select.getFinalSelect(), transactionModel.getId());
                ArrayNode objectGroups = (ArrayNode)response.get("$results");
                for (JsonNode object : objectGroups) {
                    String objectGroupId = object.get(VitamFieldsHelper.id()).textValue();
                    if (exportedObjectGroupIds.contains(objectGroupId)) continue;
                    List linkedUnits = unitsForObjectGroupId.get((Object)objectGroupId);
                    manifestBuilder.writeGOT(object, (String)linkedUnits.get(linkedUnits.size() - 1), Stream.empty(), (FolderResolver)FlatFolderResolver.INSTANCE, (FilenameResolver)CollectFilenameResolver.INSTANCE);
                    exportedObjectGroupIds.add(objectGroupId);
                }
            }
            manifestBuilder.startDescriptiveMetadata();
            SelectParserMultiple initialQueryParser = new SelectParserMultiple();
            initialQueryParser.parse(exportRequest.getDslRequest());
            scrollRequest = this.metadataRepository.selectUnits(initialQueryParser.getRequest(), transactionModel.getId());
            StreamSupport.stream(scrollRequest, false).forEach(arg_0 -> SipService.lambda$generateSip$4(manifestBuilder, (ListMultimap)multimap, ogs, arg_0));
            manifestBuilder.endDescriptiveMetadata();
            String archivalProfile = transactionModel.getManifestContext().getArchivalProfile();
            String submissionAgencyIdentifier = transactionModel.getManifestContext().getSubmissionAgencyIdentifier();
            String legalStatus = transactionModel.getManifestContext().getLegalStatus();
            String acquisitionInformation = transactionModel.getManifestContext().getAcquisitionInformation();
            if (submissionAgencyIdentifier == null) {
                submissionAgencyIdentifier = transactionModel.getManifestContext().getOriginatingAgencyIdentifier();
            }
            manifestBuilder.writeManagementMetadata(acquisitionInformation, legalStatus, transactionModel.getManifestContext().getOriginatingAgencyIdentifier(), submissionAgencyIdentifier, archivalProfile);
            manifestBuilder.endDataObjectPackage();
            manifestBuilder.writeFooter(ExportType.ArchiveTransfer, exportRequest.getExportRequestParameters());
            manifestBuilder.closeManifest();
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage());
            throw new CollectInternalException((Throwable)e);
        }
        try {
            String string;
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                string = this.saveManifestInWorkspace(transactionModel, inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error(e.getLocalizedMessage());
                    throw new CollectInternalException((Throwable)e);
                }
            }
            ((InputStream)inputStream).close();
            return string;
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)manifestFile.getParentFile());
            }
            catch (IOException exception) {
                throw new CollectInternalException((Throwable)exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String saveManifestInWorkspace(TransactionModel transactionModel, InputStream inputStream) throws CollectInternalException {
        LOGGER.debug("Try to push manifest to workspace...");
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (!workspaceClient.isExistingContainer(transactionModel.getId())) throw new CollectInternalException("Cannot find related Container to transaction");
            Digest digest = new Digest(VitamConfiguration.getDefaultDigestType());
            InputStream digestInputStream = digest.getDigestInputStream(inputStream);
            workspaceClient.putObject(transactionModel.getId(), "manifest.xml", digestInputStream);
            LOGGER.debug(" -> push manifest to workspace finished");
            CompressInformation compressInformation = new CompressInformation();
            compressInformation.getFiles().add("manifest.xml");
            compressInformation.getFiles().add("Content");
            compressInformation.setOutputFile(transactionModel.getId() + SIP_EXTENSION);
            compressInformation.setOutputContainer(transactionModel.getId());
            workspaceClient.compress(transactionModel.getId(), compressInformation);
            String string = digest.digestHex();
            return string;
        }
        catch (ContentAddressableStorageServerException e) {
            LOGGER.error(e.getLocalizedMessage());
            throw new CollectInternalException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getIngestedFileFromWorkspace(TransactionModel transactionModel) throws CollectInternalException {
        LOGGER.debug("Try to get Zip from workspace...");
        InputStream sipInputStream = null;
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (!workspaceClient.isExistingContainer(transactionModel.getId())) {
                InputStream inputStream = null;
                return inputStream;
            }
            Response response = workspaceClient.getObject(transactionModel.getId(), transactionModel.getId() + SIP_EXTENSION);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                sipInputStream = (InputStream)response.getEntity();
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.error("Error when processing ingest:", e);
            throw new CollectInternalException(e);
        }
        LOGGER.debug(" zip from workspace finished");
        return sipInputStream;
    }

    private static /* synthetic */ void lambda$generateSip$4(ManifestBuilder manifestBuilder, ListMultimap multimap, Map ogs, JsonNode result) {
        try {
            ArchiveUnitModel archiveUnitModel = (ArchiveUnitModel)VitamObjectMapper.getDeserializationObjectMapper().treeToValue((TreeNode)result, ArchiveUnitModel.class);
            manifestBuilder.writeArchiveUnit(archiveUnitModel, multimap, ogs);
        }
        catch (JsonProcessingException | ExportException | JAXBException | DatatypeConfigurationException e) {
            throw new VitamRuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$generateSip$0(ListMultimap multimap, Set originatingAgencies, Map ogs, JsonNode item) {
        CollectHelper.createGraph((ListMultimap<String, String>)multimap, originatingAgencies, ogs, item);
    }
}

