/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.collect.common.dto.BulkAtomicUpdateResult;
import fr.gouv.vitam.collect.common.dto.BulkAtomicUpdateStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.core.helpers.MetadataHelper;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.service.BulkAtomicUpdateReportAppender;
import fr.gouv.vitam.common.InternalActionKeysRetriever;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.model.UpdateUnit;
import fr.gouv.vitam.metadata.api.utils.BulkAtomicUpdateModelUtils;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryParallelProcessor;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryResultFailure;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryResultOK;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.QueryRestrictionConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.ListUtils;

@ThreadSafe
public class BulkAtomicUpdateMetadataService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BulkAtomicUpdateMetadataService.class);
    private final MetadataRepository metadataRepository;
    private final MetaDataClientFactory metadataClientFactory;
    private final int threadPoolSize;
    private final int threadPoolQueueSize;
    private final int batchSize;

    public BulkAtomicUpdateMetadataService(MetadataRepository metadataRepository, MetaDataClientFactory metadataClientFactory, CollectInternalConfiguration configuration) {
        this.metadataRepository = metadataRepository;
        this.metadataClientFactory = metadataClientFactory;
        this.threadPoolSize = configuration.getBulkAtomicUpdateThreadPoolSize();
        this.threadPoolQueueSize = configuration.getBulkAtomicUpdateThreadPoolQueueSize();
        this.batchSize = configuration.getBulkAtomicUpdateBatchSize();
    }

    public List<BulkAtomicUpdateResult> bulkAtomicUpdateUnits(String transactionId, ArrayNode queries, boolean allowInternalFieldsUpdate) throws CollectInternalException {
        try {
            BulkAtomicUpdateReportAppender reportAppender = new BulkAtomicUpdateReportAppender();
            List<BulkSelectQueryResultOK> selectQueryResults = this.selectUnitIdsPerUpdateQueries(transactionId, reportAppender, queries, allowInternalFieldsUpdate);
            this.processUpdate(selectQueryResults, reportAppender);
            return reportAppender.exportResults();
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalInvalidRequestException((Throwable)e);
        }
    }

    public void checkThreshold(JsonNode updateQueriesJson) throws CollectInternalInvalidRequestException {
        long threshold;
        Long queryThreshold = BulkAtomicUpdateModelUtils.getQueryThreshold((JsonNode)updateQueriesJson);
        long total = BulkAtomicUpdateModelUtils.queryCount((JsonNode)updateQueriesJson);
        long l = threshold = queryThreshold != null ? queryThreshold : VitamConfiguration.getQueriesThreshold();
        if (total > threshold) {
            LOGGER.error("Too many update queries. Platform threshold={}, queryThreshold={}, actual={}", new Object[]{VitamConfiguration.getQueriesThreshold(), queryThreshold, total});
            throw new CollectInternalInvalidRequestException("Too many update queries. Threshold exceeded.");
        }
    }

    private List<BulkSelectQueryResultOK> selectUnitIdsPerUpdateQueries(String transactionId, BulkAtomicUpdateReportAppender reportAppender, ArrayNode queries, boolean allowInternalFieldsUpdate) throws CollectInternalInvalidRequestException {
        ArrayList<BulkSelectQueryResultOK> arrayList;
        block8: {
            ArrayList<BulkSelectQueryResultOK> selectUnitIdsResults = new ArrayList<BulkSelectQueryResultOK>();
            MetaDataClient metadataClient = this.metadataClientFactory.getClient();
            try {
                BulkSelectQueryParallelProcessor bulkSelectQueryParallelProcessor = new BulkSelectQueryParallelProcessor(metadataClient, new InternalActionKeysRetriever(), this.threadPoolSize, this.threadPoolQueueSize, this.batchSize, selectUnitIdsResults::add, BulkAtomicUpdateMetadataService.createFailureResultReportAppender(reportAppender), BulkAtomicUpdateMetadataService.createTransactionIdRestrictionConverter(transactionId), allowInternalFieldsUpdate);
                bulkSelectQueryParallelProcessor.processQueries(queries.iterator());
                arrayList = selectUnitIdsResults;
                if (metadataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    throw new CollectInternalInvalidRequestException("Cannot process bulk atomic update. Invalid request", (Throwable)e);
                }
            }
            metadataClient.close();
        }
        return arrayList;
    }

    private static Consumer<BulkSelectQueryResultFailure> createFailureResultReportAppender(BulkAtomicUpdateReportAppender reportAppender) {
        return result -> reportAppender.append(result.getQueryIndex(), new BulkAtomicUpdateResult(BulkAtomicUpdateStatus.KO, null, result.getMessage()));
    }

    private static QueryRestrictionConverter createTransactionIdRestrictionConverter(String transactionId) {
        return userQuery -> {
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(userQuery);
            MetadataHelper.applyTransactionToQuery(transactionId, (RequestMultiple)parser.getRequest());
            return parser.getRequest().getFinalSelect();
        };
    }

    private void processUpdate(List<BulkSelectQueryResultOK> selectQueryResults, BulkAtomicUpdateReportAppender reportAppender) throws CollectInternalException, InvalidParseOperationException {
        List selectQueryResultBulks = ListUtils.partition(selectQueryResults, (int)this.batchSize);
        for (List selectQueryResultBulk : selectQueryResultBulks) {
            this.processUpdateBatch(selectQueryResultBulk, reportAppender);
        }
    }

    private void processUpdateBatch(List<BulkSelectQueryResultOK> selectQueryResults, BulkAtomicUpdateReportAppender reportAppender) throws InvalidParseOperationException, CollectInternalException {
        ArrayList<JsonNode> updateQueries = new ArrayList<JsonNode>();
        for (BulkSelectQueryResultOK selectQueryResult : selectQueryResults) {
            UpdateParserMultiple updateParserMultiple = new UpdateParserMultiple();
            updateParserMultiple.parse(selectQueryResult.getQuery());
            updateParserMultiple.getRequest().resetRoots();
            updateParserMultiple.getRequest().resetQueries();
            updateParserMultiple.getRequest().addRoots(new String[]{selectQueryResult.getUnitId()});
            ObjectNode updateQuery = updateParserMultiple.getRequest().getFinalUpdate();
            updateQueries.add((JsonNode)updateQuery);
        }
        RequestResponseOK atomicBulkResults = (RequestResponseOK)this.metadataRepository.atomicBulkUpdate(updateQueries);
        if (atomicBulkResults.getResults().size() != updateQueries.size()) {
            LOGGER.error("Invalid response size for " + JsonHandler.unprettyPrint(updateQueries) + ", got : " + JsonHandler.unprettyPrint((Object)atomicBulkResults));
            throw new IllegalStateException("Expected " + updateQueries.size() + " update results, got " + atomicBulkResults.getResults().size());
        }
        List results = atomicBulkResults.getResults();
        for (int i = 0; i < results.size(); ++i) {
            JsonNode result = (JsonNode)results.get(i);
            BulkSelectQueryResultOK queryToProcess = selectQueryResults.get(i);
            RequestResponseOK responseOK = RequestResponseOK.getFromJsonNode((JsonNode)result, UpdateUnit.class);
            UpdateUnit unitUpdateStatus = (UpdateUnit)responseOK.getResults().get(0);
            if (unitUpdateStatus == null) {
                throw new IllegalStateException("Missing unit update status");
            }
            StatusCode status = unitUpdateStatus.getStatus();
            if (StatusCode.OK == status) {
                LOGGER.debug("Unit " + unitUpdateStatus.getUnitId() + " updated successfully !\n" + unitUpdateStatus.getDiff());
                reportAppender.append(queryToProcess.getQueryIndex(), new BulkAtomicUpdateResult(BulkAtomicUpdateStatus.OK, unitUpdateStatus.getUnitId(), null));
                continue;
            }
            LOGGER.debug("Unit " + unitUpdateStatus.getUnitId() + " update failed with message: " + String.valueOf(unitUpdateStatus.getKey()) + " - " + unitUpdateStatus.getMessage());
            reportAppender.append(queryToProcess.getQueryIndex(), new BulkAtomicUpdateResult(BulkAtomicUpdateStatus.KO, unitUpdateStatus.getUnitId(), unitUpdateStatus.getMessage()));
        }
    }
}

