/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.configuration;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import java.util.Map;

public class CollectInternalConfiguration
extends DbConfigurationImpl {
    private String workspaceUrl;
    private int statusTransactionThreadFrequency = 5;
    private Integer transactionStatusThreadPoolSize = 3;
    private Map<Integer, Integer> purgeTransactionDelayInMinutes;
    private int purgeTransactionThreadPoolSize = 3;
    private int purgeTransactionThreadFrequency = 60;
    private final int bulkAtomicUpdateThreadPoolSize = 8;
    private final int bulkAtomicUpdateThreadPoolQueueSize = 16;
    private final int bulkAtomicUpdateBatchSize = 100;

    public String getWorkspaceUrl() {
        return this.workspaceUrl;
    }

    public Map<Integer, Integer> getPurgeTransactionDelayInMinutes() {
        return this.purgeTransactionDelayInMinutes;
    }

    public void setPurgeTransactionDelayInMinutes(Map<Integer, Integer> purgeTransactionDelayInMinutes) {
        this.purgeTransactionDelayInMinutes = purgeTransactionDelayInMinutes;
    }

    public int getPurgeTransactionThreadPoolSize() {
        return this.purgeTransactionThreadPoolSize;
    }

    public void setPurgeTransactionThreadPoolSize(int purgeTransactionThreadPoolSize) {
        this.purgeTransactionThreadPoolSize = purgeTransactionThreadPoolSize;
    }

    public int getPurgeTransactionThreadFrequency() {
        return this.purgeTransactionThreadFrequency;
    }

    public void setPurgeTransactionThreadFrequency(int purgeTransactionThreadFrequency) {
        this.purgeTransactionThreadFrequency = purgeTransactionThreadFrequency;
    }

    public CollectInternalConfiguration setWorkspaceUrl(String workspaceUrl) {
        ParametersChecker.checkParameter((String)"workspaceUrl is a mandatory parameter", (String[])new String[]{workspaceUrl});
        this.workspaceUrl = workspaceUrl;
        return this;
    }

    public Integer getTransactionStatusThreadPoolSize() {
        return this.transactionStatusThreadPoolSize;
    }

    public void setTransactionStatusThreadPoolSize(Integer transactionStatusThreadPoolSize) {
        this.transactionStatusThreadPoolSize = transactionStatusThreadPoolSize;
    }

    public int getStatusTransactionThreadFrequency() {
        return this.statusTransactionThreadFrequency;
    }

    public void setStatusTransactionThreadFrequency(int statusTransactionThreadFrequency) {
        this.statusTransactionThreadFrequency = statusTransactionThreadFrequency;
    }

    public int getBulkAtomicUpdateThreadPoolSize() {
        return 8;
    }

    public int getBulkAtomicUpdateThreadPoolQueueSize() {
        return 16;
    }

    public int getBulkAtomicUpdateBatchSize() {
        return 100;
    }
}

