/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.schema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaOrigin;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.schema.Schema;
import fr.gouv.vitam.functional.administration.core.format.model.FunctionalOperationModel;
import fr.gouv.vitam.functional.administration.core.schema.SchemaImportReport;
import fr.gouv.vitam.functional.administration.core.schema.SchemaValidationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SchemaCommonService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchemaValidationService.class);
    public static final String SCHEMA_COLLECTION = "Schema";
    private static final String SCHEMA_REPORT = "SCHEMA_REPORT";

    public static JsonNode buildDslQueryForExtractingSchema(Set<Integer> tenantIds, List<String> schemaPaths) throws InvalidCreateOperationException {
        if (CollectionUtils.isEmpty(tenantIds)) {
            LOGGER.error(" the tenant list should not be empty");
            throw new IllegalArgumentException("the tenant list should not be empty");
        }
        Select select = new Select();
        BooleanQuery andQuery = QueryHelper.and();
        andQuery.add(new Query[]{QueryHelper.eq((String)"Origin", (String)"EXTERNAL")});
        andQuery.add(new Query[]{QueryHelper.eq((String)"Collection", (String)"Unit")});
        andQuery.add(new Query[]{QueryHelper.in((String)VitamFieldsHelper.tenant(), (long[])tenantIds.stream().mapToLong(Integer::longValue).toArray())});
        if (!CollectionUtils.isEmpty(schemaPaths)) {
            andQuery.add(new Query[]{QueryHelper.in((String)"Path", (String[])((String[])schemaPaths.toArray(String[]::new)))});
        }
        select.setQuery((Query)andQuery);
        return select.getFinalSelect();
    }

    public static String extractLeafFromPath(String schemaPath) {
        String leafElt = schemaPath != null && schemaPath.contains(".") ? StringUtils.substringAfterLast((String)schemaPath, (String)".") : schemaPath;
        return leafElt;
    }

    public static List<Schema> mapSchemaFromInputParameters(List<SchemaInputModel> externalSchemaInputList, Map<String, OntologyModel> ontologyEltsMapByIdentifier) {
        ArrayList<Schema> schemaModelElementsBuilt = new ArrayList<Schema>();
        for (SchemaInputModel schemaEltInputElt : externalSchemaInputList) {
            Schema schemaDb = new Schema();
            schemaDb.setOrigin(SchemaOrigin.EXTERNAL.name());
            schemaDb.setCollection(MetadataType.UNIT.getName());
            schemaDb.setCardinality(schemaEltInputElt.getCardinality().name());
            schemaDb.setPath(schemaEltInputElt.getPath());
            String shortName = schemaEltInputElt.getShortName();
            if (StringUtils.isBlank((String)shortName)) {
                String leaf = SchemaCommonService.extractLeafFromPath(schemaEltInputElt.getPath());
                shortName = ontologyEltsMapByIdentifier.get(leaf) != null ? ontologyEltsMapByIdentifier.get(leaf).getShortName() : leaf;
            }
            schemaDb.setShortName(shortName);
            schemaDb.setDescription(schemaEltInputElt.getDescription());
            schemaDb.setCreationdate(LocalDateUtil.nowFormatted());
            schemaDb.setLastupdate(LocalDateUtil.nowFormatted());
            boolean isLeaf = !Boolean.TRUE.equals(schemaEltInputElt.isObject());
            schemaDb.setIsObject(!isLeaf);
            schemaModelElementsBuilt.add(schemaDb);
        }
        return schemaModelElementsBuilt;
    }

    public static VitamError getVitamError(String vitamCode, String error, StatusCode statusCode) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)SCHEMA_COLLECTION, (StatusCode)statusCode);
    }

    public static SchemaImportReport fillSchemaImportReportOK(SchemaImportReport schemaImportReport, List<Schema> schemaList, GUID eip) {
        if (schemaImportReport == null) {
            schemaImportReport = SchemaCommonService.initSchemaImportReport(eip);
        }
        schemaImportReport.setStatusCode(StatusCode.OK);
        if (!CollectionUtils.isEmpty(schemaList)) {
            schemaImportReport.setCreatedSchemaPaths(schemaList.stream().map(schema -> schema.getPath()).collect(Collectors.toSet()));
        }
        return schemaImportReport;
    }

    public static SchemaImportReport fillSchemaImportReportError(SchemaImportReport schemaImportReport, Set<String> errorPathList, StatusCode status, GUID eip) {
        if (schemaImportReport == null) {
            schemaImportReport = SchemaCommonService.initSchemaImportReport(eip);
        }
        schemaImportReport.setStatusCode(status);
        if (!CollectionUtils.isEmpty(errorPathList)) {
            schemaImportReport.setErrorSchemaPaths(errorPathList);
        }
        return schemaImportReport;
    }

    public static SchemaImportReport initSchemaImportReport(GUID eip) {
        SchemaImportReport schemaImportReport = new SchemaImportReport();
        FunctionalOperationModel operation = new FunctionalOperationModel();
        operation.setEvType(SCHEMA_REPORT);
        operation.setEvDateTime(LocalDateUtil.nowFormatted());
        operation.setEvId(eip.toString());
        return schemaImportReport;
    }

    public static JsonNode buildOntologyQueryDslByIdentifiers(Set<String> ontologyIdentifiers) throws InvalidCreateOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.in((String)"Identifier", (String[])((String[])ontologyIdentifiers.toArray(String[]::new))));
        return select.getFinalSelect();
    }
}

