/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.rules;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UnsetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamErrorMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.CollectionBackupModel;
import fr.gouv.vitam.functional.administration.common.ErrorReport;
import fr.gouv.vitam.functional.administration.common.FileRules;
import fr.gouv.vitam.functional.administration.common.FileRulesCSV;
import fr.gouv.vitam.functional.administration.common.FileRulesErrorCode;
import fr.gouv.vitam.functional.administration.common.ReferentialFile;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesCsvException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesDeleteException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesDurationException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesIllegalDurationModeUpdateException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesReadException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialImportInProgressException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.backup.RestoreBackupService;
import fr.gouv.vitam.functional.administration.core.reconstruction.RestoreBackupServiceImpl;
import fr.gouv.vitam.functional.administration.core.rules.FileRulesManagementReport;
import fr.gouv.vitam.functional.administration.core.rules.LogbookRuleImportManager;
import fr.gouv.vitam.functional.administration.core.rules.RuleImportDiff;
import fr.gouv.vitam.functional.administration.core.rules.RuleImportResultSet;
import fr.gouv.vitam.functional.administration.core.rules.VitamRuleService;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextException;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextModel;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextMonitor;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;

public class RulesManagerFileImpl
implements ReferentialFile<FileRules> {
    private static final String RULES_FILE_STREAM_IS_A_MANDATORY_PARAMETER = "rulesFileStream is a mandatory parameter";
    private static final String RULES_PROCESS_IMPORT_ALREADY_EXIST = "There is already on file rules import in progress";
    private static final String DELETE_RULES_LINKED_TO_UNIT = "Error During Delete RuleFiles because this rule is linked to unit.";
    private static final String INVALID_CSV_FILE = "Invalid CSV File";
    private static final String RULE_DURATION_EXCEED = "Rule Duration Exceed";
    private static final String CSV = ".csv";
    private static final String UPDATE_DATE = "UpdateDate";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RulesManagerFileImpl.class);
    private static final int MAX_DURATION = Integer.MAX_VALUE;
    private static final AlertService alertService = new AlertServiceImpl();
    private static final String STP_IMPORT_RULES_BACKUP = "STP_IMPORT_RULES_BACKUP";
    private static final String STP_IMPORT_RULES_BACKUP_CSV = "STP_IMPORT_RULES_BACKUP_CSV";
    private static final String STP_IMPORT_RULES = "STP_IMPORT_RULES";
    private static final String CHECK_RULES_INVALID_CSV = "INVALID_CSV";
    private static final String STP_IMPORT_RULES_ENCODING_NOT_UTF_EIGHT = "INVALID_CSV_ENCODING_NOT_UTF_EIGHT";
    private static final String MAX_DURATION_EXCEEDS = "MAX_DURATION_EXCEEDS";
    private static final String CHECK_RULES_IMPORT_IN_PROCESS = "IMPORT_IN_PROCESS";
    private static final String RULES_REPORT = "RULES_REPORT";
    private static final int YEAR_LIMIT = 999;
    private static final int MONTH_LIMIT = 11988;
    private static final int DAY_LIMIT = 359640;
    private final MongoDbAccessAdminImpl mongoAccess;
    private final VitamCounterService vitamCounterService;
    private final MetaDataClientFactory metaDataClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final FunctionalBackupService backupService;
    private final VitamRuleService vitamRuleService;
    private final LogbookRuleImportManager logbookRuleImportManager;
    private final int ruleAuditThreadPoolSize;
    private final RestoreBackupService restoreBackupService;

    public RulesManagerFileImpl(MongoDbAccessAdminImpl dbConfiguration, VitamCounterService vitamCounterService, VitamRuleService vitamRuleService, int ruleAuditThreadPoolSize) {
        this.backupService = new FunctionalBackupService(vitamCounterService);
        this.mongoAccess = dbConfiguration;
        this.vitamCounterService = vitamCounterService;
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
        this.vitamRuleService = vitamRuleService;
        this.logbookRuleImportManager = new LogbookRuleImportManager(LogbookOperationsClientFactory.getInstance());
        this.ruleAuditThreadPoolSize = ruleAuditThreadPoolSize;
        this.restoreBackupService = new RestoreBackupServiceImpl();
    }

    @VisibleForTesting
    RulesManagerFileImpl(MongoDbAccessAdminImpl dbConfiguration, VitamCounterService vitamCounterService, FunctionalBackupService backupService, LogbookOperationsClientFactory logbookOperationsClientFactory, MetaDataClientFactory metaDataClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, WorkspaceClientFactory workspaceClientFactory, VitamRuleService vitamRuleService, int ruleAuditThreadPoolSize, RestoreBackupService restoreBackupService) {
        this.mongoAccess = dbConfiguration;
        this.vitamCounterService = vitamCounterService;
        this.metaDataClientFactory = metaDataClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.backupService = backupService;
        this.vitamRuleService = vitamRuleService;
        this.logbookRuleImportManager = new LogbookRuleImportManager(logbookOperationsClientFactory);
        this.ruleAuditThreadPoolSize = ruleAuditThreadPoolSize;
        this.restoreBackupService = restoreBackupService;
    }

    private static FileRulesModel convertFileRulesToFilesRulesModel(FileRules fileRule) {
        return new FileRulesModel(fileRule.getRuleid(), fileRule.getRuletype(), fileRule.getRulevalue(), fileRule.getRuledescription(), fileRule.getRuleduration(), fileRule.getRulemeasurement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(InputStream rulesFileStream, String filename) throws IOException, InvalidParseOperationException, ReferentialException, StorageException, InvalidGuidOperationException, LogbookClientException, IllegalPathException {
        ParametersChecker.checkParameter((String)RULES_FILE_STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{rulesFileStream});
        GUID eip = GUIDReader.getGUID((String)VitamThreadUtils.getVitamSession().getRequestId());
        this.logbookRuleImportManager.initStpImportRulesLogbookOperation(eip);
        this.checkConcurrentImportOperation(filename, eip);
        File file = FileUtil.convertInputStreamToFile((InputStream)rulesFileStream, (String)GUIDFactory.newGUID().getId(), (String)CSV);
        try {
            Map<String, FileRulesModel> rulesFromFile = this.processRuleParsing(file, filename, eip);
            RuleImportResultSet ruleImportResultSet = this.processRuleValidation(eip, rulesFromFile, filename);
            this.processCommitToDb(filename, ruleImportResultSet, eip, file);
        }
        finally {
            Files.delete(file.toPath());
        }
    }

    public Map<String, FileRulesModel> processRuleParsing(File file, String filename, GUID eip) throws FileRulesReadException, StorageException, InvalidParseOperationException, IOException, LogbookClientException {
        Map<String, FileRulesModel> rulesFromFile;
        try {
            rulesFromFile = this.getRulesFromCSV(new FileInputStream(file));
        }
        catch (FileRulesCsvException e) {
            this.logbookRuleImportManager.updateCheckFileRulesLogbookOperationWhenCheckBeforeImportIsKo(CHECK_RULES_INVALID_CSV, eip);
            this.generateReport(StatusCode.KO, e.getErrorsMap(), eip, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw e;
        }
        catch (FileRulesDurationException e) {
            alertService.createAlert(RULE_DURATION_EXCEED);
            this.logbookRuleImportManager.updateCheckFileRulesLogbookOperationWhenCheckBeforeImportIsKo(MAX_DURATION_EXCEEDS, eip);
            this.generateReport(StatusCode.KO, e.getErrorsMap(), eip, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw e;
        }
        catch (IOException e) {
            this.handleIOException(filename, eip, e);
            throw e;
        }
        return rulesFromFile;
    }

    private RuleImportResultSet processRuleValidation(GUID eip, Map<String, FileRulesModel> rulesFromFile, String filename) throws ReferentialException, InvalidParseOperationException, LogbookClientException {
        try {
            return this.checkFile(rulesFromFile);
        }
        catch (FileRulesDeleteException e) {
            this.generateReportWhenFileRulesDeletedExceptionAppend(eip, e.getUsedDeletedRules(), filename);
            throw e;
        }
        catch (FileRulesIllegalDurationModeUpdateException e) {
            this.generateReportWhenFileRulesIllegalDurationModeUpdateException(eip, e.getUsedRulesWithDurationModeUpdate(), filename);
            throw e;
        }
    }

    private void checkConcurrentImportOperation(String filename, GUID eip) throws FileRulesException, InvalidParseOperationException, ReferentialImportInProgressException, LogbookClientException {
        if (this.logbookRuleImportManager.isImportOperationInProgress()) {
            this.logbookRuleImportManager.updateCheckFileRulesLogbookOperationWhenCheckBeforeImportIsKo(CHECK_RULES_IMPORT_IN_PROCESS, eip);
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw new ReferentialImportInProgressException(RULES_PROCESS_IMPORT_ALREADY_EXIST);
        }
    }

    private void handleIOException(String filename, GUID eip, IOException e) throws StorageException, InvalidParseOperationException, LogbookClientException {
        this.logbookRuleImportManager.updateCheckFileRulesLogbookOperationWhenCheckBeforeImportIsKo(STP_IMPORT_RULES_ENCODING_NOT_UTF_EIGHT, eip);
        this.generateReport(StatusCode.KO, Collections.emptyMap(), eip, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, "Error Encoding File : " + filename + " : " + e.getMessage());
    }

    private void processCommitToDb(String filename, RuleImportResultSet ruleImportResultSet, GUID eip, File file) throws IOException, ReferentialException, InvalidParseOperationException, LogbookClientException {
        FileInputStream fileInputStream = null;
        try {
            StatusCode statusCode = ruleImportResultSet.getUsedUpdateRulesForUpdateUnit().isEmpty() ? StatusCode.OK : StatusCode.WARNING;
            this.generateReport(statusCode, Collections.emptyMap(), eip, Collections.emptyList(), Collections.emptyList(), ruleImportResultSet.getUsedRulesToUpdate(), ruleImportResultSet.getUnusedRulesToDelete(), ruleImportResultSet.getRulesToUpdate(), ruleImportResultSet.getRulesToInsert());
            this.logbookRuleImportManager.updateCheckFileRulesLogbookOperation(statusCode, ruleImportResultSet.getUsedRulesToUpdate().stream().map(FileRulesModel::getRuleId).collect(Collectors.toSet()), ruleImportResultSet.getUnusedRulesToDelete().stream().map(FileRulesModel::getRuleId).collect(Collectors.toSet()), Collections.emptySet(), Collections.emptySet(), eip);
            this.commitRules(ruleImportResultSet.getRulesToUpdate(), ruleImportResultSet.getUnusedRulesToDelete(), ruleImportResultSet.getRulesToInsert(), eip);
            fileInputStream = new FileInputStream(file);
            this.backupService.saveFile(fileInputStream, eip, STP_IMPORT_RULES_BACKUP_CSV, DataCategory.RULES, eip.getId() + CSV);
            this.backupService.saveCollectionAndSequence(eip, STP_IMPORT_RULES_BACKUP, FunctionalAdminCollections.RULES, eip.getId());
            if (!ruleImportResultSet.getUsedUpdateRulesForUpdateUnit().isEmpty()) {
                this.launchWorkflow(ruleImportResultSet.getUsedUpdateRulesForUpdateUnit());
            }
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, statusCode, filename);
        }
        catch (VitamException e) {
            try {
                this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
                throw new FileRulesException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileInputStream);
    }

    private void generateReportWhenFileRulesDeletedExceptionAppend(GUID eip, List<FileRulesModel> usedDeletedRulesForReport, String filename) throws ReferentialException, InvalidParseOperationException, LogbookClientException {
        try {
            this.generateReport(StatusCode.KO, Collections.emptyMap(), eip, usedDeletedRulesForReport, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            this.logbookRuleImportManager.updateCheckFileRulesLogbookOperation(StatusCode.KO, Collections.emptySet(), Collections.emptySet(), usedDeletedRulesForReport.stream().map(FileRulesModel::getRuleId).collect(Collectors.toSet()), Collections.emptySet(), eip);
            LOGGER.error(DELETE_RULES_LINKED_TO_UNIT);
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw new FileRulesException(DELETE_RULES_LINKED_TO_UNIT);
        }
        catch (StorageException e) {
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw new FileRulesException((Throwable)e);
        }
    }

    private void generateReportWhenFileRulesIllegalDurationModeUpdateException(GUID eip, List<FileRulesModel> usedRulesWithDurationModeUpdate, String filename) throws ReferentialException, InvalidParseOperationException, LogbookClientException {
        try {
            this.generateReport(StatusCode.KO, Collections.emptyMap(), eip, Collections.emptyList(), usedRulesWithDurationModeUpdate, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            Set<String> usedRuleIdsWithDurationModeUpdate = usedRulesWithDurationModeUpdate.stream().map(FileRulesModel::getRuleId).collect(Collectors.toSet());
            this.logbookRuleImportManager.updateCheckFileRulesLogbookOperation(StatusCode.KO, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), usedRuleIdsWithDurationModeUpdate, eip);
            LOGGER.error("Cannot update used rule duration mode (null to defined of from defined to null) " + String.valueOf(usedRuleIdsWithDurationModeUpdate));
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw new FileRulesException("Cannot update used rule duration mode");
        }
        catch (StorageException e) {
            this.logbookRuleImportManager.updateStpImportRulesLogbookOperation(eip, StatusCode.KO, filename);
            throw new FileRulesException((Throwable)e);
        }
    }

    private void launchWorkflow(List<FileRulesModel> usedUpdateRulesForReport) throws InvalidParseOperationException, InvalidGuidOperationException, LogbookClientException {
        try (ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();){
            ArrayNode arrayNode = JsonHandler.createArrayNode();
            for (FileRulesModel ruleNode : usedUpdateRulesForReport) {
                arrayNode.add(JsonHandler.toJsonNode((Object)ruleNode));
            }
            GUID updateOperationGUID = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
            GUID reqId = GUIDReader.getGUID((String)VitamThreadUtils.getVitamSession().getRequestId());
            this.logbookRuleImportManager.initializeUnitRuleUpdateWorkflowLogbook(updateOperationGUID, reqId);
            try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                workspaceClient.createContainer(updateOperationGUID.getId());
                workspaceClient.putObject(updateOperationGUID.getId(), "PROCESSING/updatedRules.json", JsonHandler.writeToInpustream((Object)arrayNode));
                workspaceClient.putObject(updateOperationGUID.getId(), "operation_context.json", JsonHandler.writeToInpustream((Object)OperationContextModel.get(usedUpdateRulesForReport)));
                OperationContextMonitor.compressInWorkspace((WorkspaceClientFactory)this.workspaceClientFactory, (String)updateOperationGUID.getId(), (LogbookTypeProcess)Contexts.UPDATE_RULES_ARCHIVE_UNITS.getLogbookTypeProcess(), (String[])new String[]{"operation_context.json"});
                processManagementClient.initVitamProcess(updateOperationGUID.getId(), Contexts.UPDATE_RULES_ARCHIVE_UNITS.name());
                LOGGER.debug("Started Update in Resource");
                RequestResponse ret = processManagementClient.updateOperationActionProcess(ProcessAction.RESUME.getValue(), updateOperationGUID.getId());
                if (Response.Status.ACCEPTED.getStatusCode() != ret.getStatus()) {
                    throw new VitamClientException("Process couldnt be executed");
                }
            }
            catch (BadRequestException | InternalServerException | VitamClientException | OperationContextException | ContentAddressableStorageServerException e) {
                LOGGER.error(e);
                this.logbookRuleImportManager.updateUnitRuleUpdateWorkflowLogbook(updateOperationGUID, reqId);
            }
        }
    }

    private void commitRules(List<FileRulesModel> fileRulesModelToUpdate, List<FileRulesModel> fileRulesModelToDelete, List<FileRulesModel> fileRulesModelToInsert, GUID eipMaster) throws FileRulesException, LogbookClientException {
        try {
            JsonNode fileRulesNodeToInsert;
            Integer sequence = this.vitamCounterService.getSequence(ParameterHelper.getTenantParameter(), SequenceType.RULES_SEQUENCE);
            for (FileRulesModel fileRulesModel : fileRulesModelToUpdate) {
                this.updateFileRules(fileRulesModel, sequence);
            }
            if (!fileRulesModelToInsert.isEmpty() && (fileRulesNodeToInsert = JsonHandler.toJsonNode(fileRulesModelToInsert)) != null && fileRulesNodeToInsert.isArray()) {
                ArrayNode fileRulesArrayToInsert = (ArrayNode)fileRulesNodeToInsert;
                this.commit(fileRulesArrayToInsert);
            }
            for (FileRulesModel fileRulesModel : fileRulesModelToDelete) {
                this.deleteFileRules(fileRulesModel);
            }
            this.logbookRuleImportManager.updateCommitFileRulesLogbookOperationOkOrKo(StatusCode.OK, eipMaster, fileRulesModelToDelete.size(), fileRulesModelToUpdate.size(), fileRulesModelToInsert.size());
        }
        catch (InvalidCreateOperationException | BadRequestException | DocumentAlreadyExistsException | InvalidParseOperationException | SchemaValidationException | ReferentialException e) {
            LOGGER.error(e);
            this.logbookRuleImportManager.updateCommitFileRulesLogbookOperationOkOrKo(StatusCode.KO, eipMaster, fileRulesModelToDelete.size(), fileRulesModelToUpdate.size(), fileRulesModelToInsert.size());
            throw new FileRulesException(e);
        }
    }

    private void commit(ArrayNode validatedRules) throws ReferentialException, SchemaValidationException, DocumentAlreadyExistsException {
        if (validatedRules.size() > 0) {
            Integer sequence = this.vitamCounterService.getNextSequence(ParameterHelper.getTenantParameter(), SequenceType.RULES_SEQUENCE);
            this.mongoAccess.insertDocuments(validatedRules, FunctionalAdminCollections.RULES, sequence);
        }
    }

    public RuleImportResultSet checkFile(Map<String, FileRulesModel> rulesToImport) throws ReferentialException {
        Map<String, FileRulesModel> rulesInDatabase = this.getAllRulesInDB();
        RuleImportDiff ruleImportDiff = new RuleImportDiff(rulesToImport, rulesInDatabase);
        List<FileRulesModel> usedRulesToDelete = this.getUsedRules(ruleImportDiff.getRulesToDelete());
        if (!usedRulesToDelete.isEmpty()) {
            throw new FileRulesDeleteException("used Rules want to be deleted", usedRulesToDelete);
        }
        List<FileRulesModel> usedRulesWithDurationModeUpdate = this.getUsedRules(ruleImportDiff.getRulesWithDurationModeUpdate());
        if (!usedRulesWithDurationModeUpdate.isEmpty()) {
            throw new FileRulesIllegalDurationModeUpdateException("Cannot update rule duration mode (defined/undefined) for used rule", usedRulesWithDurationModeUpdate);
        }
        List<FileRulesModel> usedUpdatedRules = this.getUsedRules(ruleImportDiff.getRulesToUpdate());
        List<FileRulesModel> usedUpdateRulesForUpdateUnit = this.getUsedRules(ruleImportDiff.getRulesToUpdateUnsafely());
        return new RuleImportResultSet(ruleImportDiff.getRulesToInsert(), ruleImportDiff.getRulesToUpdate(), ruleImportDiff.getRulesToDelete(), usedUpdatedRules, usedUpdateRulesForUpdateUnit);
    }

    private Map<String, FileRulesModel> getAllRulesInDB() throws ReferentialException {
        List<FileRules> rulesInDB = this.findAllFileRulesInDB();
        return rulesInDB.stream().map(RulesManagerFileImpl::convertFileRulesToFilesRulesModel).collect(Collectors.toMap(FileRulesModel::getRuleId, r -> r));
    }

    private List<FileRules> findAllFileRulesInDB() throws ReferentialException {
        Select select = new Select();
        ArrayList<FileRules> fileRules = new ArrayList<FileRules>();
        RequestResponseOK<FileRules> response = this.findDocuments((JsonNode)select.getFinalSelect());
        if (response != null) {
            return response.getResults();
        }
        return fileRules;
    }

    public Map<String, FileRulesModel> getRulesFromCSV(InputStream ruleInputStream) throws IOException, FileRulesReadException {
        HashMap<String, FileRulesModel> rulesModel = new HashMap<String, FileRulesModel>();
        HashMap errorsMap = new HashMap();
        CsvMapper csvMapper = new CsvMapper();
        MappingIterator csvReader = csvMapper.readerFor(FileRulesCSV.class).with((FormatSchema)CsvSchema.emptySchema().withHeader()).readValues(ruleInputStream);
        int lineNumber = 1;
        List rules = csvReader.readAll();
        for (FileRulesCSV rule : rules) {
            RuleType ruletype;
            ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
            rule.setRuleDuration((String)StringUtils.defaultIfEmpty((CharSequence)rule.getRuleDuration(), null));
            rule.setRuleMeasurement((String)StringUtils.defaultIfEmpty((CharSequence)rule.getRuleMeasurement(), null));
            errors.addAll(this.checkParametersNotEmpty(rule, ++lineNumber));
            errors.addAll(this.checkRuleDuration(rule, lineNumber));
            if (rulesModel.containsKey(rule.getRuleId())) {
                errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_RULEID_DUPLICATION, lineNumber, rule));
            }
            RuleMeasurementEnum ruleMeasurement = null;
            if (rule.getRuleMeasurement() != null) {
                try {
                    ruleMeasurement = RuleMeasurementEnum.getEnumFromType((String)rule.getRuleMeasurement());
                }
                catch (IllegalStateException e2) {
                    errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_WRONG_RULEMEASUREMENT, lineNumber, rule));
                }
            }
            if ((ruletype = RuleType.getEnumFromName((String)rule.getRuleType())) == null) {
                errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_WRONG_RULETYPE_UNKNOW, lineNumber, rule));
            }
            if (ruletype != null && ruleMeasurement != null && rule.getRuleDuration() != null) {
                errors.addAll(this.checkAssociationRuleDurationRuleMeasurementLimit(lineNumber, rule));
                errors.addAll(this.checkRuleDurationWithConfiguration(lineNumber, rule));
            }
            if (!errors.isEmpty()) {
                errorsMap.put(lineNumber, errors);
                rulesModel.put(rule.getRuleId(), new FileRulesModel());
                continue;
            }
            FileRulesModel fileRulesModel = this.getFileRulesModelFromCSV(rule);
            rulesModel.put(rule.getRuleId(), fileRulesModel);
        }
        if (!errorsMap.isEmpty()) {
            Set hasDurationExceededErrors = errorsMap.values().stream().flatMap(Collection::stream).filter(e -> e.getCode().equals((Object)FileRulesErrorCode.STP_IMPORT_RULES_RULEDURATION_EXCEED)).collect(Collectors.toSet());
            if (!hasDurationExceededErrors.isEmpty()) {
                throw new FileRulesDurationException(RULE_DURATION_EXCEED, errorsMap);
            }
            throw new FileRulesCsvException(INVALID_CSV_FILE, errorsMap);
        }
        return rulesModel;
    }

    @Nonnull
    private FileRulesModel getFileRulesModelFromCSV(FileRulesCSV rule) {
        FileRulesModel fileRulesModel = new FileRulesModel();
        fileRulesModel.setRuleId(rule.getRuleId());
        fileRulesModel.setRuleType(RuleType.getEnumFromName((String)rule.getRuleType()));
        fileRulesModel.setRuleDuration(rule.getRuleDuration());
        fileRulesModel.setRuleDescription(rule.getRuleDescription());
        fileRulesModel.setRuleValue(rule.getRuleValue());
        fileRulesModel.setRuleMeasurement(RuleMeasurementEnum.getEnumFromType((String)rule.getRuleMeasurement()));
        fileRulesModel.setUpdateDate(LocalDateUtil.nowFormatted());
        fileRulesModel.setCreationDate(LocalDateUtil.nowFormatted());
        return fileRulesModel;
    }

    private List<FileRulesModel> getUsedRules(List<FileRulesModel> rules) {
        return rules.stream().filter(this::isRuleUsedByUnit).collect(Collectors.toList());
    }

    private boolean isRuleUsedByUnit(FileRulesModel rule) {
        try {
            List<JsonNode> unitsUsedByRule = this.checkRuleReferencedByUnitInDatabase(this.fileRulesLinkedToUnitQueryBuilder(rule));
            return !CollectionUtils.isEmpty(unitsUsedByRule);
        }
        catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new RuntimeException("Could not check rule references", e);
        }
    }

    private void generateReport(StatusCode statusCode, Map<Integer, List<ErrorReport>> errors, GUID eipMaster, List<FileRulesModel> usedDeletedRules, List<FileRulesModel> usedRulesWithDurationModeUpdate, List<FileRulesModel> usedUpdatedRules, List<FileRulesModel> fileRulesToDelete, List<FileRulesModel> fileRulesToUpdate, List<FileRulesModel> fileRulesToInsert) throws StorageException {
        String fileName = String.valueOf(eipMaster) + ".json";
        InputStream stream = this.generateReportContent(errors, usedDeletedRules, usedRulesWithDurationModeUpdate, usedUpdatedRules, fileRulesToDelete, fileRulesToUpdate, fileRulesToInsert, statusCode, eipMaster);
        try {
            this.backupService.saveFile(stream, eipMaster, RULES_REPORT, DataCategory.REPORT, fileName);
        }
        catch (VitamException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
    }

    private void updateFileRules(FileRulesModel fileRulesModel, Integer sequence) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException, SchemaValidationException, BadRequestException {
        UpdateParserSingle updateParser = new UpdateParserSingle(new VarNameAdapter());
        Update updateFileRules = new Update();
        ArrayList<Object> actions = new ArrayList<Object>();
        SetAction setRuleValue = new SetAction("RuleValue", fileRulesModel.getRuleValue());
        actions.add(setRuleValue);
        SetAction setRuleDescription = new SetAction("RuleDescription", fileRulesModel.getRuleDescription());
        actions.add(setRuleDescription);
        SetAction setUpdateDate = new SetAction(UPDATE_DATE, LocalDateUtil.nowFormatted());
        actions.add(setUpdateDate);
        if (fileRulesModel.getRuleMeasurement() != null) {
            SetAction setRuleMeasurement = new SetAction("RuleMeasurement", fileRulesModel.getRuleMeasurement().name());
            actions.add(setRuleMeasurement);
        } else {
            UnsetAction unsetRuleMeasurement = new UnsetAction(new String[]{"RuleMeasurement"});
            actions.add(unsetRuleMeasurement);
        }
        if (fileRulesModel.getRuleDuration() != null) {
            SetAction setRuleDuration = new SetAction("RuleDuration", fileRulesModel.getRuleDuration());
            actions.add(setRuleDuration);
        } else {
            UnsetAction unsetRuleDuration = new UnsetAction(new String[]{"RuleDuration"});
            actions.add(unsetRuleDuration);
        }
        SetAction setRuleType = new SetAction("RuleType", fileRulesModel.getRuleType().name());
        actions.add(setRuleType);
        updateFileRules.setQuery((Query)QueryHelper.eq((String)"RuleId", (String)fileRulesModel.getRuleId()));
        updateFileRules.addActions((Action[])actions.toArray(Action[]::new));
        updateParser.parse((JsonNode)updateFileRules.getFinalUpdate());
        ObjectNode queryDslForUpdate = updateParser.getRequest().getFinalUpdate();
        this.mongoAccess.updateData((JsonNode)queryDslForUpdate, FunctionalAdminCollections.RULES, sequence);
    }

    private void deleteFileRules(FileRulesModel fileRulesModel) {
        Delete delete = new Delete();
        try {
            delete.setQuery((Query)QueryHelper.eq((String)"RuleId", (String)fileRulesModel.getRuleId()));
            DbRequestResult result = this.mongoAccess.deleteCollectionForTesting(FunctionalAdminCollections.RULES, delete);
            result.close();
        }
        catch (InvalidCreateOperationException | DatabaseException e) {
            LOGGER.error(e);
        }
    }

    private JsonNode fileRulesLinkedToUnitQueryBuilder(FileRulesModel fileRulesModels) {
        SelectMultiQuery selectMultiple = new SelectMultiQuery();
        try {
            String ruleFieldName = "#management." + String.valueOf(fileRulesModels.getRuleType()) + ".Rules.Rule";
            selectMultiple.setQuery((Query)QueryHelper.eq((String)ruleFieldName, (String)fileRulesModels.getRuleId()));
            selectMultiple.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            selectMultiple.setLimitFilter(0L, 1L);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new RuntimeException("Query construction not valid ", e);
        }
        return selectMultiple.getFinalSelect();
    }

    private List<ErrorReport> checkRuleDuration(FileRulesCSV fileRulesCSV, int line) {
        int duration;
        ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
        if (fileRulesCSV.getRuleDuration() != null && !"unlimited".equalsIgnoreCase(fileRulesCSV.getRuleDuration()) && (duration = this.parseWithDefault(fileRulesCSV.getRuleDuration())) < 0) {
            errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_WRONG_RULEDURATION, line, fileRulesCSV));
        }
        return errors;
    }

    private int parseWithDefault(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException err) {
            return -777;
        }
    }

    private List<ErrorReport> checkParametersNotEmpty(FileRulesCSV fileRulesModel, int line) {
        boolean hasRuleMeasurement;
        ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
        ArrayList<String> missingParam = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)fileRulesModel.getRuleId())) {
            missingParam.add("RuleId");
        }
        if (StringUtils.isEmpty((CharSequence)fileRulesModel.getRuleType())) {
            missingParam.add("RuleType");
        }
        if (StringUtils.isEmpty((CharSequence)fileRulesModel.getRuleValue())) {
            missingParam.add("RuleValue");
        }
        boolean isHoldRule = RuleType.HoldRule.isNameEquals(fileRulesModel.getRuleType());
        boolean hasRuleDuration = fileRulesModel.getRuleDuration() != null;
        boolean bl = hasRuleMeasurement = fileRulesModel.getRuleMeasurement() != null;
        if (isHoldRule) {
            if (hasRuleMeasurement && !hasRuleDuration) {
                missingParam.add("RuleDuration");
            }
            if (hasRuleDuration && !hasRuleMeasurement) {
                missingParam.add("RuleMeasurement");
            }
        } else {
            if (!hasRuleDuration) {
                missingParam.add("RuleDuration");
            }
            if (!hasRuleMeasurement) {
                missingParam.add("RuleMeasurement");
            }
        }
        if (!missingParam.isEmpty()) {
            errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_NOT_CSV_FORMAT, line, String.join((CharSequence)", ", missingParam)));
        }
        return errors;
    }

    private List<ErrorReport> checkAssociationRuleDurationRuleMeasurementLimit(int line, FileRulesCSV fileRulesCSV) {
        ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
        try {
            if (!fileRulesCSV.getRuleDuration().equalsIgnoreCase("unlimited") && (fileRulesCSV.getRuleMeasurement().equalsIgnoreCase(RuleMeasurementEnum.YEAR.getType()) && Integer.parseInt(fileRulesCSV.getRuleDuration()) > 999 || fileRulesCSV.getRuleMeasurement().equalsIgnoreCase(RuleMeasurementEnum.MONTH.getType()) && Integer.parseInt(fileRulesCSV.getRuleDuration()) > 11988 || fileRulesCSV.getRuleMeasurement().equalsIgnoreCase(RuleMeasurementEnum.DAY.getType()) && Integer.parseInt(fileRulesCSV.getRuleDuration()) > 359640)) {
                errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_WRONG_TOTALDURATION, line, fileRulesCSV));
            }
        }
        catch (NumberFormatException e) {
            errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_WRONG_TOTALDURATION, line, fileRulesCSV));
        }
        return errors;
    }

    private List<ErrorReport> checkRuleDurationWithConfiguration(int line, FileRulesCSV fileRulesCSV) {
        int durationRule;
        ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
        String ruleType = fileRulesCSV.getRuleType();
        String[] min = this.vitamRuleService.getMinimumRuleDuration(ParameterHelper.getTenantParameter(), ruleType).split(" ");
        int durationConf = 0;
        if (min.length == 2) {
            durationConf = this.calculDuration(min[0], min[1]);
        }
        if ((durationRule = this.calculDuration(fileRulesCSV.getRuleDuration(), fileRulesCSV.getRuleMeasurement())) < durationConf) {
            errors.add(new ErrorReport(FileRulesErrorCode.STP_IMPORT_RULES_RULEDURATION_EXCEED, line, fileRulesCSV));
        }
        return errors;
    }

    private int calculDuration(String ruleDuration, String ruleMeasurement) {
        int duration = 0;
        if (ruleDuration.equalsIgnoreCase("unlimited")) {
            return Integer.MAX_VALUE;
        }
        if (ruleDuration.matches("[0-9]+")) {
            duration = Integer.parseInt(ruleDuration);
        }
        switch (ruleMeasurement.toLowerCase()) {
            case "year": {
                return duration * 365;
            }
            case "month": {
                return duration * 30;
            }
            case "day": {
                return duration;
            }
        }
        return 0;
    }

    public FileRules findDocumentById(String id) {
        return (FileRules)this.mongoAccess.getDocumentByUniqueId(id, FunctionalAdminCollections.RULES, "RuleId");
    }

    public RequestResponseOK<FileRules> findDocuments(JsonNode select) throws ReferentialException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(select, FunctionalAdminCollections.RULES);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(select, FileRules.class);
            return requestResponseOK;
        }
    }

    private List<JsonNode> checkRuleReferencedByUnitInDatabase(JsonNode select) throws MetaDataDocumentSizeException, MetaDataExecutionException, InvalidParseOperationException, MetaDataClientServerException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            JsonNode unitsResultNode = metaDataClient.selectUnits(select);
            List list = RequestResponseOK.getFromJsonNode((JsonNode)unitsResultNode).getResults();
            return list;
        }
    }

    public InputStream generateReportContent(Map<Integer, List<ErrorReport>> errors, List<FileRulesModel> usedDeletedRules, List<FileRulesModel> usedRulesWithDurationModeUpdate, List<FileRulesModel> usedUpdatedRules, List<FileRulesModel> fileRulesModelToDelete, List<FileRulesModel> fileRulesModelToUpdate, List<FileRulesModel> fileRulesModelToInsert, StatusCode status, GUID eipMaster) {
        FileRulesManagementReport reportFinal = new FileRulesManagementReport();
        HashMap<String, String> guidmasterNode = new HashMap<String, String>();
        ArrayList<String> usedDeletedFileRuleList = new ArrayList<String>();
        ArrayList<String> usedUpdatedFileRuleList = new ArrayList<String>();
        guidmasterNode.put("evType", STP_IMPORT_RULES);
        guidmasterNode.put("evDateTime", LocalDateUtil.nowFormatted());
        if (eipMaster != null) {
            guidmasterNode.put("evId", eipMaster.toString());
        }
        guidmasterNode.put("outMessg", VitamErrorMessages.getFromKey((String)("STP_IMPORT_RULES." + String.valueOf(status))));
        HashMap<String, Object> storeErrors = new HashMap<String, Object>();
        for (Integer line : errors.keySet()) {
            List<ErrorReport> errorsReports = errors.get(line);
            ArrayNode messagesArrayNode = JsonHandler.createArrayNode();
            for (ErrorReport error : errorsReports) {
                ObjectNode errorNode = JsonHandler.createObjectNode();
                errorNode.put("Code", error.getCode().name() + ".KO");
                errorNode.put("Message", VitamErrorMessages.getFromKey((String)error.getCode().name()));
                switch (error.getCode()) {
                    case STP_IMPORT_RULES_MISSING_INFORMATION: {
                        errorNode.put("Information additionnelle", error.getMissingInformations());
                        break;
                    }
                    case STP_IMPORT_RULES_RULEID_DUPLICATION: {
                        errorNode.put("Information additionnelle", error.getFileRulesCSV().getRuleId());
                        break;
                    }
                    case STP_IMPORT_RULES_WRONG_RULEDURATION: {
                        errorNode.put("Information additionnelle", error.getFileRulesCSV().getRuleDuration());
                        break;
                    }
                    case STP_IMPORT_RULES_WRONG_RULEMEASUREMENT: {
                        errorNode.put("Information additionnelle", error.getFileRulesCSV().getRuleMeasurement());
                        break;
                    }
                    case STP_IMPORT_RULES_WRONG_RULETYPE_UNKNOW: {
                        errorNode.put("Information additionnelle", error.getFileRulesCSV().getRuleType());
                        break;
                    }
                    case STP_IMPORT_RULES_WRONG_TOTALDURATION: {
                        errorNode.put("Information additionnelle", error.getFileRulesCSV().getRuleDuration() + " " + error.getFileRulesCSV().getRuleMeasurement());
                        break;
                    }
                    case STP_IMPORT_RULES_RULEDURATION_EXCEED: {
                        ObjectNode info = JsonHandler.createObjectNode();
                        info.put("RuleType", error.getFileRulesCSV().getRuleType());
                        info.put("RuleDurationMin", this.vitamRuleService.getMinimumRuleDuration(ParameterHelper.getTenantParameter(), error.getFileRulesCSV().getRuleType()));
                        errorNode.set("Information additionnelle", (JsonNode)info);
                        break;
                    }
                    case STP_IMPORT_RULES_NOT_CSV_FORMAT: {
                        errorNode.put("Information additionnelle", error.getMissingInformations());
                        break;
                    }
                }
                messagesArrayNode.add((JsonNode)errorNode);
            }
            storeErrors.put(String.format("line %s", line), messagesArrayNode);
        }
        for (FileRulesModel fileRulesModel : usedDeletedRules) {
            usedDeletedFileRuleList.add(fileRulesModel.toString());
        }
        for (FileRulesModel fileRulesModel : usedUpdatedRules) {
            usedUpdatedFileRuleList.add(fileRulesModel.toString());
        }
        reportFinal.setJdo(guidmasterNode);
        if (!errors.isEmpty()) {
            reportFinal.setError(storeErrors);
        }
        reportFinal.setUsedFileRulesToDelete(usedDeletedFileRuleList);
        reportFinal.setUsedFileRulesToUpdate(usedUpdatedFileRuleList);
        reportFinal.setUsedRulesWithDurationModeUpdate(this.rulesToRuleIds(usedRulesWithDurationModeUpdate));
        reportFinal.setFileRulesToDelete(this.rulesToRuleIds(fileRulesModelToDelete));
        reportFinal.setFileRulesToUpdate(this.rulesToRuleIds(fileRulesModelToUpdate));
        reportFinal.setFileRulesToImport(this.rulesToRuleIds(fileRulesModelToInsert));
        return new ByteArrayInputStream(JsonHandler.unprettyPrint((Object)reportFinal).getBytes(StandardCharsets.UTF_8));
    }

    private List<String> rulesToRuleIds(List<FileRulesModel> rules) {
        return rules.stream().map(FileRulesModel::getRuleId).collect(Collectors.toList());
    }

    private ArrayNode getRuleFromCollection(int tenant) throws InvalidParseOperationException {
        return this.backupService.getCollectionInJson(FunctionalAdminCollections.RULES, tenant);
    }

    private ArrayNode getRuleFromOffer(int tenant) {
        Integer originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
        Optional<CollectionBackupModel> collectionBackup = this.restoreBackupService.readLatestSavedFile(VitamConfiguration.getDefaultStrategy(), null, FunctionalAdminCollections.RULES);
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        if (collectionBackup.isPresent()) {
            try {
                arrayNode = (ArrayNode)JsonHandler.toJsonNode((Object)collectionBackup.get().getDocuments());
            }
            catch (InvalidParseOperationException e) {
                LOGGER.debug("ERROR: The file isn't in JSON type");
            }
        }
        VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
        return arrayNode;
    }

    boolean checkRuleConformity(ArrayNode array1, ArrayNode array2, int tenant) {
        if (!array1.toString().equals(array2.toString())) {
            JsonNode patch = JsonDiff.asJson((JsonNode)array1, (JsonNode)array2);
            alertService.createAlert("Check failed: the security save of the rules repository of tenant " + tenant + " is not equal to its value in database.\n" + String.valueOf(patch));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRuleConformity(List<Integer> tenants) throws ReferentialException {
        int threadPoolSize = Math.min(this.ruleAuditThreadPoolSize, tenants.size());
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)threadPoolSize);
        try {
            ArrayList<CompletableFuture> completableFutures = new ArrayList<CompletableFuture>();
            for (Integer tenantId : tenants) {
                CompletableFuture completableFuture = CompletableFuture.supplyAsync(() -> {
                    Thread.currentThread().setName("CheckRuleConformity-" + tenantId);
                    VitamThreadUtils.getVitamSession().setTenantId(tenantId);
                    try {
                        return this.checkRuleConformity(this.getRuleFromCollection(tenantId), this.getRuleFromOffer(tenantId), tenantId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("An error occurred during rule audit for tenant " + tenantId, e);
                    }
                }, executorService);
                completableFutures.add(completableFuture);
            }
            boolean allTenantsSucceeded = true;
            for (CompletableFuture completableFuture : completableFutures) {
                try {
                    Boolean success = (Boolean)completableFuture.get();
                    if (success.booleanValue()) continue;
                    allTenantsSucceeded = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ReferentialException("Rule audit interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOGGER.error("Rule audit operation failed", (Throwable)e);
                    allTenantsSucceeded = false;
                }
            }
            if (!allTenantsSucceeded) {
                throw new ReferentialException("One or more tenants failed rule audit");
            }
        }
        finally {
            executorService.shutdown();
        }
    }
}

