/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.rules;

import fr.gouv.vitam.common.model.administration.FileRulesModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RuleImportDiff {
    private final List<FileRulesModel> rulesToInsert = new ArrayList<FileRulesModel>();
    private final List<FileRulesModel> rulesToUpdateUnsafely = new ArrayList<FileRulesModel>();
    private final List<FileRulesModel> rulesToUpdate;
    private final List<FileRulesModel> rulesToDelete = new ArrayList<FileRulesModel>();
    private final List<FileRulesModel> rulesWithDurationModeUpdate;

    private RuleImportDiff() {
        this.rulesToUpdate = new ArrayList<FileRulesModel>();
        this.rulesWithDurationModeUpdate = new ArrayList<FileRulesModel>();
    }

    RuleImportDiff(List<FileRulesModel> rulesFromFileIds, List<FileRulesModel> rulesInDatabaseIds) {
        this();
        this.getDiff(Optional.ofNullable(rulesFromFileIds).orElse(Collections.emptyList()), Optional.ofNullable(rulesInDatabaseIds).orElse(Collections.emptyList()));
    }

    RuleImportDiff(Map<String, FileRulesModel> rulesFromFile, Map<String, FileRulesModel> rulesInDatabase) {
        this();
        this.getDiff(Optional.ofNullable(rulesFromFile).orElse(Collections.emptyMap()), Optional.ofNullable(rulesInDatabase).orElse(Collections.emptyMap()));
    }

    private void getDiff(List<FileRulesModel> rulesFromFileIds, List<FileRulesModel> rulesInDatabaseIds) {
        Map<String, FileRulesModel> rulesInDatabase = rulesInDatabaseIds.stream().collect(Collectors.toMap(FileRulesModel::getRuleId, Function.identity()));
        Map<String, FileRulesModel> rulesFromFile = rulesFromFileIds.stream().collect(Collectors.toMap(FileRulesModel::getRuleId, Function.identity()));
        this.getDiff(rulesFromFile, rulesInDatabase);
    }

    private void getDiff(Map<String, FileRulesModel> rulesFromFile, Map<String, FileRulesModel> rulesInDatabase) {
        for (FileRulesModel rule : rulesFromFile.values()) {
            FileRulesModel ruleInDatabase = rulesInDatabase.get(rule.getRuleId());
            if (ruleInDatabase != null) {
                if (ruleInDatabase.equals((Object)rule)) continue;
                this.addRuleToUpdate(rule);
                if (this.hasRuleDurationChanged(ruleInDatabase, rule)) {
                    this.addRuleToUpdateUnsafely(rule);
                }
                if (!this.isUpdateOfOldRuleWithoutDurationToNewRuleWithDuration(ruleInDatabase, rule) && !this.isUpdateOfOldRuleWithDurationToNewRuleWithoutDuration(ruleInDatabase, rule)) continue;
                this.addRuleToUpdateWithDurationModeSwitch(rule);
                continue;
            }
            this.addRuleToInsert(rule);
        }
        for (FileRulesModel databaseRule : rulesInDatabase.values()) {
            if (rulesFromFile.containsKey(databaseRule.getRuleId())) continue;
            this.addRuleToDelete(databaseRule);
        }
    }

    private boolean hasRuleDurationChanged(FileRulesModel oldRule, FileRulesModel newRule) {
        boolean sameRuleDuration = StringUtils.equals((CharSequence)oldRule.getRuleDuration(), (CharSequence)newRule.getRuleDuration());
        boolean sameRuleMeasurement = oldRule.getRuleMeasurement() == newRule.getRuleMeasurement();
        return !sameRuleDuration || !sameRuleMeasurement;
    }

    private boolean isUpdateOfOldRuleWithoutDurationToNewRuleWithDuration(FileRulesModel oldRule, FileRulesModel newRule) {
        return !this.hasRuleDuration(oldRule) && this.hasRuleDuration(newRule);
    }

    private boolean isUpdateOfOldRuleWithDurationToNewRuleWithoutDuration(FileRulesModel oldRule, FileRulesModel newRule) {
        return this.hasRuleDuration(oldRule) && !this.hasRuleDuration(newRule);
    }

    private boolean hasRuleDuration(FileRulesModel rule) {
        return rule.getRuleDuration() != null;
    }

    private void addRuleToInsert(FileRulesModel rule) {
        this.rulesToInsert.add(rule);
    }

    private void addRuleToUpdateUnsafely(FileRulesModel rule) {
        this.rulesToUpdateUnsafely.add(rule);
    }

    private void addRuleToUpdateWithDurationModeSwitch(FileRulesModel rule) {
        this.rulesWithDurationModeUpdate.add(rule);
    }

    private void addRuleToUpdate(FileRulesModel rule) {
        this.rulesToUpdate.add(rule);
    }

    private void addRuleToDelete(FileRulesModel rule) {
        this.rulesToDelete.add(rule);
    }

    public List<FileRulesModel> getRulesToInsert() {
        return this.rulesToInsert;
    }

    public List<FileRulesModel> getRulesToUpdateUnsafely() {
        return this.rulesToUpdateUnsafely;
    }

    public List<FileRulesModel> getRulesWithDurationModeUpdate() {
        return this.rulesWithDurationModeUpdate;
    }

    public List<FileRulesModel> getRulesToDelete() {
        return this.rulesToDelete;
    }

    public List<FileRulesModel> getRulesToUpdate() {
        return this.rulesToUpdate;
    }
}

