/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.reconstruction;

import com.google.common.collect.Iterators;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterBackupModel;
import fr.gouv.vitam.functional.administration.common.CollectionBackupModel;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.backup.RestoreBackupService;
import fr.gouv.vitam.storage.engine.client.OfferLogHelper;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.bson.Document;

public class RestoreBackupServiceImpl
implements RestoreBackupService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RestoreBackupServiceImpl.class);
    private static final String OBJECT_ID_TAG = "objectId";
    private static final String EXTENSION_JSON = ".json";
    private final StorageClientFactory storageClientFactory = StorageClientFactory.getInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> getLatestSavedFileName(String strategy, String offerId, DataCategory type, FunctionalAdminCollections collection) {
        try (StorageClient storageClient = StorageClientFactory.getInstance().getClient();
             CloseableIterator listing = storageClient.listContainer(strategy, offerId, type);){
            Iterable iterable = () -> listing;
            Stream<ObjectEntry> stream = StreamSupport.stream(iterable.spliterator(), false);
            String regex = "\\d+_+(\\w+)_+(\\d+)?.json$";
            Pattern pattern = Pattern.compile(regex);
            Optional<Integer> result = stream.map(ObjectEntry::getObjectId).map(pattern::matcher).filter(Matcher::matches).filter(matcher -> collection.getName().equals(matcher.group(1))).map(matcher -> Integer.valueOf(matcher.group(2))).max(Comparator.naturalOrder());
            if (!result.isPresent()) return Optional.empty();
            Optional<String> optional = Optional.of(FunctionalBackupService.getBackupFileName(collection, ParameterHelper.getTenantParameter(), result.get()));
            return optional;
        }
        catch (StorageServerClientException e) {
            LOGGER.error("ERROR: Exception has been thrown when using storage service:", (Throwable)e);
            return Optional.empty();
        }
        catch (StorageNotFoundClientException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Optional<CollectionBackupModel> readLatestSavedFile(String strategy, String offerId, FunctionalAdminCollections collection) {
        Optional<String> lastBackupVersion = this.getLatestSavedFileName(strategy, offerId, DataCategory.BACKUP, collection);
        if (lastBackupVersion.isPresent()) {
            Optional<CollectionBackupModel> optional;
            StorageClient storageClient;
            Response response;
            block11: {
                response = null;
                storageClient = StorageClientFactory.getInstance().getClient();
                response = storageClient.getContainerAsync(strategy, offerId, lastBackupVersion.get(), DataCategory.BACKUP, AccessLogUtils.getNoLogAccessLog());
                InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                optional = Optional.of((CollectionBackupModel)JsonHandler.getFromInputStream((InputStream)inputStream, CollectionBackupModel.class));
                if (storageClient == null) break block11;
                storageClient.close();
            }
            StreamUtils.consumeAnyEntityAndClose((Response)response);
            return optional;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (storageClient != null) {
                                try {
                                    storageClient.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (InvalidParseOperationException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageException e) {
                            LOGGER.error("ERROR: Exception has been thrown when using storage service:", e);
                            StreamUtils.consumeAnyEntityAndClose(response);
                        }
                    }
                    catch (Throwable throwable3) {
                        StreamUtils.consumeAnyEntityAndClose(response);
                        throw throwable3;
                    }
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Iterator<List<OfferLog>> getListing(String strategy, DataCategory dataCategory, Long offset, int limit, Order order) throws StorageServerClientException, StorageNotFoundClientException {
        LOGGER.info(String.format("[Reconstruction]: Retrieve listing of {%s} Collection on {%s} Vitam strategy from {%s} offset with {%s} limit", dataCategory, strategy, offset, limit));
        return Iterators.partition((Iterator)OfferLogHelper.getListing((StorageClientFactory)this.storageClientFactory, (String)strategy, (String)this.storageClientFactory.getClient().getReferentOffer(strategy), (DataCategory)dataCategory, (Long)offset, (Order)order, (int)VitamConfiguration.getBatchSize(), (Integer)limit), (int)VitamConfiguration.getBatchSize());
    }

    /*
     * Loose catch block
     */
    @Override
    public AccessionRegisterBackupModel loadData(String strategy, FunctionalAdminCollections collection, String filename, long offset) {
        AccessionRegisterBackupModel accessionRegisterBackupModel;
        StorageClient storageClient;
        InputStream inputStream;
        Response response;
        block16: {
            LOGGER.info(String.format("[Reconstruction]: Retrieve file {%s} from storage of {%s} Collection on {%s} Vitam strategy", filename, collection.name(), strategy));
            response = null;
            inputStream = null;
            storageClient = this.storageClientFactory.getClient();
            DataCategory type = switch (collection) {
                case FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL -> DataCategory.ACCESSION_REGISTER_DETAIL;
                case FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC -> DataCategory.ACCESSION_REGISTER_SYMBOLIC;
                default -> throw new IllegalArgumentException(String.format("ERROR: Invalid collection {%s}", collection));
            };
            String referentOfferForStrategy = storageClient.getReferentOffer(strategy);
            response = storageClient.getContainerAsync(strategy, referentOfferForStrategy, filename, type, AccessLogUtils.getNoLogAccessLog());
            inputStream = (InputStream)response.readEntity(InputStream.class);
            Document doc = (Document)JsonHandler.getFromInputStream((InputStream)inputStream, Document.class);
            AccessionRegisterBackupModel accessionRegisterBackupModel2 = new AccessionRegisterBackupModel();
            if (type.equals((Object)DataCategory.ACCESSION_REGISTER_DETAIL)) {
                accessionRegisterBackupModel2.setAccessionRegisterDetail(doc);
            } else {
                accessionRegisterBackupModel2.setAccessionRegisterSympbolic(doc);
            }
            accessionRegisterBackupModel2.setOffset(Long.valueOf(offset));
            accessionRegisterBackupModel = accessionRegisterBackupModel2;
            if (storageClient == null) break block16;
            storageClient.close();
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        StreamUtils.consumeAnyEntityAndClose((Response)response);
        return accessionRegisterBackupModel;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (storageClient != null) {
                            try {
                                storageClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException | StorageNotFoundClientException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageException e) {
                        throw new VitamRuntimeException("ERROR: Exception has been thrown when using storage service:", e);
                    }
                }
                catch (Throwable throwable3) {
                    IOUtils.closeQuietly(inputStream);
                    StreamUtils.consumeAnyEntityAndClose(response);
                    throw throwable3;
                }
            }
        }
    }
}

