/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.griffin;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.core.format.model.FunctionalOperationModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GriffinReport {
    @JsonProperty(value="Operation")
    private FunctionalOperationModel operation;
    @JsonProperty(value="StatusCode")
    private StatusCode statusCode;
    @JsonProperty(value="PreviousGriffinsVersion")
    private String previousGriffinsVersion;
    @JsonProperty(value="PreviousGriffinsCreationDate")
    private String previousGriffinsCreationDate;
    @JsonProperty(value="NewGriffinsVersion")
    private String newGriffinsVersion;
    @JsonProperty(value="NewGriffinsCreationDate")
    private String newGriffinsCreationDate;
    @JsonProperty(value="RemovedIdentifiers")
    private Set<String> removedIdentifiers;
    @JsonProperty(value="AddedIdentifiers")
    private Set<String> addedIdentifiers;
    @JsonProperty(value="UpdatedIdentifiers")
    private Map<String, List<String>> updatedIdentifiers;
    @JsonProperty(value="Warnings")
    private List<String> warnings = new ArrayList<String>();

    public GriffinReport() {
    }

    public GriffinReport(List<String> warnings) {
        this.warnings = warnings;
    }

    public static GriffinReport onlyWarning(GriffinReport griffinReport) {
        return new GriffinReport(griffinReport.getWarnings());
    }

    public FunctionalOperationModel getOperation() {
        return this.operation;
    }

    public GriffinReport setOperation(FunctionalOperationModel operation) {
        this.operation = operation;
        return this;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public GriffinReport setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Set<String> getRemovedIdentifiers() {
        return this.removedIdentifiers;
    }

    void setRemovedIdentifiers(Set<String> removedIdentifiers) {
        this.removedIdentifiers = removedIdentifiers;
    }

    public void addRemovedIdentifiers(String identifier) {
        this.removedIdentifiers.add(identifier);
    }

    public Set<String> getAddedIdentifiers() {
        return this.addedIdentifiers;
    }

    void setAddedIdentifiers(Set<String> addedIdentifiers) {
        this.addedIdentifiers = addedIdentifiers;
    }

    public void addAddedIdentifier(String identifier) {
        this.addedIdentifiers.add(identifier);
    }

    public Map<String, List<String>> getUpdatedIdentifiers() {
        return this.updatedIdentifiers;
    }

    public void setUpdatedIdentifiers(Map<String, List<String>> updatedIdentifiers) {
        this.updatedIdentifiers = updatedIdentifiers;
    }

    void addUpdatedIdentifiers(String identifier, List<String> diffs) {
        if (this.updatedIdentifiers == null) {
            this.updatedIdentifiers = new HashMap<String, List<String>>();
        }
        this.updatedIdentifiers.put(identifier, diffs);
    }

    List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    void addWarning(String message) {
        this.warnings.add(message);
    }

    String getPreviousGriffinsVersion() {
        return this.previousGriffinsVersion;
    }

    void setPreviousGriffinsVersion(String previousGriffinsVersion) {
        this.previousGriffinsVersion = previousGriffinsVersion;
    }

    String getPreviousGriffinsCreationDate() {
        return this.previousGriffinsCreationDate;
    }

    void setPreviousGriffinsCreationDate(String previousGriffinsCreationDate) {
        this.previousGriffinsCreationDate = previousGriffinsCreationDate;
    }

    String getNewGriffinsVersion() {
        return this.newGriffinsVersion;
    }

    void setNewGriffinsVersion(String newGriffinsVersion) {
        this.newGriffinsVersion = newGriffinsVersion;
    }

    String getNewGriffinsCreationDate() {
        return this.newGriffinsCreationDate;
    }

    public void setNewGriffinsCreationDate(String newGriffinsCreationDate) {
        this.newGriffinsCreationDate = newGriffinsCreationDate;
    }
}

