/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.SchemaControl;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.functional.administration.core.archiveunitprofilesSchema.CombinedSchemaProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ControlProcessor
implements CombinedSchemaProcessor {
    private JsonNode controlSchemaNode;
    private SchemaResponse schemaResponse;

    public ControlProcessor() {
    }

    public ControlProcessor(JsonNode controlSchemaNode, SchemaResponse schemaResponse) {
        this.controlSchemaNode = controlSchemaNode;
        this.schemaResponse = schemaResponse;
    }

    @Override
    public void process(CombinedSchemaModel model) {
        Map<String, SchemaControl> controls = this.parseControlSchema(this.controlSchemaNode);
        SchemaControl control = controls.get(this.schemaResponse.getFieldName());
        if (control != null) {
            model.setControl(control);
        }
    }

    public Map<String, SchemaControl> parseControlSchema(JsonNode controlSchemaNode) {
        HashMap<String, SchemaControl> controls = new HashMap<String, SchemaControl>();
        JsonNode propertiesNode = controlSchemaNode.path("properties");
        Iterator fields = propertiesNode.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String fieldName = (String)field.getKey();
            JsonNode fieldNode = (JsonNode)field.getValue();
            SchemaControl control = new SchemaControl();
            ControlProcessor.processNode(fieldNode, control);
            controls.put(fieldName, control);
        }
        return controls;
    }

    private static void processNode(JsonNode node, SchemaControl control) {
        JsonNode descriptionNode;
        JsonNode patternNode;
        JsonNode enumNode;
        JsonNode formatNode;
        String type;
        JsonNode typeNode = node.path("type");
        if (typeNode.isTextual() && "ARRAY".equals(type = typeNode.asText().toUpperCase())) {
            JsonNode itemsNode = node.path("items");
            ControlProcessor.processNode(itemsNode, control);
        }
        if ((formatNode = node.path("format")).isTextual()) {
            String format = formatNode.asText();
            control.setType(format.toUpperCase().replace("-", ""));
        }
        if ((enumNode = node.path("enum")).isArray()) {
            for (JsonNode enumValue : enumNode) {
                control.addValue(enumValue.asText());
            }
            control.setType("SELECT");
        }
        if ((patternNode = node.path("pattern")).isTextual()) {
            control.setType("REGEX");
            control.setValue(patternNode.asText());
        }
        if ((descriptionNode = node.path("description")).isTextual()) {
            control.setComment(descriptionNode.asText());
        }
    }
}

