/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.agencies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.ReferentialFileUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;

class LogbookAgenciesImportManager {
    public static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookAgenciesImportManager.class);
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private ObjectNode evDetData = JsonHandler.createObjectNode();

    public LogbookAgenciesImportManager(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public void logStarted(GUID eip, String eventType) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)eventType, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.STARTED), (GUID)eip);
        this.createLogbookEntry(logbookParameters);
    }

    public void logFinishSuccess(GUID eip, String fileName, StatusCode statusCode) throws VitamException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)"IMPORT_AGENCIES", (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)statusCode, (String)VitamLogbookMessages.getCodeOp((String)"IMPORT_AGENCIES", (StatusCode)statusCode), (GUID)eip);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)this.evDetData));
        ReferentialFileUtils.addFilenameInLogbookOperation((String)fileName, (LogbookOperationParameters)logbookParameters);
        this.updateLogbookEntry(logbookParameters);
    }

    public void logEventFatal(GUID eip, String eventType) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter()), (String)eventType, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.FATAL), (GUID)eip);
        this.updateLogbookEntry(logbookParameters);
    }

    public void logEventSuccess(GUID eip, String eventType) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter()), (String)eventType, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.OK), (GUID)eip);
        this.updateLogbookEntry(logbookParameters);
    }

    public void logEventWarning(GUID eip, String eventType) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter()), (String)eventType, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.WARNING, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.WARNING), (GUID)eip);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)this.evDetData));
        this.updateLogbookEntry(logbookParameters);
    }

    public void logError(GUID eip, String errorsDetails, String subEvenType) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)"IMPORT_AGENCIES", (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)"IMPORT_AGENCIES", (StatusCode)StatusCode.KO), (GUID)eip);
        if (subEvenType != null) {
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)"IMPORT_AGENCIES", (String)subEvenType, (StatusCode)StatusCode.KO));
            logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)"IMPORT_AGENCIES", (String)subEvenType, (StatusCode)StatusCode.KO));
        }
        this.logbookMessageError(errorsDetails, logbookParameters);
        this.updateLogbookEntry(logbookParameters);
    }

    private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put("agencyCheck", errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException invalidParseOperationException) {
                // empty catch block
            }
        }
    }

    public void setEvDetData(ObjectNode evDetData) {
        this.evDetData = evDetData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isImportOperationInProgress(GUID eip) throws VitamException {
        try (LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();){
            Select select = new Select();
            select.setLimitFilter(0L, 1L);
            select.addOrderByDescFilter(new String[]{LogbookMongoDbName.eventDateTime.getDbname()});
            select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)"IMPORT_AGENCIES")}).add(new Query[]{QueryHelper.ne((String)LogbookMongoDbName.eventIdentifier.getDbname(), (String)eip.getId())}));
            JsonNode logbookResult = logbookClient.selectOperation((JsonNode)select.getFinalSelect());
            RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)logbookResult);
            if (requestResponseOK.getHits().getSize() != 0L) {
                JsonNode result = (JsonNode)requestResponseOK.getResults().get(0);
                if (result.get("events") != null && result.get("events").size() > 0) {
                    JsonNode lastEvent = result.get("events").get(result.get("events").size() - 1);
                    boolean bl = !"IMPORT_AGENCIES".equals(lastEvent.get(LogbookMongoDbName.eventType.getDbname()).asText());
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
            throw new VitamException(e);
        }
    }

    private void createLogbookEntry(LogbookOperationParameters logbookParametersStart) throws LogbookClientException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            client.create(new LogbookOperationParameters[]{logbookParametersStart});
        }
    }

    private void updateLogbookEntry(LogbookOperationParameters logbookParametersEnd) throws LogbookClientException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            client.update(new LogbookOperationParameters[]{logbookParametersEnd});
        }
    }
}

