/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.accession.register;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.PushAction;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterStatus;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSymbolicModel;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.common.model.administration.RegisterValueEventModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.retryable.RetryableOnResult;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterDetail;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterSummary;
import fr.gouv.vitam.functional.administration.common.ReferentialAccessionRegisterSummaryUtil;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.FunctionalBackupServiceException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.AccessionRegisterSymbolic;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ReferentialAccessionRegisterImpl
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReferentialAccessionRegisterImpl.class);
    private final MongoDbAccessAdminImpl mongoAccess;
    private final FunctionalBackupService functionalBackupService;
    private final ReferentialAccessionRegisterSummaryUtil referentialAccessionRegisterSummaryUtil;
    private final AlertService alertService = new AlertServiceImpl(LOGGER);
    private final MetaDataClientFactory metaDataClientFactory;
    private final int accessionRegisterSymbolicThreadPoolSize;

    public ReferentialAccessionRegisterImpl(MongoDbAccessAdminImpl dbConfiguration, VitamCounterService vitamCounterService, MetaDataClientFactory metaDataClientFactory, AdminManagementConfiguration configuration) {
        this(dbConfiguration, new FunctionalBackupService(vitamCounterService), metaDataClientFactory, configuration.getAccessionRegisterSymbolicThreadPoolSize());
    }

    public ReferentialAccessionRegisterImpl(MongoDbAccessAdminImpl dbConfiguration, FunctionalBackupService functionalBackupService, MetaDataClientFactory metaDataClientFactory, int accessionRegisterSymbolicThreadPoolSize) {
        this.mongoAccess = dbConfiguration;
        this.functionalBackupService = functionalBackupService;
        this.metaDataClientFactory = metaDataClientFactory;
        this.accessionRegisterSymbolicThreadPoolSize = accessionRegisterSymbolicThreadPoolSize;
        this.referentialAccessionRegisterSummaryUtil = new ReferentialAccessionRegisterSummaryUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAccessionRegisterSymbolic(List<Integer> tenants) throws ReferentialException {
        int threadPoolSize = Math.min(this.accessionRegisterSymbolicThreadPoolSize, tenants.size());
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)threadPoolSize);
        try {
            ArrayList<CompletableFuture> completableFutures = new ArrayList<CompletableFuture>();
            for (Integer tenantId : tenants) {
                CompletableFuture completableFuture = CompletableFuture.runAsync(() -> {
                    Thread.currentThread().setName("AccessionRegisterSymbolic-" + tenantId);
                    VitamThreadUtils.getVitamSession().setTenantId(tenantId);
                    try {
                        this.createAccessionRegisterSymbolic();
                    }
                    catch (Exception e) {
                        this.alertService.createAlert(VitamLogLevel.ERROR, "An error occurred during AccessionRegisterSymbolic update for tenant " + tenantId);
                        throw new RuntimeException("An error occurred during AccessionRegisterSymbolic update for tenant " + tenantId, e);
                    }
                }, executorService);
                completableFutures.add(completableFuture);
            }
            boolean allTenantsSucceeded = true;
            for (CompletableFuture completableFuture : completableFutures) {
                try {
                    completableFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ReferentialException("AccessionRegisterSymbolic update interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOGGER.error("AccessionRegisterSymbolic update failed", (Throwable)e);
                    allTenantsSucceeded = false;
                }
            }
            if (!allTenantsSucceeded) {
                throw new ReferentialException("One or more AccessionRegisterSymbolic updates failed");
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private void createAccessionRegisterSymbolic() throws MetaDataExecutionException, MetaDataClientServerException, ReferentialException, DocumentAlreadyExistsException, InvalidParseOperationException, SchemaValidationException {
        try (MetaDataClient metadataClient = this.metaDataClientFactory.getClient();){
            ArrayNode accessionRegisterSymbolic = (ArrayNode)metadataClient.createAccessionRegisterSymbolic().get("$results");
            List<AccessionRegisterSymbolic> accessionRegisterSymbolicsToInsert = StreamSupport.stream(accessionRegisterSymbolic.spliterator(), false).map(AccessionRegisterSymbolic::new).collect(Collectors.toList());
            if (accessionRegisterSymbolicsToInsert.isEmpty()) {
                return;
            }
            this.insertAccessionRegisterSymbolic(accessionRegisterSymbolicsToInsert);
        }
    }

    private void insertAccessionRegisterSymbolic(List<AccessionRegisterSymbolic> accessionRegisterSymbolics) throws ReferentialException, SchemaValidationException, InvalidParseOperationException, DocumentAlreadyExistsException {
        ArrayList<JsonNode> jsonNodes = new ArrayList<JsonNode>();
        for (AccessionRegisterSymbolic accessionRegisterSymbolic : accessionRegisterSymbolics) {
            jsonNodes.add(JsonHandler.toJsonNode((Object)accessionRegisterSymbolic));
        }
        this.mongoAccess.insertDocuments(JsonHandler.createArrayNode().addAll(jsonNodes), FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC);
        try {
            for (AccessionRegisterSymbolic accessionRegisterSymbolic : accessionRegisterSymbolics) {
                this.functionalBackupService.saveDocument(FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC, (Document)this.mongoAccess.getDocumentById(accessionRegisterSymbolic.getId(), FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC));
            }
        }
        catch (FunctionalBackupServiceException e) {
            throw new ReferentialException("Store backup register symbolic Error", (Throwable)e);
        }
    }

    public RequestResponseOK<AccessionRegisterSymbolicModel> findAccessionRegisterSymbolic(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, AccessionRegisterSymbolic.class, AccessionRegisterSymbolicModel.class);
            return requestResponseOK;
        }
    }

    public void createOrUpdateAccessionRegister(AccessionRegisterDetailModel registerDetail) throws BadRequestException, ReferentialException {
        LOGGER.debug("register ID / Originating Agency: {} / {}", (Object)registerDetail.getId(), (Object)registerDetail.getOriginatingAgency());
        try {
            try {
                if (!registerDetail.getOpc().equals(registerDetail.getOpi())) {
                    this.addEventToAccessionRegisterDetail(registerDetail);
                } else {
                    JsonNode doc = VitamFieldsHelper.removeHash((JsonNode)JsonHandler.toJsonNode((Object)registerDetail));
                    this.mongoAccess.insertDocument(doc, FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL).close();
                }
                this.updateAccessionRegisterSummary(registerDetail);
            }
            catch (DocumentAlreadyExistsException e) {
                LOGGER.warn((Throwable)e);
                this.alertService.createAlert(VitamLogLevel.WARN, "AccessionRegisterSummary maybe not up to date for the originating agency (" + registerDetail.getOriginatingAgency() + ") ");
            }
            this.storeAccessionRegisterDetail(registerDetail);
        }
        catch (InvalidParseOperationException | SchemaValidationException e) {
            throw new BadRequestException("Create register detail error", e);
        }
    }

    private void storeAccessionRegisterDetail(AccessionRegisterDetailModel registerDetail) throws ReferentialException {
        try {
            VitamDocument<AccessionRegisterDetail> docToStorage = this.findAccessionRegisterDetail(registerDetail.getOriginatingAgency(), registerDetail.getOpi());
            this.functionalBackupService.saveDocument(FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL, (Document)docToStorage);
        }
        catch (FunctionalBackupServiceException e) {
            throw new ReferentialException("Store backup register detail Error", (Throwable)e);
        }
    }

    void addEventToAccessionRegisterDetail(AccessionRegisterDetailModel newRegisterDetail) throws ReferentialException, DocumentAlreadyExistsException {
        ParametersChecker.checkParameter((String)"Register detail mustn't be null", (Object[])new Object[]{newRegisterDetail});
        ParametersChecker.checkParameter((String)"Register opi mustn't be null", (String[])new String[]{newRegisterDetail.getOpi()});
        ParametersChecker.checkParameter((String)"Register opc mustn't be null", (String[])new String[]{newRegisterDetail.getOpc()});
        ParametersChecker.checkParameter((String)"Register tenant mustn't be null", (Object[])new Object[]{newRegisterDetail.getTenant()});
        ParametersChecker.checkParameter((String)"Register originatingAgency mustn't be null", (String[])new String[]{newRegisterDetail.getOriginatingAgency()});
        RetryableOnResult retryable = new RetryableOnResult(new RetryableParameters(VitamConfiguration.getOptimisticLockRetryNumber(), VitamConfiguration.getOptimisticLockSleepTime(), VitamConfiguration.getOptimisticLockSleepTime(), VitamConfiguration.getOptimisticLockSleepTime(), TimeUnit.MILLISECONDS, VitamLogLevel.WARN), success -> success == false);
        try {
            retryable.exec(() -> {
                try {
                    return this.tryAddEventToAccessionRegisterDetailWithOptimisticLock(newRegisterDetail);
                }
                catch (InvalidCreateOperationException | DocumentAlreadyExistsException | InvalidParseOperationException | ReferentialException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ReferentialException) {
                throw (ReferentialException)e.getCause();
            }
            if (e.getCause() instanceof DocumentAlreadyExistsException) {
                throw (DocumentAlreadyExistsException)e.getCause();
            }
            throw e;
        }
    }

    private boolean tryAddEventToAccessionRegisterDetailWithOptimisticLock(AccessionRegisterDetailModel newRegisterDetail) throws ReferentialException, InvalidParseOperationException, ConcurrentModificationException, InvalidCreateOperationException, DocumentAlreadyExistsException {
        LOGGER.debug("Update register ID / Originating Agency: {} / {}", (Object)newRegisterDetail.getId(), (Object)newRegisterDetail.getOriginatingAgency());
        Select select = (Select)new Select().setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"OriginatingAgency", (String)newRegisterDetail.getOriginatingAgency()), QueryHelper.eq((String)"Opi", (String)newRegisterDetail.getOpi())}));
        List documents = this.mongoAccess.findDocuments((JsonNode)select.getFinalSelect(), FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL).getDocuments(AccessionRegisterDetail.class, AccessionRegisterDetailModel.class);
        if (CollectionUtils.isEmpty((Collection)documents)) {
            throw new ReferentialException("Document not found");
        }
        AccessionRegisterDetailModel accessionRegisterDetailStored = (AccessionRegisterDetailModel)documents.get(0);
        if (accessionRegisterDetailStored.getEvents().stream().anyMatch(e -> Objects.equals(e.getOperation(), newRegisterDetail.getOpc()))) {
            throw new DocumentAlreadyExistsException(String.format("Accession register detail for originating agency (%s) and opi (%s) found and already contains the detail (%s)", newRegisterDetail.getOriginatingAgency(), newRegisterDetail.getOpi(), newRegisterDetail.getOpc()));
        }
        try {
            this.mergeNewRegisterDetailIntoOld(accessionRegisterDetailStored, newRegisterDetail);
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(new SetAction("LastUpdate", LocalDateUtil.nowFormatted()));
            actions.add(new SetAction("Opc", accessionRegisterDetailStored.getOpc()));
            actions.add(new PushAction("Events", JsonHandler.toJsonNode((Object)this.convertRegisterDetailToRegisterEvent(newRegisterDetail))));
            actions.add(new SetAction("TotalObjectGroups.ingested", accessionRegisterDetailStored.getTotalObjectsGroups().getIngested()));
            actions.add(new SetAction("TotalObjectGroups.deleted", accessionRegisterDetailStored.getTotalObjectsGroups().getDeleted()));
            actions.add(new SetAction("TotalObjectGroups.remained", accessionRegisterDetailStored.getTotalObjectsGroups().getRemained()));
            actions.add(new SetAction("TotalObjects.ingested", accessionRegisterDetailStored.getTotalObjects().getIngested()));
            actions.add(new SetAction("TotalObjects.deleted", accessionRegisterDetailStored.getTotalObjects().getDeleted()));
            actions.add(new SetAction("TotalObjects.remained", accessionRegisterDetailStored.getTotalObjects().getRemained()));
            actions.add(new SetAction("TotalUnits.ingested", accessionRegisterDetailStored.getTotalUnits().getIngested()));
            actions.add(new SetAction("TotalUnits.deleted", accessionRegisterDetailStored.getTotalUnits().getDeleted()));
            actions.add(new SetAction("TotalUnits.remained", accessionRegisterDetailStored.getTotalUnits().getRemained()));
            actions.add(new SetAction("ObjectSize.ingested", accessionRegisterDetailStored.getObjectSize().getIngested()));
            actions.add(new SetAction("ObjectSize.deleted", accessionRegisterDetailStored.getObjectSize().getDeleted()));
            actions.add(new SetAction("ObjectSize.remained", accessionRegisterDetailStored.getObjectSize().getRemained()));
            if (this.statusShouldBeUnstored(accessionRegisterDetailStored)) {
                actions.add(new SetAction("Status", AccessionRegisterStatus.UNSTORED.name()));
            } else {
                actions.add(new SetAction("Status", accessionRegisterDetailStored.getStatus().name()));
            }
            Update update = (Update)new Update().setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"#id", (String)accessionRegisterDetailStored.getId()), QueryHelper.eq((String)"#version", (long)accessionRegisterDetailStored.getVersion().intValue())}));
            update.addActions((Action[])actions.toArray(Action[]::new));
            DbRequestResult dbRequestResult = this.mongoAccess.updateData((JsonNode)update.getFinalUpdate(), FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL);
            return dbRequestResult.getCount() > 0L;
        }
        catch (Exception ex) {
            throw new ReferentialException("Create register detail error", (Throwable)ex);
        }
    }

    private boolean statusShouldBeUnstored(AccessionRegisterDetailModel accessionRegisterDetail) {
        return accessionRegisterDetail.getStatus() != AccessionRegisterStatus.UNSTORED && accessionRegisterDetail.getTotalObjectsGroups().getRemained() == 0L && accessionRegisterDetail.getTotalUnits().getRemained() == 0L && accessionRegisterDetail.getTotalObjects().getRemained() == 0L && accessionRegisterDetail.getObjectSize().getRemained() == 0L;
    }

    private void mergeNewRegisterDetailIntoOld(AccessionRegisterDetailModel oldOne, AccessionRegisterDetailModel newOne) {
        oldOne.setOpc(newOne.getOpc());
        oldOne.setStatus(newOne.getStatus());
        oldOne.setTotalObjectsGroups(this.mergeNewValueDetailIntoOld(oldOne.getTotalObjectsGroups(), newOne.getTotalObjectsGroups()));
        oldOne.setTotalObjects(this.mergeNewValueDetailIntoOld(oldOne.getTotalObjects(), newOne.getTotalObjects()));
        oldOne.setTotalUnits(this.mergeNewValueDetailIntoOld(oldOne.getTotalUnits(), newOne.getTotalUnits()));
        oldOne.setObjectSize(this.mergeNewValueDetailIntoOld(oldOne.getObjectSize(), newOne.getObjectSize()));
    }

    private RegisterValueDetailModel mergeNewValueDetailIntoOld(RegisterValueDetailModel oldOne, RegisterValueDetailModel newOne) {
        oldOne.setIngested(oldOne.getIngested() + newOne.getIngested());
        oldOne.setRemained(oldOne.getRemained() + newOne.getRemained());
        oldOne.setDeleted(oldOne.getDeleted() + newOne.getDeleted());
        return oldOne;
    }

    private RegisterValueEventModel convertRegisterDetailToRegisterEvent(AccessionRegisterDetailModel registerDetail) {
        return new RegisterValueEventModel().setOperation(registerDetail.getOpc()).setOperationType(registerDetail.getOperationType()).setTotalGots(registerDetail.getTotalObjectsGroups().getRemained()).setTotalObjects(registerDetail.getTotalObjects().getRemained()).setTotalUnits(registerDetail.getTotalUnits().getRemained()).setObjectSize(registerDetail.getObjectSize().getRemained()).setCreationdate(LocalDateUtil.nowFormatted());
    }

    public void close() {
    }

    public RequestResponseOK<AccessionRegisterSummary> findDocuments(JsonNode select) throws ReferentialException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(select, FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(select, AccessionRegisterSummary.class);
            return requestResponseOK;
        }
    }

    public RequestResponseOK<AccessionRegisterDetail> findDetail(JsonNode select) throws ReferentialException {
        try (DbRequestResult result = this.mongoAccess.findDocuments(select, FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(select, AccessionRegisterDetail.class);
            return requestResponseOK;
        }
    }

    private VitamDocument<AccessionRegisterDetail> findAccessionRegisterDetail(String originatingAgency, String opi) {
        Bson filterQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"OriginatingAgency", (Object)originatingAgency), Filters.eq((String)"Opi", (Object)opi)});
        return (VitamDocument)FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getCollection().find(filterQuery).iterator().next();
    }

    private void updateAccessionRegisterSummary(AccessionRegisterDetailModel registerDetail) throws ReferentialException, BadRequestException {
        try {
            AccessionRegisterSummary accessionRegister = this.referentialAccessionRegisterSummaryUtil.initAccessionRegisterSummary(registerDetail.getOriginatingAgency(), GUIDFactory.newAccessionRegisterSummaryGUID((int)ParameterHelper.getTenantParameter()).getId());
            LOGGER.debug("register ID / Originating Agency: {} / {}", (Object)registerDetail.getId(), (Object)registerDetail.getOriginatingAgency());
            this.mongoAccess.insertDocument(JsonHandler.toJsonNode((Object)accessionRegister), FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY);
        }
        catch (DocumentAlreadyExistsException accessionRegister) {
        }
        catch (InvalidParseOperationException | SchemaValidationException e) {
            throw new BadRequestException(e);
        }
        try {
            Update update = this.referentialAccessionRegisterSummaryUtil.generateUpdateQuery(registerDetail);
            this.mongoAccess.updateData((JsonNode)update.getFinalUpdate(), FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY);
        }
        catch (Exception e) {
            throw new ReferentialException("Unknown error", (Throwable)e);
        }
    }

    public void migrateAccessionRegister(AccessionRegisterDetailModel accessionRegister, List<String> fieldsToUpdate) throws ReferentialException, BadRequestException {
        try {
            ArrayList<SetAction> actions = new ArrayList<SetAction>();
            if (CollectionUtils.isNotEmpty((Collection)accessionRegister.getComment()) && fieldsToUpdate.contains("Comment")) {
                actions.add(new SetAction("Comment", accessionRegister.getComment()));
            }
            if (fieldsToUpdate.contains("obIdIn")) {
                actions.add(new SetAction("obIdIn", accessionRegister.getObIdIn()));
            }
            Update update = new Update();
            update.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"OriginatingAgency", (String)accessionRegister.getOriginatingAgency()), QueryHelper.eq((String)"Opi", (String)accessionRegister.getOpi())}));
            update.addActions((Action[])actions.toArray(Action[]::new));
            this.mongoAccess.updateData((JsonNode)update.getFinalUpdate(), FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL);
            this.storeAccessionRegisterDetail(accessionRegister);
        }
        catch (InvalidCreateOperationException | SchemaValidationException e) {
            throw new BadRequestException("Error when migrating register detail !", e);
        }
        catch (Exception e) {
            throw new ReferentialException("Error when migrating register detail !", (Throwable)e);
        }
    }
}

