/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalNotFoundException;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.service.BulkAtomicUpdateMetadataService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.collect.internal.core.service.ProjectService;
import fr.gouv.vitam.collect.internal.core.service.SipService;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.utils.BulkAtomicUpdateModelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;

@Path(value="/collect-internal/v1/transactions")
public class TransactionInternalResource {
    public static final String SIP_GENERATED_MANIFEST_CAN_T_BE_NULL = "SIP generated manifest can't be null";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransactionInternalResource.class);
    private static final String TRANSACTION_NOT_FOUND = "Unable to find transaction Id";
    private static final String TRANSACTION_NOT_FOUND_OR_INVALID_STATUS = "Unable to find transaction Id or invalid status";
    private static final String STATUS_NOT_ALLOWED = "Invalid status";
    private static final String PROJECT_NOT_FOUND = "Unable to find project Id or invalid status";
    private static final String EMPTY_QUERY_IS_IMPOSSIBLE = "Empty query is impossible";
    private static final String INVALID_QUERY_DSL_EXCEPTION = "Invalid query DSL ";
    private static final String EXECUTION_OF_DSL_VITAM_FROM_COLLECT_ONGOING = "Execution of DSL Vitam from Collect ongoing...";
    private static final String DEBUG = "DEBUG {}";
    private final TransactionService transactionService;
    private final MetadataService metadataService;
    private final SipService sipService;
    private final ProjectService projectService;
    private final BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService;

    public TransactionInternalResource(TransactionService transactionService, SipService sipService, MetadataService metadataService, ProjectService projectService, BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService) {
        this.transactionService = transactionService;
        this.sipService = sipService;
        this.metadataService = metadataService;
        this.projectService = projectService;
        this.bulkAtomicUpdateMetadataService = bulkAtomicUpdateMetadataService;
    }

    @GET
    @Path(value="/withAutomaticIngest")
    @Produces(value={"application/json"})
    public Response getTransactionsToAutomaticallyIngest() throws CollectInternalException {
        return CollectRequestResponse.toResponseOK(this.transactionService.findReadyAutoIngestTransactions().stream().map(CollectHelper::convertTransactionModelToTransactionDto).collect(Collectors.toList()));
    }

    @Path(value="/{transactionId}")
    @GET
    @Produces(value={"application/json"})
    public Response getTransactionById(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            Optional transactionModel = this.transactionService.findTransaction(transactionId);
            if (transactionModel.isEmpty()) {
                LOGGER.error(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
            }
            TransactionDto transactionDto = CollectHelper.convertTransactionModelToTransactionDto((TransactionModel)((TransactionModel)transactionModel.get()));
            return CollectRequestResponse.toResponseOK((Object)transactionDto);
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when get transaction by Id :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when get transaction by Id :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTransaction(TransactionDto transactionDto) {
        try {
            ParametersChecker.checkParameter((String)"You must supply transaction data!", (Object[])new Object[]{transactionDto});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)transactionDto));
            TransactionModel transactionModel = this.transactionService.replaceTransaction(transactionDto);
            TransactionDto result = CollectHelper.convertTransactionModelToTransactionDto((TransactionModel)transactionModel);
            return CollectRequestResponse.toResponseOK((Object)result);
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
        }
        catch (CollectInternalException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when trying to parse :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteTransactionById(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            Optional transactionModel = this.transactionService.findTransaction(transactionId);
            if (transactionModel.isEmpty()) {
                LOGGER.error(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
            }
            this.transactionService.deleteTransaction(((TransactionModel)transactionModel.get()).getId());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when delete transaction by Id :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when delete transaction by Id :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response uploadArchiveUnit(@PathParam(value="transactionId") String transactionId, JsonNode unitJsonNode) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            SanityChecker.checkJsonAll((JsonNode)unitJsonNode);
            Optional transactionModel = this.transactionService.findTransaction(transactionId);
            if (transactionModel.isEmpty() || !this.transactionService.checkStatus((TransactionModel)transactionModel.get(), new TransactionStatus[]{TransactionStatus.OPEN})) {
                LOGGER.error(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
            }
            JsonNode savedUnitJsonNode = this.metadataService.saveArchiveUnit(unitJsonNode, (TransactionModel)transactionModel.get());
            return CollectRequestResponse.toResponseOK((Object)savedUnitJsonNode);
        }
        catch (CollectInternalException | InvalidParseOperationException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnits(@PathParam(value="transactionId") String transactionId, JsonNode jsonQuery) {
        try {
            RequestResponseOK units = this.metadataService.selectUnitsByTransactionId(jsonQuery, transactionId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)units).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when getting units in metadata :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/close")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response closeTransaction(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.changeTransactionStatus(TransactionStatus.READY, transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to close transaction :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to close transaction :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/abort")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response abortTransaction(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.changeTransactionStatus(TransactionStatus.ABORTED, transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to abort transaction :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to abort transaction :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/reopen")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reopenTransaction(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.changeTransactionStatus(TransactionStatus.OPEN, transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to reopen transaction :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to reopen transaction :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/send")
    @POST
    @Produces(value={"application/octet-stream"})
    public Response generateSip(@PathParam(value="transactionId") String transactionId) throws CollectInternalException {
        InputStream sipInputStream = null;
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            Optional transactionModel = this.transactionService.findTransaction(transactionId);
            if (transactionModel.isEmpty()) {
                LOGGER.error(TRANSACTION_NOT_FOUND);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            TransactionModel transaction = (TransactionModel)transactionModel.get();
            boolean updatedDocument = this.transactionService.changeTransactionToSendingIfBatchesNotKo(transaction);
            if (!updatedDocument) {
                LOGGER.error(STATUS_NOT_ALLOWED);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.transactionService.isTransactionContentEmpty(transactionId);
            String digest = this.sipService.generateSip(transaction);
            if (digest == null) {
                LOGGER.error(SIP_GENERATED_MANIFEST_CAN_T_BE_NULL);
                this.transactionService.changeTransactionStatus(TransactionStatus.KO, transactionId);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)SIP_GENERATED_MANIFEST_CAN_T_BE_NULL);
            }
            sipInputStream = this.sipService.getIngestedFileFromWorkspace(transaction);
            if (sipInputStream == null) {
                throw new CollectInternalException("Can't fetch SIP file from Collect workspace!");
            }
            return Response.ok((Object)sipInputStream).build();
        }
        catch (CollectInternalException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to generate SIP :", e);
            this.transactionService.changeTransactionStatus(TransactionStatus.KO, transactionId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            if (sipInputStream != null) {
                StreamUtils.closeSilently(sipInputStream);
            }
            LOGGER.error("Error when ingesting  transaction   ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{transactionId}/units/metadata/csv")
    @PUT
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response updateUnitsWithMetadataCsv(@PathParam(value="transactionId") String transactionId, InputStream metadataCsvInputStream) {
        try {
            ParametersChecker.checkParameter((String)"DOCUMENT_IS_MANDATORY", (Object[])new Object[]{metadataCsvInputStream});
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getOpenTransaction(transactionId);
            String requestId = VitamThreadUtils.getVitamSession().getRequestId();
            File file = PropertiesUtils.fileFromTmpFolder((String)String.format("metadata_%s.csv", requestId));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                StreamUtils.copy((InputStream)metadataCsvInputStream, (OutputStream)fileOutputStream);
                if (file.length() == 0L) {
                    throw new IllegalArgumentException("Empty file");
                }
                SanityChecker.checkHTMLFile((File)file);
                try (FileInputStream sanityStream = new FileInputStream(file);){
                    this.metadataService.updateUnitsWithMetadataCsv(transaction, (InputStream)sanityStream);
                }
            }
            finally {
                FileUtils.deleteQuietly((File)file);
            }
            return Response.ok((Object)new RequestResponseOK()).build();
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to update metadata :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException | IOException e) {
            LOGGER.error("An error occurs when try to update metadata :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units/metadata/jsonl")
    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response updateUnitsWithMetadataJsonl(@PathParam(value="transactionId") String transactionId, InputStream metadataJsonlInputStream) {
        try {
            ParametersChecker.checkParameter((String)"DOCUMENT_IS_MANDATORY", (Object[])new Object[]{metadataJsonlInputStream});
            TransactionModel transaction = this.getOpenTransaction(transactionId);
            this.metadataService.updateUnitsWithJsonlMetadata(transaction, metadataJsonlInputStream);
            return Response.ok((Object)new RequestResponseOK()).build();
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to update metadata :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException | RuntimeException e) {
            LOGGER.error("An error occurs when try to update metadata :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/upload")
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response uploadTransactionZip(@PathParam(value="transactionId") String transactionId, InputStream inputStreamObject, @HeaderParam(value="X-Encoding") @Nullable String encoding) {
        try {
            ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{inputStreamObject});
            Optional transactionModel = this.transactionService.findTransaction(transactionId);
            if (transactionModel.isEmpty() || !this.transactionService.checkStatus((TransactionModel)transactionModel.get(), new TransactionStatus[]{TransactionStatus.OPEN})) {
                LOGGER.error(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
            }
            return this.transactionService.uploadTransactionZip(inputStreamObject, (TransactionModel)transactionModel.get(), encoding);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to upload the ZIP:", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to upload the ZIP:", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/status/{transactionStatus}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeTransactionStatus(@PathParam(value="transactionId") String transactionId, @PathParam(value="transactionStatus") TransactionStatus transactionStatus) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.changeTransactionStatus(transactionStatus, transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to update transaction :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to update transaction :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/operation-id/{operationId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attachVitamOperationId(@PathParam(value="transactionId") String transactionId, @PathParam(value="operationId") String operationId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            SanityChecker.checkParameter((String[])new String[]{operationId});
            this.transactionService.attachVitamOperationId(transactionId, operationId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.error("An error occurs when try to update transaction :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to update transaction :", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    private void checkEmptyQuery(JsonNode queryDsl) throws InvalidParseOperationException, BadRequestException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl.deepCopy());
        if (parser.getRequest().getNbQueries() == 0 && parser.getRequest().getRoots().isEmpty()) {
            throw new BadRequestException("Query cant be empty");
        }
    }

    @GET
    @Path(value="/{transactionId}/unitsWithInheritedRules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnitsWithInheritedRules(@PathParam(value="transactionId") String transactionId, JsonNode queryDsl) {
        JsonNode result;
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_COLLECT_ONGOING);
        LOGGER.debug("DEBUG: start selectUnitsWithInheritedRules {}", (Object)queryDsl);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            result = this.metadataService.selectUnitsWithInheritedRules(transactionId, queryDsl);
            LOGGER.debug(DEBUG, (Object)result);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(INVALID_QUERY_DSL_EXCEPTION, (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)EMPTY_QUERY_IS_IMPOSSIBLE);
        }
        catch (BadRequestException e) {
            LOGGER.error(EMPTY_QUERY_IS_IMPOSSIBLE, (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)VitamCode.GLOBAL_EMPTY_QUERY.getStatus(), (String)EMPTY_QUERY_IS_IMPOSSIBLE);
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/{transactionId}/units/bulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response bulkAtomicUpdateUnits(@PathParam(value="transactionId") String transactionId, JsonNode updateQueriesJson) {
        try {
            Optional transactionModel = this.transactionService.findTransaction(transactionId);
            if (transactionModel.isEmpty()) {
                LOGGER.error(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
                return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
            }
            this.bulkAtomicUpdateMetadataService.checkThreshold(updateQueriesJson);
            ArrayNode queries = BulkAtomicUpdateModelUtils.getQueries((JsonNode)updateQueriesJson);
            List bulkAtomicUpdateResults = this.bulkAtomicUpdateMetadataService.bulkAtomicUpdateUnits(((TransactionModel)transactionModel.get()).getId(), queries, false);
            return new RequestResponseOK().addAllResults(bulkAtomicUpdateResults).setHttpCode(Response.Status.ACCEPTED.getStatusCode()).toResponse();
        }
        catch (CollectInternalInvalidRequestException | IllegalArgumentException e) {
            LOGGER.error("Bulk atomic update failed - Bad request. Transaction by Id: '" + transactionId + "'", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException | RuntimeException e) {
            LOGGER.error("Bulk atomic update failed - Internal server error. Transaction by Id: '" + transactionId + "'", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    private TransactionModel getOpenTransaction(String transactionId) throws InvalidParseOperationException, CollectInternalException {
        SanityChecker.checkParameter((String[])new String[]{transactionId});
        Optional transactionModel = this.transactionService.findTransaction(transactionId);
        if (transactionModel.isEmpty() || !this.transactionService.checkStatus((TransactionModel)transactionModel.get(), new TransactionStatus[]{TransactionStatus.OPEN})) {
            throw new CollectInternalInvalidRequestException(TRANSACTION_NOT_FOUND_OR_INVALID_STATUS);
        }
        TransactionModel transaction = (TransactionModel)transactionModel.get();
        Optional projectDto = this.projectService.findProject(transaction.getProjectId());
        if (projectDto.isEmpty()) {
            throw new CollectInternalInvalidRequestException(PROJECT_NOT_FOUND);
        }
        return transaction;
    }
}

