/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.appserver;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.ihmdemo.appserver.WebApplicationConfig;
import fr.gouv.vitam.ihmdemo.appserver.WebApplicationResource;
import fr.gouv.vitam.ihmdemo.appserver.WebPreservationResource;
import fr.gouv.vitam.ihmdemo.common.utils.PermissionReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresPermissions;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            WebApplicationConfig configuration = (WebApplicationConfig)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, WebApplicationConfig.class));
            this.commonBusinessApplication = new CommonBusinessApplication();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            Set permissions = PermissionReader.getMethodsAnnotatedWith(WebApplicationResource.class, RequiresPermissions.class);
            Set methodsAnnotatedWith = PermissionReader.getMethodsAnnotatedWith(WebPreservationResource.class, RequiresPermissions.class);
            permissions.addAll(methodsAnnotatedWith);
            this.singletons.add((Object)new WebApplicationResource(permissions, configuration));
            this.singletons.add(new WebPreservationResource());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

