/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver;

import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfigurationValidator;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminFactory;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.ihmdemo.core.UserInterfaceTransactionManager;
import fr.gouv.vitam.ihmrecette.appserver.WebApplicationConfig;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfigurationValidator;
import fr.gouv.vitam.logbook.common.server.config.LogbookIndexationConfiguration;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbAccessFactory;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbAccessImpl;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.metadata.core.MongoDbAccessMetadataFactory;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.config.MetaDataConfigurationValidator;
import fr.gouv.vitam.metadata.core.config.MetadataIndexationConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbAccessMetadataImpl;
import fr.gouv.vitam.metadata.core.mapping.MappingLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/v1/api/delete")
public class WebApplicationResourceDelete {
    private static final String CONTEXT_NAME = "Name";
    private static final String[] CONTEXTS_TO_SAVE = new String[]{"admin-context", "vitamui-context"};
    private static final String SECURITY_PROFILE_NAME = "Name";
    private static final String[] SECURITY_PROFILES_TO_SAVE = new String[]{"admin-security-profile", "vitamui-security-profile"};
    private static final String ONTOLOGY_ORIGIN = "Origin";
    private static final String ONTOLOGY_EXTERNAL = "EXTERNAL";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WebApplicationResourceDelete.class);
    private static final String STP_DELETE_FORMAT = "STP_DELETE_FORMAT";
    private static final String STP_DELETE_RULES = "STP_DELETE_RULES";
    private static final String STP_DELETE_ACCESSION_REGISTER_DETAIL = "STP_DELETE_ACCESSION_REGISTER_DETAIL";
    private static final String STP_DELETE_ACCESSION_REGISTER_SUMMARY = "STP_DELETE_ACCESSION_REGISTER_SUMMARY";
    private static final String STP_DELETE_LOGBOOK_OPERATION = "STP_DELETE_LOGBOOK_OPERATION";
    private static final String STP_DELETE_LOGBOOK_LIFECYCLE_OG = "STP_DELETE_LOGBOOK_LIFECYCLE_OG";
    private static final String STP_DELETE_LOGBOOK_LIFECYCLE_UNIT = "STP_DELETE_LOGBOOK_LIFECYCLE_UNIT";
    private static final String STP_DELETE_METADATA_OG = "STP_DELETE_METADATA_OG";
    private static final String STP_DELETE_METADATA_UNIT = "STP_DELETE_METADATA_UNIT";
    private static final String STP_DELETE_MASTERDATA = "STP_DELETE_MASTERDATA";
    private static final String STP_DELETE_MASTERDATA_INGEST_CONTRACT = "STP_DELETE_MASTERDATA_INGEST_CONTRACT";
    private static final String STP_DELETE_MASTERDATA_ACCESS_CONTRACT = "STP_DELETE_MASTERDATA_ACCESS_CONTRACT";
    private static final String STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT = "STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT";
    private static final String STP_DELETE_MASTERDATA_PROFILE = "STP_DELETE_MASTERDATA_PROFILE";
    private static final String STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE = "STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE";
    private static final String STP_DELETE_MASTERDATA_AGENCIES = "STP_DELETE_MASTERDATA_AGENCIES";
    private static final String STP_DELETE_MASTERDATA_CONTEXT = "STP_DELETE_MASTERDATA_CONTEXT";
    private static final String STP_DELETE_ALL = "STP_DELETE_ALL";
    private static final String CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION = "Cannot update delegate logbook operation";
    private final MongoDbAccessAdminImpl mongoDbAccessAdmin;
    private final LogbookMongoDbAccessImpl mongoDbAccessLogbook;
    private final MongoDbAccessMetadataImpl mongoDbAccessMetadata;
    private final UserInterfaceTransactionManager userInterfaceTransactionManager = UserInterfaceTransactionManager.getInstance();

    public WebApplicationResourceDelete(WebApplicationConfig webApplicationConfig, OntologyLoader ontologyLoader, FunctionalAdminIndexationConfiguration functionalAdminFunctionalAdminIndexationConfiguration, MetadataIndexationConfiguration metadataMetadataIndexationConfiguration, LogbookIndexationConfiguration logbookLogbookIndexationConfiguration) {
        MetaDataConfiguration metaDataConfiguration;
        MappingLoader mappingLoader;
        LogbookConfiguration logbookConfiguration;
        AdminManagementConfiguration adminConfiguration;
        if (webApplicationConfig.isDbAuthentication()) {
            adminConfiguration = new AdminManagementConfiguration(webApplicationConfig.getMongoDbNodes(), webApplicationConfig.getMasterdataDbName(), true, webApplicationConfig.getDbUserName(), webApplicationConfig.getDbPassword(), functionalAdminFunctionalAdminIndexationConfiguration);
            logbookConfiguration = new LogbookConfiguration(webApplicationConfig.getMongoDbNodes(), webApplicationConfig.getLogbookDbName(), webApplicationConfig.getClusterName(), webApplicationConfig.getElasticsearchNodes(), true, webApplicationConfig.getDbUserName(), webApplicationConfig.getDbPassword()).setLogbookTenantIndexation(logbookLogbookIndexationConfiguration);
            mappingLoader = new MappingLoader(webApplicationConfig.getElasticsearchExternalMetadataMappings());
            metaDataConfiguration = new MetaDataConfiguration(webApplicationConfig.getMongoDbNodes(), webApplicationConfig.getMetadataDbName(), webApplicationConfig.getClusterName(), webApplicationConfig.getElasticsearchNodes(), true, webApplicationConfig.getDbUserName(), webApplicationConfig.getDbPassword(), mappingLoader).setIndexationConfiguration(metadataMetadataIndexationConfiguration);
        } else {
            adminConfiguration = new AdminManagementConfiguration(webApplicationConfig.getMongoDbNodes(), webApplicationConfig.getMasterdataDbName(), functionalAdminFunctionalAdminIndexationConfiguration);
            logbookConfiguration = new LogbookConfiguration(webApplicationConfig.getMongoDbNodes(), webApplicationConfig.getLogbookDbName(), webApplicationConfig.getClusterName(), webApplicationConfig.getElasticsearchNodes()).setLogbookTenantIndexation(logbookLogbookIndexationConfiguration);
            mappingLoader = new MappingLoader(webApplicationConfig.getElasticsearchExternalMetadataMappings());
            metaDataConfiguration = new MetaDataConfiguration(webApplicationConfig.getMongoDbNodes(), webApplicationConfig.getMetadataDbName(), webApplicationConfig.getClusterName(), webApplicationConfig.getElasticsearchNodes(), mappingLoader).setIndexationConfiguration(metadataMetadataIndexationConfiguration);
        }
        adminConfiguration.setElasticsearchConfigurationFile(webApplicationConfig.getElasticsearchConfigurationFile());
        metaDataConfiguration.setElasticsearchConfigurationFile(webApplicationConfig.getElasticsearchConfigurationFile());
        logbookConfiguration.setElasticsearchConfigurationFile(webApplicationConfig.getElasticsearchConfigurationFile());
        AdminManagementConfigurationValidator.validateConfiguration((AdminManagementConfiguration)adminConfiguration);
        MetaDataConfigurationValidator.validateConfiguration((MetaDataConfiguration)metaDataConfiguration);
        LogbookConfigurationValidator.validateConfiguration((LogbookConfiguration)logbookConfiguration);
        ElasticsearchMetadataIndexManager metadataIndexManager = new ElasticsearchMetadataIndexManager(metaDataConfiguration, VitamConfiguration.getTenants(), mappingLoader);
        ElasticsearchLogbookIndexManager logbookIndexManager = new ElasticsearchLogbookIndexManager(logbookConfiguration, VitamConfiguration.getTenants());
        ElasticsearchFunctionalAdminIndexManager indexManager = new ElasticsearchFunctionalAdminIndexManager(adminConfiguration);
        this.mongoDbAccessAdmin = MongoDbAccessAdminFactory.create((DbConfiguration)adminConfiguration, (String)webApplicationConfig.getClusterName(), webApplicationConfig.getElasticsearchNodes(), (OntologyLoader)ontologyLoader, (ElasticsearchFunctionalAdminIndexManager)indexManager);
        this.mongoDbAccessLogbook = LogbookMongoDbAccessFactory.create((LogbookConfiguration)logbookConfiguration, (OntologyLoader)ontologyLoader, (ElasticsearchLogbookIndexManager)logbookIndexManager);
        this.mongoDbAccessMetadata = MongoDbAccessMetadataFactory.create((MetaDataConfiguration)metaDataConfiguration, (ElasticsearchMetadataIndexManager)metadataIndexManager);
        LOGGER.debug("init Admin Management Resource server");
    }

    public MongoDbAccess getMongoDbAccessAdmin() {
        return this.mongoDbAccessAdmin;
    }

    @Path(value="formats")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteFormat() {
        return this.deleteFormats();
    }

    private Response deleteFormats() {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        if (tenantId == null) {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(0));
            tenantId = 0;
        }
        GUID eip = GUIDFactory.newEventGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_FORMAT, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_FORMAT, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.FORMATS).close();
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_FORMAT).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_FORMAT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_FORMAT, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_FORMAT).setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_FORMAT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_FORMAT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
    }

    @Path(value="rules")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteRulesFile() {
        return this.deleteRules();
    }

    private Response deleteRules() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newEventGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_RULES, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_RULES, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.RULES).close();
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_RULES).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_RULES, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_RULES, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_RULES).setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_RULES, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_RULES, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
    }

    @Path(value="accessionregisters")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteAccessionRegister() {
        return this.deleteRegister();
    }

    private Response deleteRegister() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC).close();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY).close();
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ACCESSION_REGISTER_SUMMARY).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
        }
        catch (Exception exc) {
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ACCESSION_REGISTER_SUMMARY).setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
        GUID eipDetail = GUIDFactory.newGUID();
        parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipDetail, (String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (GUID)eipDetail, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.STARTED), (GUID)eipDetail);
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL).close();
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ACCESSION_REGISTER_DETAIL).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eipDetail.getId(), helper.removeCreateDelegate(eipDetail.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ACCESSION_REGISTER_DETAIL).setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eipDetail, exc);
        }
    }

    @Path(value="logbook/operation")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteLogbookOperation() {
        return this.deleteLogBook();
    }

    private Response deleteLogBook() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_LOGBOOK_OPERATION, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
        }
        catch (LogbookClientAlreadyExistsException exc) {
            LOGGER.error("Cannot create delegate logbook operation", (Throwable)exc);
        }
        try {
            this.mongoDbAccessLogbook.deleteCollectionForTesting(LogbookCollections.OPERATION);
            parameters.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK);
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
                this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            }
            catch (LogbookAlreadyExistsException | LogbookDatabaseException e) {
                LOGGER.error(e);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)exc.getMessage()).build();
        }
    }

    @Path(value="logbook/lifecycle/objectgroup")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteLogbookLifecycleOG() {
        return this.deleteLifecycleOg();
    }

    private Response deleteLifecycleOg() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessLogbook.deleteCollectionForTesting(LogbookCollections.LIFECYCLE_OBJECTGROUP);
            parameters.setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
    }

    @Path(value="logbook/lifecycle/unit")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteLogbookLifecycleUnit() {
        return this.deleteLifecycleUnits();
    }

    private Response deleteLifecycleUnits() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessLogbook.deleteCollectionForTesting(LogbookCollections.LIFECYCLE_UNIT);
            parameters.setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
    }

    @Path(value="metadata/objectgroup")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMetadataObjectGroup() {
        return this.deleteMetadataOg();
    }

    private Response deleteMetadataOg() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_METADATA_OG, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessMetadata.deleteObjectGroupByTenant(new Integer[]{tenantId});
            parameters.setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
    }

    @Path(value="metadata/unit")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMetadataUnit() {
        return this.deleteMetadataUnits();
    }

    private Response deleteMetadataUnits() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_METADATA_UNIT, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            this.mongoDbAccessMetadata.deleteUnitByTenant(new Integer[]{tenantId});
            parameters.setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception exc) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            return this.updateLogbookAndGetErrorResponse(helper, eip, exc);
        }
    }

    @Path(value="masterdata/accessContract")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdaAccessContract() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.ACCESS_CONTRACT);
    }

    @Path(value="masterdata/ingestContract")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdaIngestContract() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.INGEST_CONTRACT);
    }

    @Path(value="masterdata/managementContract")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdaManagementContract() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.MANAGEMENT_CONTRACT);
    }

    @Path(value="masterdata/profile")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdataProfile() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.PROFILE);
    }

    @Path(value="masterdata/archiveUnitProfile")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdataArchiveUnitProfile() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE);
    }

    @Path(value="masterdata/agencies")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdataAgencies() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.AGENCIES);
    }

    @Path(value="masterdata/context")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdataContext() {
        return this.deleteMasterDataCollection(FunctionalAdminCollections.CONTEXT);
    }

    @Path(value="masterdata/securityProfile")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteMasterdataSecurityProfile() {
        Delete delete = null;
        try {
            delete = this.queryDeleteSecurityProfile();
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.SECURITY_PROFILE, delete);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (InvalidCreateOperationException | DatabaseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="masterdata/ontologies")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteAndImportOntologies(@Context HttpServletRequest request) throws IOException {
        Response response = this.deleteMasterDataCollection(FunctionalAdminCollections.ONTOLOGY);
        try (AdminExternalClient adminClient = AdminExternalClientFactory.getInstance().getClient();){
            InputStream input = this.getClass().getResourceAsStream("/VitamOntology.json");
            VitamContext context = this.userInterfaceTransactionManager.getVitamContext(request);
            context.setTenantId(Integer.valueOf(1));
            RequestResponse requestResponse = adminClient.importOntologies(true, context, input);
            if (requestResponse.isOk()) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (requestResponse instanceof VitamError) {
                VitamError error = (VitamError)requestResponse;
                Response response3 = Response.status((int)error.getHttpCode()).entity((Object)requestResponse).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="masterdata/griffins")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteGriffins(@Context HttpServletRequest request) throws IOException {
        this.deleteMasterDataCollection(FunctionalAdminCollections.GRIFFIN);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="masterdata/scenarios")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteScenarios(@Context HttpServletRequest request) throws IOException {
        this.deleteMasterDataCollection(FunctionalAdminCollections.PRESERVATION_SCENARIO);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response deleteMasterDataCollection(FunctionalAdminCollections collection) {
        if (!(collection.equals((Object)FunctionalAdminCollections.ACCESS_CONTRACT) || collection.equals((Object)FunctionalAdminCollections.INGEST_CONTRACT) || collection.equals((Object)FunctionalAdminCollections.MANAGEMENT_CONTRACT) || collection.equals((Object)FunctionalAdminCollections.PROFILE) || collection.equals((Object)FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE) || collection.equals((Object)FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC) || collection.equals((Object)FunctionalAdminCollections.ONTOLOGY) || collection.equals((Object)FunctionalAdminCollections.AGENCIES) || collection.equals((Object)FunctionalAdminCollections.GRIFFIN) || collection.equals((Object)FunctionalAdminCollections.PRESERVATION_SCENARIO) || collection.equals((Object)FunctionalAdminCollections.CONTEXT))) {
            throw new IllegalArgumentException("unsupported collection");
        }
        boolean fakeTenant = false;
        if (FunctionalAdminCollections.CONTEXT.equals((Object)collection) && VitamThreadUtils.getVitamSession().getTenantId() == null) {
            fakeTenant = true;
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(0));
        }
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)("STP_DELETE_MASTERDATA_" + collection.name()), (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)("STP_DELETE_MASTERDATA_" + collection.name()), (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
            if (FunctionalAdminCollections.CONTEXT.equals((Object)collection)) {
                this.mongoDbAccessAdmin.deleteCollectionForTesting(collection, this.queryDeleteContext()).close();
            } else if (FunctionalAdminCollections.ONTOLOGY.equals((Object)collection)) {
                this.mongoDbAccessAdmin.deleteCollectionForTesting(collection, this.queryDeleteExternalOntology()).close();
            } else {
                this.mongoDbAccessAdmin.deleteCollectionForTesting(collection).close();
            }
            parameters.setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)("STP_DELETE_MASTERDATA_" + collection.name()), (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)("STP_DELETE_MASTERDATA_" + collection.name()), (StatusCode)StatusCode.OK));
            helper.updateDelegate(parameters);
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), helper.removeCreateDelegate(eip.getId()).toArray(new LogbookOperationParameters[2]));
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (Exception exc) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)("STP_DELETE_MASTERDATA_" + collection.name()), (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)("STP_DELETE_MASTERDATA_" + collection.name()), (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)e);
            }
            Response response = this.updateLogbookAndGetErrorResponse(helper, eip, exc);
            return response;
        }
        finally {
            if (fakeTenant) {
                VitamThreadUtils.getVitamSession().setTenantId(null);
            }
        }
    }

    @Path(value="deleteTnr")
    @DELETE
    @Produces(value={"application/json"})
    public Response purgeDataForTnr() {
        this.deleteLogBook().close();
        this.deleteMasterDataCollection(FunctionalAdminCollections.AGENCIES).close();
        this.deleteMasterDataCollection(FunctionalAdminCollections.INGEST_CONTRACT).close();
        this.deleteMasterDataCollection(FunctionalAdminCollections.ACCESS_CONTRACT).close();
        this.deleteMasterDataCollection(FunctionalAdminCollections.MANAGEMENT_CONTRACT).close();
        this.deleteMasterDataCollection(FunctionalAdminCollections.ACCESSION_REGISTER_SYMBOLIC).close();
        this.deleteLifecycleUnits().close();
        this.deleteLifecycleOg().close();
        this.deleteMetadataOg().close();
        this.deleteMetadataUnits().close();
        this.deleteAccessionRegister().close();
        this.deleteRules().close();
        this.deleteFormats().close();
        this.deleteMasterdataProfile().close();
        this.deleteMasterdataArchiveUnitProfile().close();
        this.deleteMasterdataContext().close();
        this.deleteMasterdataSecurityProfile().close();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteAll() {
        Integer tenantId = ParameterHelper.getTenantParameter();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        ArrayList<String> collectionKO = new ArrayList<String>();
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)STP_DELETE_ALL, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)STP_DELETE_ALL, (StatusCode)StatusCode.STARTED), (GUID)eip);
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        try {
            helper.createDelegate(parameters);
        }
        catch (LogbookClientAlreadyExistsException exc) {
            LOGGER.error("Cannot create delegate logbook operation", (Throwable)exc);
        }
        this.deleteMetadataOg(tenantId, collectionKO, parameters, helper);
        this.deleteMetadataUnit(tenantId, collectionKO, parameters, helper);
        this.deleteRules(collectionKO, parameters, helper);
        this.deleteAccessionRegisterSummary(collectionKO, parameters, helper);
        this.deleteAccessionRegister(collectionKO, parameters, helper);
        this.deleteLogbookoperations(collectionKO, parameters, helper);
        this.deleteLogbookLifeCyleOg(collectionKO, parameters, helper);
        this.deleteLogbookLifeCycles(collectionKO, parameters, helper);
        this.deleteProfils(collectionKO, parameters, helper);
        this.deleteArchiveUnitProfils(collectionKO, parameters, helper);
        this.deleteAgencies(collectionKO, parameters, helper);
        this.deleteIngestContracts(collectionKO, parameters, helper);
        this.deleteManagementContracts(collectionKO, parameters, helper);
        this.deleteAccessContracts(collectionKO, parameters, helper);
        this.deleteContext(collectionKO, parameters, helper);
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ALL).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ALL, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ALL, (StatusCode)StatusCode.OK));
        try {
            helper.updateDelegate(parameters);
        }
        catch (LogbookClientNotFoundException exc) {
            LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
        }
        try {
            Queue createQueue = helper.removeCreateDelegate(eip.getId());
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), createQueue.toArray(new LogbookOperationParameters[createQueue.size()]));
        }
        catch (LogbookAlreadyExistsException | LogbookDatabaseException e) {
            LOGGER.error("Error when logging", e);
        }
        if (collectionKO.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(collectionKO).build();
    }

    public void deleteMetadataOg(Integer tenantId, List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_METADATA_OG).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.OK));
        try {
            this.mongoDbAccessMetadata.deleteObjectGroupByTenant(new Integer[]{tenantId});
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_OG, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(MetadataCollections.OBJECTGROUP.name());
        }
    }

    public void deleteMetadataUnit(Integer tenantId, List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_METADATA_UNIT).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.OK));
        try {
            this.mongoDbAccessMetadata.deleteUnitByTenant(new Integer[]{tenantId});
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_METADATA_UNIT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(MetadataCollections.UNIT.name());
        }
    }

    public void deleteRules(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_RULES).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_RULES, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_RULES, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.RULES);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_RULES, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_RULES, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.RULES.name());
        }
    }

    public void deleteAccessionRegisterSummary(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ACCESSION_REGISTER_SUMMARY).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_SUMMARY, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY.name());
        }
    }

    public void deleteAccessionRegister(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_ACCESSION_REGISTER_DETAIL).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_ACCESSION_REGISTER_DETAIL, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY.name());
        }
    }

    public void deleteLogbookoperations(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_LOGBOOK_OPERATION).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.OK));
        try {
            this.mongoDbAccessLogbook.deleteCollectionForTesting(LogbookCollections.OPERATION);
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_OPERATION, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(LogbookCollections.OPERATION.name());
        }
    }

    private void deleteLogbookLifeCyleOg(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_LOGBOOK_LIFECYCLE_OG).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.OK));
        try {
            this.mongoDbAccessLogbook.deleteCollectionForTesting(LogbookCollections.LIFECYCLE_OBJECTGROUP);
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_OG, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(LogbookCollections.LIFECYCLE_OBJECTGROUP.name());
        }
    }

    private void deleteLogbookLifeCycles(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, STP_DELETE_LOGBOOK_LIFECYCLE_UNIT).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.OK));
        try {
            this.mongoDbAccessLogbook.deleteCollectionForTesting(LogbookCollections.LIFECYCLE_UNIT);
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_LOGBOOK_LIFECYCLE_UNIT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(LogbookCollections.LIFECYCLE_UNIT.name());
        }
    }

    private void deleteProfils(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_PROFILE, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_PROFILE, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_PROFILE, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.PROFILE);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_PROFILE, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_PROFILE, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.PROFILE.name());
        }
    }

    private void deleteArchiveUnitProfils(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_ARCHIVE_UNIT_PROFILE, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.ARCHIVE_UNIT_PROFILE.name());
        }
    }

    private void deleteAgencies(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_AGENCIES, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_AGENCIES, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_AGENCIES, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.AGENCIES);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_AGENCIES, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_AGENCIES, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.AGENCIES.name());
        }
    }

    private void deleteIngestContracts(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_INGEST_CONTRACT, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_INGEST_CONTRACT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_INGEST_CONTRACT, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.INGEST_CONTRACT);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_INGEST_CONTRACT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_INGEST_CONTRACT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.INGEST_CONTRACT.name());
        }
    }

    private void deleteAccessContracts(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_ACCESS_CONTRACT, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_ACCESS_CONTRACT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_ACCESS_CONTRACT, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESS_CONTRACT);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_ACCESS_CONTRACT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_ACCESS_CONTRACT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.ACCESS_CONTRACT.name());
        }
    }

    private void deleteManagementContracts(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT, (StatusCode)StatusCode.OK));
        try (DbRequestResult result = this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.ACCESS_CONTRACT);){
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_MANAGEMENT_CONTRACT, (StatusCode)StatusCode.KO));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.MANAGEMENT_CONTRACT.name());
        }
    }

    private void deleteContext(List<String> collectionKO, LogbookOperationParameters parameters, LogbookOperationsClientHelper helper) {
        parameters.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_CONTEXT, (StatusCode)StatusCode.OK)).setStatus(StatusCode.OK).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_CONTEXT, (StatusCode)StatusCode.OK)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_CONTEXT, (StatusCode)StatusCode.OK));
        try {
            Delete delete = this.queryDeleteContext();
            this.mongoDbAccessAdmin.deleteCollectionForTesting(FunctionalAdminCollections.CONTEXT, delete);
            helper.updateDelegate(parameters);
        }
        catch (Exception e) {
            parameters.setStatus(StatusCode.KO).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)STP_DELETE_MASTERDATA_CONTEXT, (StatusCode)StatusCode.KO)).putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeOp((String)STP_DELETE_MASTERDATA_CONTEXT, (StatusCode)StatusCode.OK));
            try {
                helper.updateDelegate(parameters);
            }
            catch (LogbookClientNotFoundException exc) {
                LOGGER.error(CANNOT_UPDATE_DELEGATE_LOGBOOK_OPERATION, (Throwable)exc);
            }
            LOGGER.error((Throwable)e);
            collectionKO.add(FunctionalAdminCollections.CONTEXT.name());
        }
    }

    private Delete queryDeleteContext() throws InvalidCreateOperationException {
        Delete delete = new Delete();
        BooleanQuery orQuery = QueryHelper.or();
        for (String contextToSave : CONTEXTS_TO_SAVE) {
            orQuery.add(new Query[]{QueryHelper.eq((String)"Name", (String)contextToSave)});
        }
        BooleanQuery query = QueryHelper.not().add(new Query[]{orQuery});
        delete.setQuery((Query)query);
        return delete;
    }

    private Delete queryDeleteSecurityProfile() throws InvalidCreateOperationException {
        Delete delete = new Delete();
        BooleanQuery orQuery = QueryHelper.or();
        for (String securityProfileToSave : SECURITY_PROFILES_TO_SAVE) {
            orQuery.add(new Query[]{QueryHelper.eq((String)"Name", (String)securityProfileToSave)});
        }
        BooleanQuery query = QueryHelper.not().add(new Query[]{orQuery});
        delete.setQuery((Query)query);
        return delete;
    }

    private Delete queryDeleteExternalOntology() throws InvalidCreateOperationException {
        Delete delete = new Delete();
        CompareQuery query = QueryHelper.eq((String)ONTOLOGY_ORIGIN, (String)ONTOLOGY_EXTERNAL);
        delete.setQuery((Query)query);
        return delete;
    }

    private Response updateLogbookAndGetErrorResponse(LogbookOperationsClientHelper helper, GUID eip, Exception exc) {
        try {
            Queue parameters = helper.removeCreateDelegate(eip.getId());
            this.mongoDbAccessLogbook.createLogbookOperation(eip.getId(), (LogbookOperationParameters[])parameters.toArray(LogbookOperationParameters[]::new));
        }
        catch (LogbookAlreadyExistsException | LogbookDatabaseException e) {
            LOGGER.error(e);
        }
        LOGGER.error((Throwable)exc);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)exc.getMessage()).build();
    }
}

