/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.server.application.configuration.FunctionalAdminAdmin;
import fr.gouv.vitam.common.server.application.configuration.MongoDbNode;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookIndexationConfiguration;
import fr.gouv.vitam.metadata.core.config.ElasticsearchExternalMetadataMapping;
import fr.gouv.vitam.metadata.core.config.MetadataIndexationConfiguration;
import fr.gouv.vitam.metadata.core.mapping.MappingLoader;
import java.util.List;

public class WebApplicationConfig
extends DbConfigurationImpl {
    private int port;
    private String serverHost;
    private String baseUrl;
    private String baseUri;
    private boolean secure;
    private List<String> secureMode;
    private String sipDirectory;
    private String performanceReportDirectory;
    private String masterdataDbName;
    private String logbookDbName;
    private String metadataDbName;
    private String testSystemSipDirectory;
    private String testSystemReportDirectory;
    private int ingestMaxThread;
    private FunctionalAdminAdmin functionalAdminAdmin;
    private List<ElasticsearchExternalMetadataMapping> elasticsearchExternalMetadataMappings;
    private String workspaceUrl;
    private String clusterName;
    private List<ElasticsearchNode> elasticsearchNodes;
    @JsonProperty(value="functionalAdminIndexationSettings")
    private FunctionalAdminIndexationConfiguration functionalAdminIndexationConfiguration;
    @JsonProperty(value="metadataIndexationSettings")
    private MetadataIndexationConfiguration metadataIndexationConfiguration;
    @JsonProperty(value="logbookIndexationSettings")
    private LogbookIndexationConfiguration logbookIndexationConfiguration;
    @JsonProperty(value="elasticsearchConfigurationFile")
    private String elasticsearchConfigurationFile;

    WebApplicationConfig() {
    }

    public WebApplicationConfig(List<MongoDbNode> mongoDbNodes, String dbName, String clusterName, List<ElasticsearchNode> elasticsearchNodes, MappingLoader mappingLoader) {
        super(mongoDbNodes, dbName);
        this.clusterName = clusterName;
        this.elasticsearchNodes = elasticsearchNodes;
        this.elasticsearchExternalMetadataMappings = mappingLoader.getElasticsearchExternalMappings();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public WebApplicationConfig setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public WebApplicationConfig setBaseUri(String baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getSipDirectory() {
        return this.sipDirectory;
    }

    public void setSipDirectory(String sipDirectory) {
        this.sipDirectory = sipDirectory;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMasterdataDbName() {
        return this.masterdataDbName;
    }

    public void setMasterdataDbName(String masterdataDbName) {
        this.masterdataDbName = masterdataDbName;
    }

    public String getLogbookDbName() {
        return this.logbookDbName;
    }

    public void setLogbookDbName(String logbookDbName) {
        this.logbookDbName = logbookDbName;
    }

    public String getMetadataDbName() {
        return this.metadataDbName;
    }

    public void setMetadataDbName(String metadataDbName) {
        this.metadataDbName = metadataDbName;
    }

    public String getTestSystemSipDirectory() {
        return this.testSystemSipDirectory;
    }

    public void setTestSystemSipDirectory(String testSystemSipDirectory) {
        this.testSystemSipDirectory = testSystemSipDirectory;
    }

    public String getTestSystemReportDirectory() {
        return this.testSystemReportDirectory;
    }

    public void setTestSystemReportDirectory(String testSystemReportDirectory) {
        this.testSystemReportDirectory = testSystemReportDirectory;
    }

    public String getPerformanceReportDirectory() {
        return this.performanceReportDirectory;
    }

    public void setPerformanceReportDirectory(String performanceReportDirectory) {
        this.performanceReportDirectory = performanceReportDirectory;
    }

    public List<String> getSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(List<String> secureMode) {
        this.secureMode = secureMode;
    }

    public int getIngestMaxThread() {
        return this.ingestMaxThread;
    }

    public void setIngestMaxThread(int ingestMaxThread) {
        this.ingestMaxThread = ingestMaxThread;
    }

    public FunctionalAdminAdmin getFunctionalAdminAdmin() {
        return this.functionalAdminAdmin;
    }

    public void setFunctionalAdminAdmin(FunctionalAdminAdmin functionalAdminAdmin) {
        this.functionalAdminAdmin = functionalAdminAdmin;
    }

    public List<ElasticsearchExternalMetadataMapping> getElasticsearchExternalMetadataMappings() {
        return this.elasticsearchExternalMetadataMappings;
    }

    public void setElasticsearchExternalMetadataMappings(List<ElasticsearchExternalMetadataMapping> elasticsearchExternalMetadataMappings) {
        this.elasticsearchExternalMetadataMappings = elasticsearchExternalMetadataMappings;
    }

    public String getWorkspaceUrl() {
        return this.workspaceUrl;
    }

    public WebApplicationConfig setWorkspaceUrl(String workspaceUrl) {
        this.workspaceUrl = workspaceUrl;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public WebApplicationConfig setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public List<ElasticsearchNode> getElasticsearchNodes() {
        return this.elasticsearchNodes;
    }

    public WebApplicationConfig setElasticsearchNodes(List<ElasticsearchNode> elasticsearchNodes) {
        this.elasticsearchNodes = elasticsearchNodes;
        return this;
    }

    public FunctionalAdminIndexationConfiguration getFunctionalAdminIndexationConfiguration() {
        return this.functionalAdminIndexationConfiguration;
    }

    public WebApplicationConfig setFunctionalAdminIndexationConfiguration(FunctionalAdminIndexationConfiguration functionalAdminIndexationConfiguration) {
        this.functionalAdminIndexationConfiguration = functionalAdminIndexationConfiguration;
        return this;
    }

    public MetadataIndexationConfiguration getMetadataIndexationConfiguration() {
        return this.metadataIndexationConfiguration;
    }

    public WebApplicationConfig setMetadataIndexationConfiguration(MetadataIndexationConfiguration metadataIndexationConfiguration) {
        this.metadataIndexationConfiguration = metadataIndexationConfiguration;
        return this;
    }

    public LogbookIndexationConfiguration getLogbookIndexationConfiguration() {
        return this.logbookIndexationConfiguration;
    }

    public WebApplicationConfig setLogbookIndexationConfiguration(LogbookIndexationConfiguration logbookIndexationConfiguration) {
        this.logbookIndexationConfiguration = logbookIndexationConfiguration;
        return this;
    }

    public String getElasticsearchConfigurationFile() {
        return this.elasticsearchConfigurationFile;
    }

    public WebApplicationConfig setElasticsearchConfigurationFile(String elasticsearchConfigurationFile) {
        this.elasticsearchConfigurationFile = elasticsearchConfigurationFile;
        return this;
    }
}

