/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import java.io.InputStream;
import java.util.Collections;

public class StorageCRUDUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageCRUDUtils.class);
    StorageClient storageClient;

    StorageCRUDUtils() {
        this.storageClient = StorageClientFactory.getInstance().getClient();
    }

    @VisibleForTesting
    public StorageCRUDUtils(StorageClient storageClient) {
        this.storageClient = storageClient;
    }

    public RequestResponse<StorageStrategy> getStrategies() throws StorageServerClientException {
        return this.storageClient.getStorageStrategies();
    }

    public boolean deleteFile(DataCategory dataCategory, String uid, String strategyId, String offerId) throws StorageServerClientException {
        return this.storageClient.delete(strategyId, dataCategory, uid, Collections.singletonList(offerId));
    }

    public void storeInOffer(DataCategory dataCategory, String uid, String strategyId, String offerId, Long size, InputStream stream) throws BackupServiceException {
        boolean delete = false;
        try {
            delete = this.deleteFile(dataCategory, uid, strategyId, offerId);
            if (!delete) {
                throw new BackupServiceException("file do not exits or can not deleted ");
            }
        }
        catch (StorageServerClientException e) {
            LOGGER.error("error when deleting file ", (Throwable)e);
        }
        try {
            this.storageClient.create(strategyId, uid, dataCategory, stream, size, Collections.singletonList(offerId));
        }
        catch (InvalidParseOperationException | StorageServerClientException e) {
            LOGGER.error("error when deleting file ", e);
            throw new BackupServiceException("fail to create");
        }
    }
}

