/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientMock;
import fr.gouv.vitam.metadata.client.MetaDataClientRest;
import fr.gouv.vitam.metadata.client.MetadataType;
import java.io.File;
import java.io.IOException;

public class MetaDataClientFactory
extends VitamClientFactory<MetaDataClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetaDataClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "metadata-client.conf";
    private static final MetaDataClientFactory META_DATA_CLIENT_FACTORY = new MetaDataClientFactory("/metadata/v1");
    private static final MetaDataClientFactory META_DATA_COLLECT_CLIENT_FACTORY = new MetaDataClientFactory("/metadata-collect/v1");

    private MetaDataClientFactory(String resourcePath) {
        super(MetaDataClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), resourcePath, false);
    }

    static ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public static void changeMode(ClientConfiguration configuration) {
        for (MetadataType type : MetadataType.values()) {
            MetaDataClientFactory.getInstance(type).initialisation(configuration, MetaDataClientFactory.getInstance(type).getResourcePath());
        }
    }

    public static MetaDataClientFactory getInstance() {
        return MetaDataClientFactory.getInstance(MetadataType.VITAM);
    }

    public static MetaDataClientFactory getInstance(MetadataType metadataType) {
        if (metadataType == MetadataType.VITAM) {
            return META_DATA_CLIENT_FACTORY;
        }
        if (metadataType == MetadataType.COLLECT) {
            return META_DATA_COLLECT_CLIENT_FACTORY;
        }
        return null;
    }

    public MetaDataClient getClient() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Actually only one client implementation exists, so ignore client type value");
        }
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new MetaDataClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new MetaDataClientRest((VitamClientFactoryInterface<MetaDataClient>)this);
            default -> throw new IllegalArgumentException("metadata type unknown");
        };
    }
}

