/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.workspace.driver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.model.storage.ObjectEntryReader;
import fr.gouv.vitam.storage.driver.AbstractConnection;
import fr.gouv.vitam.storage.driver.exception.StorageDriverConflictException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverNotFoundException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverPreconditionFailedException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverServerErrorException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverServiceUnavailableException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.storage.driver.model.StorageAccessRequestCreationRequest;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutRequest;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageCapacityResult;
import fr.gouv.vitam.storage.driver.model.StorageCheckObjectAvailabilityRequest;
import fr.gouv.vitam.storage.driver.model.StorageCheckObjectAvailabilityResult;
import fr.gouv.vitam.storage.driver.model.StorageGetBulkMetadataRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetMetadataRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetResult;
import fr.gouv.vitam.storage.driver.model.StorageListRequest;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageObjectRequest;
import fr.gouv.vitam.storage.driver.model.StorageOfferLogRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutResult;
import fr.gouv.vitam.storage.driver.model.StorageRemoveRequest;
import fr.gouv.vitam.storage.driver.model.StorageRemoveResult;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.request.OfferLogRequest;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class ConnectionImpl
extends AbstractConnection {
    private static final String X_USABLE_SPACE = "X-Usable-Space";
    private static final long DEFAULT_MAX_AVAILABILITY = 100000000000L;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ConnectionImpl.class);
    private static final String OBJECTS_PATH = "/objects";
    private static final String ACCESS_REQUEST_PATH = "/access-request";
    private static final String ACCESS_REQUEST_STATUSES_PATH = "/access-request/statuses";
    private static final String CHECK_OBJECT_AVAILABILITY_PATH = "/object-availability-check";
    private static final String LOGS_PATH = "/logs";
    private static final String METADATAS = "/metadatas";
    private static final String REQUEST_IS_A_MANDATORY_PARAMETER = "Request is a mandatory parameter";
    private static final String GUID_IS_A_MANDATORY_PARAMETER = "GUID is a mandatory parameter";
    private static final String TENANT_IS_A_MANDATORY_PARAMETER = "Tenant is a mandatory parameter";
    private static final String ALGORITHM_IS_A_MANDATORY_PARAMETER = "Algorithm is a mandatory parameter";
    private static final String STREAM_IS_A_MANDATORY_PARAMETER = "Stream is a mandatory parameter";
    private static final String TYPE_IS_A_MANDATORY_PARAMETER = "Type is a mandatory parameter";
    private static final String ORDER_IS_A_MANDATORY_PARAMETER = "Order is a mandatory parameter";
    private static final String TYPE_IS_NOT_VALID = "Type is not valid";
    private static final String FOLDER_IS_A_MANDATORY_PARAMETER = "Folder is a mandatory parameter";
    private static final String FOLDER_IS_NOT_VALID = "Folder is not valid";
    private static final String ACCESS_REQUEST_ID_IS_A_MANDATORY_PARAMETER = "Access Request Id is a mandatory parameter";
    private static final String BAD_REQUEST_ERROR_MESSAGE = "Bad request";

    ConnectionImpl(String driverName, VitamClientFactoryInterface<? extends AbstractConnection> factory) {
        super(driverName, factory);
    }

    private void checkStorageException(Response response) throws StorageDriverException {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case NOT_FOUND: {
                throw new StorageDriverNotFoundException(this.getDriverName(), status.getReasonPhrase());
            }
            case PRECONDITION_FAILED: {
                throw new StorageDriverPreconditionFailedException(this.getDriverName(), "Precondition failed");
            }
            case BAD_REQUEST: {
                throw new StorageDriverPreconditionFailedException(this.getDriverName(), BAD_REQUEST_ERROR_MESSAGE);
            }
            case SERVICE_UNAVAILABLE: {
                throw new StorageDriverServiceUnavailableException(this.getDriverName(), status.getReasonPhrase());
            }
            case CONFLICT: {
                throw new StorageDriverConflictException(this.getDriverName(), status.getReasonPhrase());
            }
            case INTERNAL_SERVER_ERROR: {
                throw new StorageDriverServerErrorException(this.getDriverName(), status.getReasonPhrase());
            }
        }
        throw new StorageDriverException(this.getDriverName(), status.getReasonPhrase(), true);
    }

    private void checkCustomResponseStatusForUnavailableDataFromAsyncOffer(Response response) throws StorageDriverException {
        CustomVitamHttpStatusCode customStatusCode = CustomVitamHttpStatusCode.fromStatusCode((int)response.getStatus());
        if (customStatusCode == null) {
            return;
        }
        if (customStatusCode == CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER) {
            throw new StorageDriverUnavailableDataFromAsyncOfferException(this.getDriverName(), "Access to async offer requires valid access request");
        }
        throw new StorageDriverException(this.getDriverName(), "Unexpected status code received: " + response.getStatus(), false);
    }

    public StorageCapacityResult getStorageCapacity(Integer tenantId) throws StorageDriverException {
        StorageCapacityResult storageCapacityResult;
        block8: {
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{tenantId});
            VitamRequestBuilder request = VitamRequestBuilder.head().withPath("/objects/" + String.valueOf(DataCategory.OBJECT)).withHeader("X-Tenant-Id", (Object)tenantId).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkStorageException(response);
                storageCapacityResult = new StorageCapacityResult(tenantId, this.getAvailableSpace(response));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR.getMessage(), true, (Throwable)e);
                }
            }
            response.close();
        }
        return storageCapacityResult;
    }

    private long getAvailableSpace(Response response) {
        if (response.getHeaderString(X_USABLE_SPACE) != null) {
            try {
                return Long.parseLong(response.getHeaderString(X_USABLE_SPACE));
            }
            catch (NumberFormatException e) {
                LOGGER.info("Not a number", (Throwable)e);
            }
        }
        return 100000000000L;
    }

    public StorageGetResult getObject(StorageObjectRequest request) throws StorageDriverException {
        ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
        ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getGuid()});
        ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
        ParametersChecker.checkParameter((String)FOLDER_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
        ParametersChecker.checkParameter((String)FOLDER_IS_NOT_VALID, (Object[])new Object[]{DataCategory.getByFolder((String)request.getType())});
        VitamRequestBuilder requestbuilder = VitamRequestBuilder.get().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType())) + "/" + request.getGuid()).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withOctetAccept();
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(requestbuilder);
            this.checkCustomResponseStatusForUnavailableDataFromAsyncOffer(response);
            this.checkStorageException(response);
            doNotCloseResponse = true;
            StorageGetResult storageGetResult = new StorageGetResult(request.getTenantId(), request.getType(), request.getGuid(), response);
            return storageGetResult;
        }
        catch (VitamClientInternalException e) {
            throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                this.consumeAnyEntityAndClose(response);
            }
        }
    }

    public String createAccessRequest(StorageAccessRequestCreationRequest request) throws StorageDriverException {
        String string;
        block8: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getObjectNames()});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])((String[])request.getObjectNames().toArray(String[]::new)));
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
            ParametersChecker.checkParameter((String)FOLDER_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
            ParametersChecker.checkParameter((String)FOLDER_IS_NOT_VALID, (Object[])new Object[]{DataCategory.getByFolder((String)request.getType())});
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.post().withPath("/access-request/" + String.valueOf(DataCategory.getByFolder((String)request.getType()))).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withBody((Object)request.getObjectNames()).withJson();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                RequestResponseOK accessRequestCreationResponse = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, String.class);
                string = (String)accessRequestCreationResponse.getFirstResult();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> accessRequestIds, int tenant, boolean adminCrossTenantAccessRequestAllowed) throws StorageDriverException {
        Map map;
        block8: {
            ParametersChecker.checkParameter((String)ACCESS_REQUEST_ID_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{accessRequestIds});
            ParametersChecker.checkParameter((String)ACCESS_REQUEST_ID_IS_A_MANDATORY_PARAMETER, (String[])((String[])accessRequestIds.toArray(String[]::new)));
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{tenant});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(ACCESS_REQUEST_STATUSES_PATH).withHeader("X-Tenant-Id", (Object)tenant).withHeader("X-Admin-Cross-Tenant-Access-Request-Allowed", (Object)Boolean.toString(adminCrossTenantAccessRequestAllowed)).withJson().withBody(accessRequestIds);
            Response response = this.make(request);
            try {
                this.checkStorageException(response);
                RequestResponseOK objectRequestResponseOK = (RequestResponseOK)JsonHandler.getFromInputStreamAsTypeReference((InputStream)((InputStream)response.readEntity(InputStream.class)), (TypeReference)new TypeReference<RequestResponseOK<Map<String, AccessRequestStatus>>>(){});
                map = (Map)objectRequestResponseOK.getFirstResult();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, e);
                }
            }
            response.close();
        }
        return map;
    }

    public void removeAccessRequest(String accessRequestId, int tenant, boolean adminCrossTenantAccessRequestAllowed) throws StorageDriverException {
        ParametersChecker.checkParameter((String)ACCESS_REQUEST_ID_IS_A_MANDATORY_PARAMETER, (String[])new String[]{accessRequestId});
        ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{tenant});
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/access-request/" + accessRequestId).withHeader("X-Tenant-Id", (Object)tenant).withHeader("X-Admin-Cross-Tenant-Access-Request-Allowed", (Object)Boolean.toString(adminCrossTenantAccessRequestAllowed)).withJsonAccept();
        try (Response response = this.make(request);){
            this.checkStorageException(response);
        }
        catch (VitamClientInternalException e) {
            throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
        }
    }

    public boolean checkObjectAvailability(StorageCheckObjectAvailabilityRequest request) throws StorageDriverException {
        boolean bl;
        block9: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getObjectNames()});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])((String[])request.getObjectNames().toArray(String[]::new)));
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
            ParametersChecker.checkParameter((String)FOLDER_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
            ParametersChecker.checkParameter((String)FOLDER_IS_NOT_VALID, (Object[])new Object[]{DataCategory.getByFolder((String)request.getType())});
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.get().withPath("/object-availability-check/" + String.valueOf(DataCategory.getByFolder((String)request.getType()))).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withBody((Object)request.getObjectNames()).withJson();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                RequestResponseOK accessRequestCreationResponse = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, StorageCheckObjectAvailabilityResult.class);
                StorageCheckObjectAvailabilityResult objectAvailabilityResult = (StorageCheckObjectAvailabilityResult)accessRequestCreationResponse.getFirstResult();
                if (objectAvailabilityResult == null) {
                    throw new IllegalStateException("Could not retrieve object availability");
                }
                bl = objectAvailabilityResult.getAreObjectsAvailable();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
                }
            }
            response.close();
        }
        return bl;
    }

    public StoragePutResult putObject(StoragePutRequest request) throws StorageDriverException {
        StoragePutResult storagePutResult;
        block11: {
            try {
                ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
                ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getGuid()});
                ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
                ParametersChecker.checkParameter((String)ALGORITHM_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getDigestAlgorithm()});
                ParametersChecker.checkParameter((String)TYPE_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
                ParametersChecker.checkParameter((String)TYPE_IS_NOT_VALID, (Object[])new Object[]{DataCategory.getByFolder((String)request.getType())});
                ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getDataStream()});
            }
            catch (IllegalArgumentException exc) {
                throw new StorageDriverPreconditionFailedException(this.getDriverName(), (Throwable)exc);
            }
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.put().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType())) + "/" + request.getGuid()).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withHeader("X-digest-algorithm", (Object)request.getDigestAlgorithm()).withHeader("Vitam-Content-Length", (Object)request.getSize()).withBody((Object)request.getDataStream()).withOctetContentType().withJsonAccept();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                JsonNode json = (JsonNode)response.readEntity(JsonNode.class);
                if (Response.Status.CREATED.getStatusCode() != response.getStatus()) {
                    throw new StorageDriverException(this.getDriverName(), "Error while performing put object operation for object " + request.getGuid() + " (" + request.getType() + ")", true);
                }
                storagePutResult = new StoragePutResult(request.getTenantId(), request.getType(), request.getGuid(), request.getGuid(), json.get("digest").textValue(), json.get("size").longValue());
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
                }
            }
            response.close();
        }
        return storagePutResult;
    }

    public StorageBulkPutResult bulkPutObjects(StorageBulkPutRequest request) throws StorageDriverException {
        StorageBulkPutResult storageBulkPutResult;
        block11: {
            try {
                ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
                ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getObjectIds()});
                ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (Object[])request.getObjectIds().toArray());
                ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
                ParametersChecker.checkParameter((String)ALGORITHM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getDigestType()});
                ParametersChecker.checkParameter((String)TYPE_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
                ParametersChecker.checkParameter((String)TYPE_IS_NOT_VALID, (Object[])new Object[]{DataCategory.getByFolder((String)request.getType())});
                ParametersChecker.checkParameter((String)STREAM_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getDataStream()});
            }
            catch (IllegalArgumentException e) {
                throw new StorageDriverPreconditionFailedException(this.getDriverName(), (Throwable)e);
            }
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.put().withPath("/bulk/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType()))).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withHeader("X-digest-algorithm", (Object)request.getDigestType().getName()).withHeader("Vitam-Content-Length", (Object)request.getSize()).withBody((Object)request.getDataStream()).withOctetContentType().withJsonAccept();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                if (Response.Status.CREATED.getStatusCode() != response.getStatus()) {
                    throw new StorageDriverException(this.getDriverName(), "Error while performing bulk put object operation for objects " + String.valueOf(request.getObjectIds()) + " (" + request.getType() + ")", true);
                }
                storageBulkPutResult = (StorageBulkPutResult)response.readEntity(StorageBulkPutResult.class);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
                }
            }
            response.close();
        }
        return storageBulkPutResult;
    }

    public StorageRemoveResult removeObject(StorageRemoveRequest request) throws StorageDriverException {
        StorageRemoveResult storageRemoveResult;
        block8: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getGuid()});
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
            ParametersChecker.checkParameter((String)FOLDER_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
            ParametersChecker.checkParameter((String)FOLDER_IS_NOT_VALID, (Object[])new Object[]{DataCategory.getByFolder((String)request.getType())});
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.delete().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType())) + "/" + request.getGuid()).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withJsonAccept();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                JsonNode json = (JsonNode)response.readEntity(JsonNode.class);
                storageRemoveResult = new StorageRemoveResult(request.getTenantId(), request.getType(), request.getGuid(), Response.Status.OK.toString().equals(json.get("status").asText()));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
                }
            }
            response.close();
        }
        return storageRemoveResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean objectExistsInOffer(StorageObjectRequest request) throws StorageDriverException {
        ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
        ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getGuid()});
        ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
        VitamRequestBuilder requestBuilder = VitamRequestBuilder.head().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType())) + "/" + request.getGuid()).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withJsonAccept();
        try (Response response = this.make(requestBuilder);){
            Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
            switch (status) {
                case OK: 
                case NO_CONTENT: {
                    boolean bl = true;
                    return bl;
                }
                case NOT_FOUND: {
                    boolean bl = false;
                    return bl;
                }
                case BAD_REQUEST: {
                    throw new StorageDriverPreconditionFailedException(this.getDriverName(), BAD_REQUEST_ERROR_MESSAGE);
                }
            }
            throw new StorageDriverException(this.getDriverName(), status.getReasonPhrase(), true);
        }
        catch (VitamClientInternalException e) {
            throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
        }
    }

    public StorageMetadataResult getMetadatas(StorageGetMetadataRequest request) throws StorageDriverException {
        StorageMetadataResult storageMetadataResult;
        block8: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
            ParametersChecker.checkParameter((String)FOLDER_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getGuid()});
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.get().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType())) + "/" + request.getGuid() + METADATAS).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withHeader("X-Offer-No-Cache", (Object)request.isNoCache()).withJsonAccept();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                storageMetadataResult = (StorageMetadataResult)response.readEntity(StorageMetadataResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), true, (Throwable)e);
                }
            }
            response.close();
        }
        return storageMetadataResult;
    }

    public StorageBulkMetadataResult getBulkMetadata(StorageGetBulkMetadataRequest request) throws StorageDriverException, InvalidParseOperationException {
        StorageBulkMetadataResult storageBulkMetadataResult;
        block8: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
            ParametersChecker.checkParameter((String)FOLDER_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
            ParametersChecker.checkParameter((String)GUID_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getGuids()});
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.get().withPath("/bulk/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType())) + "/metadata").withHeader("X-Tenant-Id", (Object)request.getTenantId()).withHeader("X-Offer-No-Cache", (Object)request.isNoCache()).withBody((Object)JsonHandler.writeToInpustream((Object)request.getGuids())).withJson();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                storageBulkMetadataResult = (StorageBulkMetadataResult)response.readEntity(StorageBulkMetadataResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), true, (Throwable)e);
                }
            }
            response.close();
        }
        return storageBulkMetadataResult;
    }

    public CloseableIterator<ObjectEntry> listObjects(StorageListRequest request) throws StorageDriverException {
        ObjectEntryReader objectEntryReader;
        block8: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request});
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{request.getTenantId()});
            ParametersChecker.checkParameter((String)TYPE_IS_A_MANDATORY_PARAMETER, (String[])new String[]{request.getType()});
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.get().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)request.getType()))).withHeader("X-Tenant-Id", (Object)request.getTenantId()).withJsonAccept();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                InputStream rawResponseInputStream = (InputStream)response.readEntity(InputStream.class);
                objectEntryReader = new ObjectEntryReader(rawResponseInputStream);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException exc) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)exc);
                }
            }
            response.close();
        }
        return objectEntryReader;
    }

    public RequestResponse<OfferLog> getOfferLogs(StorageOfferLogRequest storageGetOfferLogRequest) throws StorageDriverException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)REQUEST_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{storageGetOfferLogRequest});
            ParametersChecker.checkParameter((String)TENANT_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{storageGetOfferLogRequest.getTenantId()});
            ParametersChecker.checkParameter((String)TYPE_IS_A_MANDATORY_PARAMETER, (String[])new String[]{storageGetOfferLogRequest.getType()});
            ParametersChecker.checkParameter((String)ORDER_IS_A_MANDATORY_PARAMETER, (Object[])new Object[]{storageGetOfferLogRequest.getOrder()});
            OfferLogRequest offerLogRequest = new OfferLogRequest();
            offerLogRequest.setOffset(storageGetOfferLogRequest.getOffset());
            offerLogRequest.setLimit(storageGetOfferLogRequest.getLimit());
            offerLogRequest.setOrder(storageGetOfferLogRequest.getOrder());
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.get().withPath("/objects/" + String.valueOf(DataCategory.getByFolder((String)storageGetOfferLogRequest.getType())) + LOGS_PATH).withHeader("X-Tenant-Id", (Object)storageGetOfferLogRequest.getTenantId()).withBody((Object)offerLogRequest).withJson();
            Response response = this.make(requestBuilder);
            try {
                this.checkStorageException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, OfferLog.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exc) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)exc);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    public Response launchOfferLogCompaction(VitamContext vitamContext) throws StorageDriverException {
        Response response;
        block8: {
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.post().withPath("/compaction").withHeader("X-Tenant-Id", (Object)vitamContext.getTenantId()).withJson();
            Response response2 = this.make(requestBuilder);
            try {
                this.checkStorageException(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageDriverException(this.getDriverName(), true, (Throwable)e);
                }
            }
            response2.close();
        }
        return response;
    }
}

