/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ExtractedMetadata;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ExtractedMetadataRepository {
    public static final String COLLECTION_NAME = "ExtractedMetadata";
    private final MongoCollection<Document> extractedMetadataForAuCollection;

    public ExtractedMetadataRepository(MongoCollection<Document> extractedMetadataForAuCollection) {
        this.extractedMetadataForAuCollection = extractedMetadataForAuCollection;
    }

    public void addExtractedMetadataForAu(List<ExtractedMetadata> extractedMetadatas) {
        List extractedMetadataDocuments = extractedMetadatas.stream().map(this::toUpdateModel).collect(Collectors.toList());
        BulkWriteOptions insertWithoutOrder = new BulkWriteOptions().ordered(false);
        this.extractedMetadataForAuCollection.bulkWrite(extractedMetadataDocuments, insertWithoutOrder);
    }

    private UpdateOneModel<Document> toUpdateModel(ExtractedMetadata metadata) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"id", (Object)metadata.getId()), Filters.eq((String)"processId", (Object)metadata.getProcessId()), Filters.eq((String)"tenant", (Object)metadata.getTenant())});
        return new UpdateOneModel(filter, (Bson)new Document("$set", (Object)this.pojoToBson(metadata)), new UpdateOptions().upsert(true));
    }

    public MongoCursor<ExtractedMetadata> getExtractedMetadataByProcessId(String processId, int tenant) {
        return this.extractedMetadataForAuCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"tenant", (Object)tenant)})).map(this::bsonToPojo).cursor();
    }

    public void deleteExtractedMetadataByProcessId(String processId, int tenant) {
        this.extractedMetadataForAuCollection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"tenant", (Object)tenant)}));
    }

    private Document pojoToBson(ExtractedMetadata metadata) {
        return Document.parse((String)JsonHandler.unprettyPrint((Object)metadata));
    }

    private ExtractedMetadata bsonToPojo(Document document) {
        try {
            return (ExtractedMetadata)BsonHelper.fromDocumentToObject((Document)document, ExtractedMetadata.class);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

