/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.CollectInternalClientFactory;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientInvalidRequestException;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientNotFoundException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/collect-external/v1/projects")
@Tag(name="Collect")
public class ProjectExternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProjectExternalResource.class);
    private static final String YOU_MUST_SUPPLY_PROJECTS_DATA = "You must supply projects data!";
    private static final String PREDICATES_FAILED_EXCEPTION = "Predicates Failed Exception ";
    private static final String PROJECT_NOT_FOUND = "Unable to find project Id or invalid status";
    private final CollectInternalClientFactory collectInternalClientFactory;

    ProjectExternalResource() {
        this(CollectInternalClientFactory.getInstance());
    }

    @VisibleForTesting
    ProjectExternalResource(CollectInternalClientFactory collectInternalClientFactory) {
        this.collectInternalClientFactory = collectInternalClientFactory;
    }

    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_READ, description="R\u00e9cup\u00e8re la liste des projets par tenant")
    public Response getProjects() {
        Response response;
        block8: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                RequestResponse response2 = client.getProjects();
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when fetching projects  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_QUERY_READ, description="R\u00e9cup\u00e9rer une liste des projets par query")
    public Response searchProject(CriteriaProjectDto criteriaProjectDto) {
        RequestResponseOK listProjectsResponse;
        JsonNode criteriaProjectJsonNode;
        try {
            criteriaProjectJsonNode = JsonHandler.toJsonNode((Object)criteriaProjectDto);
        }
        catch (InvalidParseOperationException e) {
            String message = "An error occurred while converting the DTO to a JsonNode";
            LOGGER.error("An error occurred while converting the DTO to a JsonNode");
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)"An error occurred while converting the DTO to a JsonNode");
        }
        try {
            SanityChecker.checkJsonAll((JsonNode)criteriaProjectJsonNode);
        }
        catch (InvalidParseOperationException e) {
            String message = e.getLocalizedMessage();
            LOGGER.error("Input seems contains insane data: {}", (Object)message);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)message);
        }
        ParametersChecker.checkParameter((String)"You must supply criteria of Project!", (Object[])new Object[]{criteriaProjectDto});
        try (CollectInternalClient client = this.collectInternalClientFactory.getClient();){
            listProjectsResponse = client.searchProject(criteriaProjectDto);
        }
        catch (VitamClientException e) {
            String message = e.getLocalizedMessage();
            LOGGER.error("Client error : {}", (Object)message);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.fromStatusCode((int)e.getVitamError().getStatus()), (String)e.getVitamError().getMessage());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)listProjectsResponse).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_CREATE, description="Cr\u00e9er un projet avec une transaction")
    public Response initProject(ProjectDto projectDto) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)YOU_MUST_SUPPLY_PROJECTS_DATA, (Object[])new Object[]{projectDto});
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)projectDto));
                RequestResponse response2 = client.initProject(projectDto);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when init project  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_UPDATE, description="Mise \u00e0 jour d'un projet")
    public Response updateProject(ProjectDto projectDto) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)YOU_MUST_SUPPLY_PROJECTS_DATA, (Object[])new Object[]{projectDto});
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)projectDto));
                RequestResponse response2 = client.updateProject(projectDto);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when updating projects  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{projectId}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_ID_READ, description="R\u00e9cup\u00e8re un projet par son id")
    public Response getProjectById(@PathParam(value="projectId") String projectId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{projectId});
                RequestResponse projectResponse = client.getProjectById(projectId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)projectResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when fetching project   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)PROJECT_NOT_FOUND);
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{projectId}")
    @DELETE
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_ID_DELETE, description="Supprime un projet par son id")
    public Response deleteProjectById(@PathParam(value="projectId") String projectId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{projectId});
                client.deleteProjectById(projectId);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when deleting project   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    public Response getUnitsByProjectId(@PathParam(value="projectId") String projectId, JsonNode queryDsl) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{projectId});
                SanityChecker.checkJsonAll((JsonNode)queryDsl);
                RequestResponseOK projectResponse = client.getUnitsByProjectId(projectId, queryDsl);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)projectResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when get units by project  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{projectId}/transactions")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_ID_TRANSACTIONS, description="R\u00e9cup\u00e9rer la liste des transactions du projet")
    public Response getAllTransactions(@PathParam(value="projectId") String projectId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{projectId});
                RequestResponse transactionsResponse = client.getTransactionByProjectId(projectId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)transactionsResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when get transactions by project  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{projectId}/transactions")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_CREATE, description="Cr\u00e9e une transaction")
    public Response initTransaction(TransactionDto transactionDto, @PathParam(value="projectId") String projectId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"You must supply transaction data !", (Object[])new Object[]{transactionDto});
                SanityChecker.checkParameter((String[])new String[]{projectId});
                RequestResponse transactionsResponse = client.initTransaction(transactionDto, projectId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)transactionsResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when init transactions by project  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{projectId}/upload")
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROJECT_ID_ZIP_CREATE, description="Verser une archive arborescente ZIP \u00e0 un projet de versement automatique sans transaction")
    @Beta
    public Response uploadZipToProject(@PathParam(value="projectId") String projectId, InputStream inputStreamObject, @HeaderParam(value="X-Encoding") @Nullable String encoding) {
        Response response;
        block14: {
            try {
                SanityChecker.checkParameter((String[])new String[]{projectId});
                ParametersChecker.checkParameter((String)"You must supply a body!", (Object[])new Object[]{inputStreamObject});
                if (Objects.nonNull(encoding)) {
                    SanityChecker.checkParameter((String[])new String[]{encoding});
                    if (!Charset.isSupported(encoding)) {
                        return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)("Unsupported encoding " + encoding));
                    }
                }
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error("Cannot validate request", e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                String transactionId = client.uploadZipToProject(projectId, inputStreamObject, encoding);
                RequestResponseOK transactionsResponse = new RequestResponseOK().addResult((Object)transactionId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)transactionsResponse).build();
                if (client == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CollectInternalClientInvalidRequestException e) {
                    LOGGER.error("Error when uploading Zip to project - BAD REQUEST ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (CollectInternalClientNotFoundException e) {
                    LOGGER.error("Error when uploading Zip to project", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when uploading Zip to project", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }
}

