/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.rest;

import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.external.external.rest.CollectExternalConfiguration;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.CollectInternalClientFactory;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AutomaticIngestThread
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AutomaticIngestThread.class);
    private static final Integer TENANT_ID = 1;
    private final CollectInternalClientFactory collectInternalClientFactory = CollectInternalClientFactory.getInstance();
    private final int threadPoolSize;
    private static final int INITIAL_DELAY = 5;

    public AutomaticIngestThread(CollectExternalConfiguration collectExternalConfiguration) {
        this.threadPoolSize = collectExternalConfiguration.getIngestionThreadPoolSize();
        long delay = collectExternalConfiguration.getIngestionThreadFrequencySeconds();
        Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()).scheduleAtFixedRate(this, Math.min(5L, delay), delay, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            LOGGER.error("Error when executing threads:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws VitamClientException {
        Thread.currentThread().setName(AutomaticIngestThread.class.getName());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)this.threadPoolSize);
        try (CollectInternalClient client = this.collectInternalClientFactory.getClient();){
            RequestResponse requestResponse = client.getTransactionsToAutomaticallyIngest();
            List results = ((RequestResponseOK)requestResponse).getResults();
            if (results.isEmpty()) {
                return;
            }
            Map<String, Integer> transactionsModel = results.stream().collect(Collectors.toMap(transactionNode -> transactionNode.get("#id").asText(), transactionNode -> Integer.parseInt(transactionNode.get("#tenant").asText())));
            ArrayList<CompletableFuture<Void>> completableFuturesList = new ArrayList<CompletableFuture<Void>>();
            for (Map.Entry<String, Integer> transaction : transactionsModel.entrySet()) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                    Thread.currentThread().setName(AutomaticIngestThread.class.getName() + "-" + (String)transaction.getKey());
                    VitamThreadUtils.getVitamSession().setTenantId((Integer)transaction.getValue());
                    try {
                        this.generateAndSendSip((String)transaction.getKey(), (Integer)transaction.getValue());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error when sending transaction:", (Throwable)e);
                    }
                }, executorService);
                completableFuturesList.add(completableFuture);
            }
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(completableFuturesList.toArray(new CompletableFuture[0]));
            combinedFuture.join();
        }
        finally {
            executorService.shutdown();
        }
    }

    private void generateAndSendSip(String transactionId, Integer tenantId) throws IOException {
        try (CollectInternalClient client = CollectInternalClientFactory.getInstance().getClient();
             IngestExternalClient ingestExternalClient = IngestExternalClientFactory.getInstance().getClient();
             InputStream inputStream = client.generateSip(transactionId);){
            RequestResponse ingest = ingestExternalClient.ingest(new VitamContext(tenantId), inputStream, Contexts.DEFAULT_WORKFLOW.name(), ProcessAction.RESUME.name());
            client.attachVitamOperationId(transactionId, ingest.getHeaderString("X-Request-Id"));
            client.changeTransactionStatus(transactionId, TransactionStatus.SENT);
            LOGGER.info(ingest.toString());
        }
        catch (VitamClientException | IngestExternalException e) {
            LOGGER.error("Error during chunk processing", e);
        }
    }
}

