/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.client;

import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.CollectInternalClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class CollectInternalClientFactory
extends VitamClientFactory<CollectInternalClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectInternalClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "collect-internal-client.conf";
    private static final String RESOURCE_PATH = "/collect-internal/v1";
    private static final CollectInternalClientFactory COLLECT_CLIENT_FACTORY = new CollectInternalClientFactory();

    protected CollectInternalClientFactory() {
        super(CollectInternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static CollectInternalClientFactory getInstance() {
        return COLLECT_CLIENT_FACTORY;
    }

    static ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public static void changeMode(String configurationFile) {
        ClientConfiguration configuration = CollectInternalClientFactory.changeConfigurationFile(configurationFile);
        CollectInternalClientFactory.getInstance().initialisation(configuration, CollectInternalClientFactory.getInstance().getResourcePath());
    }

    static void changeMode(ClientConfiguration configuration) {
        CollectInternalClientFactory.getInstance().initialisation(configuration, CollectInternalClientFactory.getInstance().getResourcePath());
    }

    public CollectInternalClient getClient() {
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new CollectInternalClientRest((VitamClientFactoryInterface<?>)this);
            case VitamClientFactoryInterface.VitamClientType.MOCK -> throw new IllegalStateException("Unsupported MOCK mode");
            default -> throw new IllegalArgumentException("Collect client type unknown");
        };
    }
}

