/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagetraceability;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.timestamp.TimestampGenerator;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.common.traceability.TraceabilityService;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.driver.model.StorageLogTraceabilityResult;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.storagetraceability.LogbookStorageTraceabilityHelper;
import fr.gouv.vitam.storage.engine.server.storagetraceability.TraceabilityStorageService;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class StorageTraceabilityAdministration {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageTraceabilityAdministration.class);
    private static final int MIN_THREAD_POOL_SIZE = 1;
    private final AlertService alertService = new AlertServiceImpl();
    private final TraceabilityStorageService traceabilityLogbookService;
    private final StorageDistribution distribution;
    private final LogbookOperationsClient logbookOperations;
    private final WorkspaceClient workspaceClient;
    private final TimestampGenerator timestampGenerator;
    private final int operationTraceabilityOverlapDelayInSeconds;
    private final int storageLogTraceabilityThreadPoolSize;
    private final File tmpFolder;

    public StorageTraceabilityAdministration(TraceabilityStorageService traceabilityLogbookService, StorageDistribution distribution, String tmpFolder, TimestampGenerator timestampGenerator, Integer operationTraceabilityOverlapDelay, int storageLogTraceabilityThreadPoolSize) {
        this.traceabilityLogbookService = traceabilityLogbookService;
        this.distribution = distribution;
        this.timestampGenerator = timestampGenerator;
        this.workspaceClient = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM).getClient();
        this.logbookOperations = LogbookOperationsClientFactory.getInstance().getClient();
        this.operationTraceabilityOverlapDelayInSeconds = this.validateAndGetTraceabilityOverlapDelay(operationTraceabilityOverlapDelay);
        this.storageLogTraceabilityThreadPoolSize = storageLogTraceabilityThreadPoolSize;
        this.tmpFolder = new File(tmpFolder);
        if (!this.tmpFolder.exists() && !this.tmpFolder.mkdirs()) {
            throw new VitamFatalRuntimeException("Could not initialize temp folder " + tmpFolder);
        }
    }

    @VisibleForTesting
    public StorageTraceabilityAdministration(TraceabilityStorageService traceabilityLogbookService, StorageDistribution distribution, LogbookOperationsClient mockedLogbookOperations, File tmpFolder, WorkspaceClient mockedWorkspaceClient, TimestampGenerator timestampGenerator, Integer operationTraceabilityOverlapDelay, int storageLogTraceabilityThreadPoolSize) {
        this.traceabilityLogbookService = traceabilityLogbookService;
        this.distribution = distribution;
        this.logbookOperations = mockedLogbookOperations;
        this.timestampGenerator = timestampGenerator;
        this.workspaceClient = mockedWorkspaceClient;
        this.operationTraceabilityOverlapDelayInSeconds = this.validateAndGetTraceabilityOverlapDelay(operationTraceabilityOverlapDelay);
        ParametersChecker.checkValue((String)"Traceability thread pool size", (long)storageLogTraceabilityThreadPoolSize, (long)1L);
        this.storageLogTraceabilityThreadPoolSize = storageLogTraceabilityThreadPoolSize;
        this.tmpFolder = tmpFolder;
    }

    private int validateAndGetTraceabilityOverlapDelay(Integer operationTraceabilityOverlapDelay) {
        if (operationTraceabilityOverlapDelay == null) {
            return 0;
        }
        if (operationTraceabilityOverlapDelay < 0) {
            throw new IllegalArgumentException("Operation traceability overlap delay cannot be negative");
        }
        return operationTraceabilityOverlapDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageLogTraceabilityResult> generateStorageLogTraceabilityOperations(String strategyId, List<Integer> tenants) throws TraceabilityException {
        int threadPoolSize = Math.min(this.storageLogTraceabilityThreadPoolSize, tenants.size());
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)threadPoolSize);
        try {
            ArrayList<CompletableFuture<StorageLogTraceabilityResult>> completableFutures = new ArrayList<CompletableFuture<StorageLogTraceabilityResult>>();
            for (Integer tenantId : tenants) {
                CompletableFuture<StorageLogTraceabilityResult> traceabilityCompletableFuture = CompletableFuture.supplyAsync(() -> this.generateTraceabilityStorageLogbook(strategyId, tenantId), executorService);
                completableFutures.add(traceabilityCompletableFuture);
            }
            boolean allTenantsSucceeded = true;
            ArrayList<StorageLogTraceabilityResult> results = new ArrayList<StorageLogTraceabilityResult>();
            for (CompletableFuture completableFuture : completableFutures) {
                try {
                    results.add((StorageLogTraceabilityResult)completableFuture.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TraceabilityException("Storage log traceability interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOGGER.error("Storage log traceability failed", (Throwable)e);
                    allTenantsSucceeded = false;
                }
            }
            if (!allTenantsSucceeded) {
                throw new TraceabilityException("One or more storage log traceability operations failed");
            }
            ArrayList<StorageLogTraceabilityResult> arrayList = results;
            return arrayList;
        }
        finally {
            executorService.shutdown();
        }
    }

    private StorageLogTraceabilityResult generateTraceabilityStorageLogbook(String strategyId, Integer tenantId) {
        Thread.currentThread().setName("StorageLogTraceability-" + tenantId);
        VitamThreadUtils.getVitamSession().setTenantId(tenantId);
        GUID requestId = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        VitamThreadUtils.getVitamSession().setRequestId(requestId);
        try {
            LogbookStorageTraceabilityHelper traceabilityHelper = new LogbookStorageTraceabilityHelper(this.logbookOperations, this.workspaceClient, this.traceabilityLogbookService, this.distribution, requestId, this.operationTraceabilityOverlapDelayInSeconds);
            TraceabilityService service = new TraceabilityService(this.timestampGenerator, (LogbookTraceabilityHelper)traceabilityHelper, tenantId, this.tmpFolder);
            service.secureData(strategyId);
            return new StorageLogTraceabilityResult().setTenantId(tenantId).setOperationId(requestId.getId());
        }
        catch (Exception e) {
            this.alertService.createAlert(VitamLogLevel.ERROR, "An error occurred during storage log traceability for tenant " + tenantId);
            throw new RuntimeException("An error occurred during storage log traceability for tenant " + tenantId, e);
        }
    }
}

