/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogStructure;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookOutcome;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameterName;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AccessLogParameters
implements StorageLogStructure {
    private static final String MANDATORY_PARAMETER_CAN_NOT_BE_NULL_OR_EMPTY = "Mandatory parameters can not be null or empty";
    private static final Set<StorageLogbookParameterName> mandatoryParameters = new HashSet<StorageLogbookParameterName>();
    @JsonIgnore
    private final Map<StorageLogbookParameterName, String> mapParameters = new TreeMap<StorageLogbookParameterName, String>();

    public AccessLogParameters(Map<StorageLogbookParameterName, String> mapParameters) {
        this.mapParameters.putAll(mapParameters);
        this.checkMandatoryParameters();
    }

    @JsonIgnore
    public AccessLogParameters setStatus(StorageLogbookOutcome outcome) {
        this.mapParameters.put(StorageLogbookParameterName.outcome, outcome.name());
        return this;
    }

    @JsonIgnore
    public StorageLogbookOutcome getStatus() {
        String status = this.mapParameters.get((Object)StorageLogbookParameterName.outcome);
        return StorageLogbookOutcome.valueOf(status);
    }

    public void checkMandatoryParameters() throws IllegalArgumentException {
        for (StorageLogbookParameterName s : mandatoryParameters) {
            ParametersChecker.checkParameter((String)MANDATORY_PARAMETER_CAN_NOT_BE_NULL_OR_EMPTY, (String[])new String[]{this.mapParameters.get((Object)s)});
        }
    }

    @Override
    @JsonIgnore
    public Map<StorageLogbookParameterName, String> getMapParameters() {
        return this.mapParameters;
    }
}

