/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.server.storagelog.LogInformation;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogAppender;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.AccessLogParameters;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogStructure;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameters;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StorageLogService
implements StorageLog {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageLogService.class);
    private static final String FILENAME_PATTERN_CREATION_DATE_GROUP = "CreationDate";
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^\\d+_(?<CreationDate>\\d+)_.*$");
    public static final String WRITE_LOG_DIR = "storage-log";
    public static final String ACCESS_LOG_DIR = "access-log";
    private static final String WRITE_LOG_BACKUP_FILENAME = "storage_logbook";
    private static final String ACCESS_LOG_BACKUP_FILENAME = "storage_access_logbook";
    private static final String PARAMS_CANNOT_BE_NULL = "Params cannot be null";
    private final List<Integer> tenants;
    private final Path writeOperationLogPath;
    private final Path accessOperationLogPath;
    private final Map<Integer, StorageLogAppender> writeOperationLogAppenders;
    private final Map<Integer, StorageLogAppender> accessOperationLogAppenders;
    private final Map<Integer, Object> writeLockers;
    private final Map<Integer, Object> accessLockers;

    public StorageLogService(List<Integer> tenants, Path basePath) throws IOException {
        ParametersChecker.checkParameter((String)PARAMS_CANNOT_BE_NULL, (Object[])new Object[]{tenants, basePath});
        this.tenants = tenants;
        this.writeOperationLogPath = this.createStoragePathDirectory(basePath, true);
        this.accessOperationLogPath = this.createStoragePathDirectory(basePath, false);
        this.writeOperationLogAppenders = new HashMap<Integer, StorageLogAppender>();
        this.accessOperationLogAppenders = new HashMap<Integer, StorageLogAppender>();
        this.writeLockers = new HashMap<Integer, Object>();
        this.accessLockers = new HashMap<Integer, Object>();
        this.initializeStorageLogs();
    }

    private Path createStoragePathDirectory(Path basePath, Boolean isWriteOperation) throws IOException {
        Path storageLogPath = isWriteOperation != false ? basePath.resolve(WRITE_LOG_DIR) : basePath.resolve(ACCESS_LOG_DIR);
        if (!Files.exists(storageLogPath, new LinkOption[0])) {
            Files.createDirectories(storageLogPath, new FileAttribute[0]);
        }
        this.checkExistingStorageLogFiles(storageLogPath);
        return storageLogPath;
    }

    private void checkExistingStorageLogFiles(Path storageLogPath) throws IOException {
        try (Stream<Path> list = Files.list(storageLogPath);){
            List exitingFiles = list.collect(Collectors.toList());
            if (!exitingFiles.isEmpty()) {
                LOGGER.warn("Existing storage log files found: " + exitingFiles.toString());
            }
        }
    }

    private StorageLogAppender createAppender(Integer tenant, Boolean isWriteOperation) throws IOException {
        String file_name = tenant.toString() + "_" + LocalDateUtil.now().format(LocalDateUtil.getDateTimeFormatterForFileNames()) + "_" + String.valueOf(UUID.randomUUID()) + ".log";
        Path appenderPath = isWriteOperation != false ? this.writeOperationLogPath.resolve(file_name) : this.accessOperationLogPath.resolve(file_name);
        return new StorageLogAppender(appenderPath);
    }

    @Override
    public void appendWriteLog(Integer tenant, StorageLogbookParameters parameters) throws IOException {
        this.append(tenant, parameters, true);
    }

    @Override
    public void appendAccessLog(Integer tenant, AccessLogParameters parameters) throws IOException {
        this.append(tenant, parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(Integer tenant, StorageLogStructure parameters, Boolean isWriteOperation) throws IOException {
        if (isWriteOperation.booleanValue()) {
            Object object = this.writeLockers.get(tenant);
            synchronized (object) {
                this.writeOperationLogAppenders.get(tenant).append(parameters);
            }
        }
        Object object = this.accessLockers.get(tenant);
        synchronized (object) {
            this.accessOperationLogAppenders.get(tenant).append(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogInformation> rotateLogFile(Integer tenant, boolean isWriteOperation) throws IOException {
        if (isWriteOperation) {
            Object object = this.writeLockers.get(tenant);
            synchronized (object) {
                this.writeOperationLogAppenders.get(tenant).close();
                List<LogInformation> storageLogToBackup = this.listStorageLogsToBackup(tenant, isWriteOperation);
                this.writeOperationLogAppenders.put(tenant, this.createAppender(tenant, isWriteOperation));
                return storageLogToBackup;
            }
        }
        Object object = this.accessLockers.get(tenant);
        synchronized (object) {
            this.accessOperationLogAppenders.get(tenant).close();
            List<LogInformation> storageLogToBackup = this.listStorageLogsToBackup(tenant, isWriteOperation);
            this.accessOperationLogAppenders.put(tenant, this.createAppender(tenant, isWriteOperation));
            return storageLogToBackup;
        }
    }

    @Override
    public void initializeStorageLogs() throws IOException {
        for (Integer tenant : this.tenants) {
            this.writeOperationLogAppenders.put(tenant, this.createAppender(tenant, true));
            this.accessOperationLogAppenders.put(tenant, this.createAppender(tenant, false));
        }
        for (Integer tenant : this.tenants) {
            this.writeLockers.put(tenant, new Object());
            this.accessLockers.put(tenant, new Object());
        }
    }

    private List<LogInformation> listStorageLogsToBackup(Integer tenant, Boolean isWriteOperation) throws IOException {
        LocalDateTime now = LocalDateUtil.now();
        ArrayList<LogInformation> previousLogFiles = new ArrayList<LogInformation>();
        Path path = isWriteOperation != false ? this.writeOperationLogPath : this.accessOperationLogPath;
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(path, tenant + "_*.log");){
                for (Path filePath : paths) {
                    String filename = filePath.getFileName().toString();
                    Optional<LocalDateTime> localDateTime = this.tryParseCreationDateFromFileName(filename);
                    if (!localDateTime.isPresent()) {
                        LOGGER.warn("Invalid storage log filename '" + filename + "'");
                        continue;
                    }
                    previousLogFiles.add(new LogInformation(filePath, localDateTime.get(), now));
                }
            }
        }
        return previousLogFiles;
    }

    private Optional<LocalDateTime> tryParseCreationDateFromFileName(String filename) {
        Matcher matcher = FILENAME_PATTERN.matcher(filename);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String creationDateStr = matcher.group(FILENAME_PATTERN_CREATION_DATE_GROUP);
        try {
            LocalDateTime creationDate = LocalDateUtil.parse((String)creationDateStr, (DateTimeFormatter)LocalDateUtil.getDateTimeFormatterForFileNames());
            return Optional.of(creationDate);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Invalid creation date in storage log filename '" + filename + "'", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    public String getFileName(boolean isWriteOperation) {
        if (isWriteOperation) {
            return WRITE_LOG_BACKUP_FILENAME;
        }
        return ACCESS_LOG_BACKUP_FILENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        for (Integer tenant : this.tenants) {
            Object object = this.writeLockers.get(tenant);
            synchronized (object) {
                this.writeOperationLogAppenders.get(tenant).close();
            }
            object = this.accessLockers.get(tenant);
            synchronized (object) {
                this.accessOperationLogAppenders.get(tenant).close();
            }
        }
    }
}

