/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.driver.model.StorageLogBackupResult;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.storagelog.LogInformation;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class StorageLogAdministration {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageLogAdministration.class);
    public static final String STORAGE_WRITE_BACKUP = "STORAGE_BACKUP";
    public static final String STORAGE_ACCESS_BACKUP = "STORAGE_ACCESS_BACKUP";
    private final WorkspaceClientFactory workspaceClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final AlertService alertService = new AlertServiceImpl();
    private final StorageLog storageLogService;
    private final int storageLogBackupThreadPoolSize;
    private final StorageDistribution distribution;

    public StorageLogAdministration(StorageLog storageLogService, StorageDistribution distribution, StorageConfiguration configuration) {
        this(storageLogService, distribution, configuration, WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    public StorageLogAdministration(StorageLog storageLogService, StorageDistribution distribution, StorageConfiguration configuration, WorkspaceClientFactory workspaceClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.storageLogService = storageLogService;
        this.distribution = distribution;
        this.workspaceClientFactory = workspaceClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.storageLogBackupThreadPoolSize = configuration.getStorageLogBackupThreadPoolSize();
    }

    public List<StorageLogBackupResult> backupStorageWriteLog(String strategyId, List<Integer> tenants) throws StorageLogException {
        return this.backupStorageLog(strategyId, (Boolean)true, tenants);
    }

    public List<StorageLogBackupResult> backupStorageAccessLog(String strategyId, List<Integer> tenants) throws StorageLogException {
        return this.backupStorageLog(strategyId, (Boolean)false, tenants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<StorageLogBackupResult> backupStorageLog(String strategyId, Boolean backupWriteLog, List<Integer> tenants) throws StorageLogException {
        String operationType = backupWriteLog != false ? "StorageWriteLog" : "StorageAccessLog";
        int threadPoolSize = Math.min(this.storageLogBackupThreadPoolSize, tenants.size());
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)threadPoolSize);
        try {
            ArrayList<CompletableFuture<StorageLogBackupResult>> completableFutures = new ArrayList<CompletableFuture<StorageLogBackupResult>>();
            for (Integer tenantId : tenants) {
                CompletableFuture<StorageLogBackupResult> traceabilityCompletableFuture = CompletableFuture.supplyAsync(() -> {
                    Thread.currentThread().setName(operationType + "-" + tenantId);
                    VitamThreadUtils.getVitamSession().setTenantId(tenantId);
                    try {
                        String operationId = this.backupStorageLog(strategyId, backupWriteLog, tenantId);
                        return new StorageLogBackupResult().setTenantId(tenantId).setOperationId(operationId);
                    }
                    catch (Exception e) {
                        this.alertService.createAlert(VitamLogLevel.ERROR, "An error occurred during " + operationType + " for tenant " + tenantId);
                        throw new RuntimeException("An error occurred during " + operationType + " for tenant " + tenantId);
                    }
                }, executorService);
                completableFutures.add(traceabilityCompletableFuture);
            }
            boolean allTenantsSucceeded = true;
            ArrayList<StorageLogBackupResult> results = new ArrayList<StorageLogBackupResult>();
            for (CompletableFuture completableFuture : completableFutures) {
                try {
                    results.add((StorageLogBackupResult)completableFuture.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new StorageLogException(operationType + " interrupted", e);
                }
                catch (ExecutionException e) {
                    LOGGER.error(operationType + " failed", (Throwable)e);
                    allTenantsSucceeded = false;
                }
            }
            if (!allTenantsSucceeded) {
                throw new StorageLogException("One or more " + operationType + " operations failed");
            }
            ArrayList<StorageLogBackupResult> arrayList = results;
            return arrayList;
        }
        finally {
            executorService.shutdown();
        }
    }

    private String backupStorageLog(String strategyId, Boolean backupWriteLog, int tenantId) throws IOException, StorageLogException, LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
        GUID eip = GUIDFactory.newOperationLogbookGUID((int)tenantId);
        VitamThreadUtils.getVitamSession().setRequestId(eip);
        try {
            String evType = backupWriteLog != false ? STORAGE_WRITE_BACKUP : STORAGE_ACCESS_BACKUP;
            this.createLogbookOperationStarted(helper, eip, evType);
            List<LogInformation> info = this.storageLogService.rotateLogFile(tenantId, backupWriteLog);
            for (LogInformation logInformation : info) {
                this.storeLogFile(helper, strategyId, tenantId, eip, logInformation, this.storageLogService, evType, backupWriteLog);
            }
            this.createLogbookOperationEvent(helper, eip, evType, StatusCode.OK);
            String string = eip.getId();
            return string;
        }
        catch (LogbookClientAlreadyExistsException | LogbookClientNotFoundException e) {
            throw new StorageLogException(e);
        }
        finally {
            this.logbookOperationsClientFactory.getClient().create(eip.getId(), (Iterable)helper.removeCreateDelegate(eip.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLogFile(LogbookOperationsClientHelper helper, String strategyId, Integer tenantId, GUID eip, LogInformation logInformation, StorageLog storageLogService, String evType, boolean isWriteOperation) throws LogbookClientNotFoundException, StorageLogException {
        LOGGER.info("Storing log file " + String.valueOf(logInformation.getPath()) + " -- " + isWriteOperation);
        String fileName = tenantId + "_" + storageLogService.getFileName(isWriteOperation) + "_" + logInformation.getBeginTime().format(this.getDateTimeFormatter()) + "_" + logInformation.getEndTime().format(this.getDateTimeFormatter()) + "_" + eip.toString() + ".log";
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(logInformation.getPath().toFile()));
             WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            String containerName;
            block21: {
                containerName = GUIDFactory.newGUID().toString();
                workspaceClient.createContainer(containerName);
                try {
                    workspaceClient.putObject(containerName, fileName, (InputStream)inputStream);
                    try {
                        ObjectDescription description = new ObjectDescription();
                        description.setWorkspaceContainerGUID(containerName);
                        description.setWorkspaceObjectURI(fileName);
                        this.distribution.storeDataInAllOffers(strategyId, fileName, description, isWriteOperation ? DataCategory.STORAGELOG : DataCategory.STORAGEACCESSLOG, null);
                    }
                    catch (StorageException e) {
                        LOGGER.error("unable to store log file", (Throwable)e);
                        this.createLogbookOperationEvent(helper, eip, evType, StatusCode.FATAL);
                        throw new StorageLogException(e);
                    }
                    if (Files.deleteIfExists(logInformation.getPath())) break block21;
                    LOGGER.warn("Could not delete local storage file " + String.valueOf(logInformation.getPath().toAbsolutePath()));
                }
                catch (Throwable throwable) {
                    try {
                        workspaceClient.deleteContainer(containerName, true);
                    }
                    catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
                        LOGGER.error(String.format("Unable to cleanup file from workspace %s/%s", containerName, fileName), e);
                    }
                    throw throwable;
                }
            }
            try {
                workspaceClient.deleteContainer(containerName, true);
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
                LOGGER.error(String.format("Unable to cleanup file from workspace %s/%s", containerName, fileName), e);
            }
        }
        catch (ContentAddressableStorageServerException | IOException e) {
            LOGGER.error("Unable to create container", e);
            this.createLogbookOperationEvent(helper, eip, evType, StatusCode.FATAL);
            throw new StorageLogException(e);
        }
    }

    private void createLogbookOperationStarted(LogbookOperationsClientHelper helper, GUID eip, String evType) throws LogbookClientAlreadyExistsException {
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)evType, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.STORAGE_BACKUP, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)evType, (StatusCode)StatusCode.STARTED), (GUID)eip);
        logbookOperationParameters.putParameterValue(LogbookParameterName.outcomeDetail, evType + "." + String.valueOf(StatusCode.STARTED));
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookOperationParameters);
        helper.createDelegate(logbookOperationParameters);
    }

    private void createLogbookOperationEvent(LogbookOperationsClientHelper helper, GUID parentEventId, String eventType, StatusCode statusCode) throws LogbookClientNotFoundException {
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newEventGUID((GUID)parentEventId), (String)eventType, (GUID)parentEventId, (LogbookTypeProcess)LogbookTypeProcess.STORAGE_BACKUP, (StatusCode)statusCode, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)statusCode), (GUID)parentEventId);
        logbookOperationParameters.putParameterValue(LogbookParameterName.outcomeDetail, eventType + "." + String.valueOf(statusCode));
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookOperationParameters);
        helper.updateDelegate(logbookOperationParameters);
    }

    private DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS").withZone(ZoneOffset.UTC);
    }
}

