/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.storage.engine.server.storagelog.LogInformation;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.AccessLogParameters;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameters;
import java.util.List;

public class ReadOnlyStorageLog
implements StorageLog {
    private final AlertService alertService;

    public ReadOnlyStorageLog(AlertService alertService) {
        this.alertService = alertService;
    }

    public void close() {
    }

    @Override
    public void appendWriteLog(Integer tenant, StorageLogbookParameters parameters) {
        throw this.reportIllegalAccess("Illegal operation reported on ReadOnly storage engine instance. Cannot write storage logs for tenant: " + tenant + ", parameters: " + (parameters == null ? "null" : JsonHandler.unprettyPrint((Object)parameters)));
    }

    @Override
    public void appendAccessLog(Integer tenant, AccessLogParameters parameters) {
        throw this.reportIllegalAccess("Illegal operation reported on ReadOnly storage engine instance. Cannot write access logs for tenant: " + tenant + ", parameters: " + (parameters == null ? "null" : JsonHandler.unprettyPrint((Object)parameters)));
    }

    @Override
    public List<LogInformation> rotateLogFile(Integer tenantId, boolean isWriteOperation) {
        throw this.reportIllegalAccess("Illegal operation reported on ReadOnly storage engine instance. No log files to rotate");
    }

    @Override
    public void initializeStorageLogs() {
    }

    @Override
    public String getFileName(boolean isWriteOperation) {
        throw this.reportIllegalAccess("Illegal operation reported on ReadOnly storage engine instance. No log file name available");
    }

    private IllegalStateException reportIllegalAccess(String errorMessage) {
        IllegalStateException illegalStateException = new IllegalStateException(errorMessage);
        this.alertService.createAlert(VitamLogLevel.ERROR, errorMessage, (Throwable)illegalStateException);
        return illegalStateException;
    }
}

