/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.error.DomainName;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.model.storage.ObjectEntryWriter;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.server.application.HttpHeaderHelper;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.timestamp.TimeStampSignature;
import fr.gouv.vitam.common.timestamp.TimeStampSignatureWithKeystore;
import fr.gouv.vitam.common.timestamp.TimestampGenerator;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.storage.driver.model.StorageLogBackupResult;
import fr.gouv.vitam.storage.driver.model.StorageLogTraceabilityResult;
import fr.gouv.vitam.storage.engine.common.exception.StorageAlreadyExistsException;
import fr.gouv.vitam.storage.engine.common.exception.StorageDriverNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageIllegalOperationException;
import fr.gouv.vitam.storage.engine.common.exception.StorageInconsistentStateException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.common.exception.StorageUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.request.OfferLogRequest;
import fr.gouv.vitam.storage.engine.common.model.response.BatchObjectInformationResponse;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectAvailabilityResponse;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectStoreResponse;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.distribution.impl.DataContext;
import fr.gouv.vitam.storage.engine.server.distribution.impl.StorageDistributionFactory;
import fr.gouv.vitam.storage.engine.server.distribution.impl.StreamAndInfo;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.rest.writeprotection.WriteProtection;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogAdministration;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogException;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogFactory;
import fr.gouv.vitam.storage.engine.server.storagetraceability.StorageTraceabilityAdministration;
import fr.gouv.vitam.storage.engine.server.storagetraceability.TraceabilityStorageService;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.BooleanUtils;

@Path(value="/storage/v1")
@Tag(name="Storage")
public class StorageResource
extends ApplicationStatusResource
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageResource.class);
    private static final String STORAGE_MODULE = "STORAGE";
    private static final String CODE_VITAM = "code_vitam";
    private static final String ERROR_WHEN_COPING_CONTEXT = "Error when coping context: ";
    private final StorageDistribution distribution;
    private final TraceabilityStorageService traceabilityLogbookService;
    private final TimestampGenerator timestampGenerator;
    private StorageLog storageLogService;
    private StorageLogAdministration storageLogAdministration;
    private StorageTraceabilityAdministration traceabilityLogbookAdministration;

    StorageResource(StorageConfiguration configuration) {
        try {
            TimeStampSignatureWithKeystore timeStampSignature;
            this.storageLogService = StorageLogFactory.getInstance(configuration);
            this.distribution = StorageDistributionFactory.createStorageDistribution(configuration, this.storageLogService, (AlertService)new AlertServiceImpl());
            WorkspaceClientFactory.changeMode((String)configuration.getUrlWorkspace(), (WorkspaceType)WorkspaceType.VITAM);
            this.storageLogAdministration = new StorageLogAdministration(this.storageLogService, this.distribution, configuration);
            this.traceabilityLogbookService = new TraceabilityStorageService(this.distribution);
            try {
                File file = PropertiesUtils.findFile((String)configuration.getP12LogbookFile());
                timeStampSignature = new TimeStampSignatureWithKeystore(file, configuration.getP12LogbookPassword().toCharArray());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                LOGGER.error("unable to instantiate TimeStampGenerator", (Throwable)e);
                throw new RuntimeException(e);
            }
            this.timestampGenerator = new TimestampGenerator((TimeStampSignature)timeStampSignature);
            this.traceabilityLogbookAdministration = new StorageTraceabilityAdministration(this.traceabilityLogbookService, this.distribution, configuration.getZippingDirecorty(), this.timestampGenerator, configuration.getStorageTraceabilityOverlapDelay(), configuration.getStorageLogTraceabilityThreadPoolSize());
            LOGGER.info("init Storage Resource server");
        }
        catch (IOException e) {
            LOGGER.error("Cannot initialize storage resource server, error when reading configuration file");
            throw new RuntimeException(e);
        }
        catch (StorageTechnicalException e) {
            LOGGER.error("A problem occured when checking strategy offers in Storage");
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    StorageResource(StorageDistribution storageDistribution, TimestampGenerator timestampGenerator) {
        this.distribution = storageDistribution;
        this.traceabilityLogbookService = new TraceabilityStorageService(this.distribution);
        this.timestampGenerator = timestampGenerator;
    }

    @Path(value="/copy/{id_object}")
    @POST
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response copy(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_object") String objectId) {
        DataCategory category;
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.X_CONTENT_SOURCE, VitamHttpHeader.X_CONTENT_DESTINATION, VitamHttpHeader.X_DATA_CATEGORY);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        String remoteAddress = httpServletRequest.getRemoteAddr();
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String source = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.X_CONTENT_SOURCE).get(0);
        String destination = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.X_CONTENT_DESTINATION).get(0);
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        try {
            category = this.getDataCategory(headers);
        }
        catch (IllegalArgumentException e) {
            return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
        }
        DataContext context = new DataContext(objectId, category, remoteAddress, tenantId, strategyId);
        try {
            StoredInfoResult storedInfoResult = this.distribution.copyObjectFromOfferToOffer(context, source, destination);
            return Response.ok().entity((Object)storedInfoResult).build();
        }
        catch (StorageUnavailableDataFromAsyncOfferException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildCustomErrorResponse(CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER, exc.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(ERROR_WHEN_COPING_CONTEXT + String.valueOf(context), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="/create/{id_operation}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response create(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_operation") String operationId, InputStream inputStream) {
        DataCategory category;
        String remoteAddress = httpServletRequest.getRemoteAddr();
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.X_CONTENT_LENGTH, VitamHttpHeader.X_DATA_CATEGORY, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.OFFERS_IDS);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        Long size = Long.valueOf((String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.X_CONTENT_LENGTH).get(0));
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        try {
            category = this.getDataCategory(headers);
        }
        catch (IllegalArgumentException e) {
            return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
        }
        StreamAndInfo streamAndInfo = new StreamAndInfo(inputStream, size);
        try {
            String listOffer = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFERS_IDS).get(0);
            List<String> offerIds = Arrays.asList(listOffer.split(","));
            StoredInfoResult storedInfoResult = this.distribution.storeDataInOffers(strategyId, "normal", streamAndInfo, operationId, category, remoteAddress, offerIds);
            Response response = Response.ok().entity((Object)storedInfoResult).build();
            streamAndInfo.close();
            return response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    streamAndInfo.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (StorageException e) {
                LOGGER.error((Throwable)e);
                return this.buildErrorResponse(VitamCode.STORAGE_NOT_FOUND);
            }
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response getStorageInformation(@Context HttpHeaders headers) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        try {
            JsonNode result = this.distribution.getContainerInformation(strategyId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (StorageNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_NOT_FOUND;
        }
        catch (StorageException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR;
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_BAD_REQUEST;
        }
        return this.buildErrorResponse(vitamCode);
    }

    @Path(value="/{type:UNIT|OBJECT|OBJECTGROUP|LOGBOOK|REPORT|MANIFEST|PROFILE|STORAGELOG|STORAGEACCESSLOG|STORAGETRACEABILITY|RULES|DIP|AGENCIES|BACKUP|BACKUP_OPERATION|CHECKLOGBOOKREPORTS|OBJECTGROUP_GRAPH|UNIT_GRAPH|DISTRIBUTIONREPORTS|ACCESSION_REGISTER_DETAIL|ACCESSION_REGISTER_SYMBOLIC}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=false)
    public Response listObjects(@Context HttpHeaders headers, @PathParam(value="type") DataCategory type) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        try {
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            List offerIdHeaders = Optional.of(HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER)).orElse(Collections.emptyList());
            CloseableIterator<ObjectEntry> objectEntryIterator = offerIdHeaders.isEmpty() ? this.distribution.listContainerObjects(strategyId, type) : this.distribution.listContainerObjectsForOffer(type, (String)offerIdHeaders.get(0), false);
            StreamingOutput streamingOutput = output -> {
                try (CloseShieldOutputStream closeShieldOutputStream = CloseShieldOutputStream.wrap((OutputStream)output);
                     ObjectEntryWriter objectEntryWriter = new ObjectEntryWriter((OutputStream)closeShieldOutputStream);){
                    while (objectEntryIterator.hasNext()) {
                        objectEntryWriter.write((ObjectEntry)objectEntryIterator.next());
                    }
                    objectEntryWriter.writeEof();
                }
                catch (Exception e) {
                    String msg = "Could not read object listing";
                    LOGGER.error(msg, (Throwable)e);
                    throw new WebApplicationException(msg, (Throwable)e);
                }
                finally {
                    objectEntryIterator.close();
                }
            };
            return Response.ok((Object)streamingOutput).build();
        }
        catch (StorageDriverNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_CONTAINER_NOT_FOUND);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
        }
        catch (Exception exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @Path(value="/{type:UNIT|OBJECT|OBJECTGROUP|LOGBOOK|REPORT|MANIFEST|PROFILE|STORAGELOG|STORAGETRACEABILITY|RULES|DIP|AGENCIES|BACKUP|BACKUP_OPERATION|CHECKLOGBOOKREPORTS|OBJECTGROUP_GRAPH|UNIT_GRAPH|DISTRIBUTIONREPORTS|ACCESSION_REGISTER_DETAIL|ACCESSION_REGISTER_SYMBOLIC}/logs")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=false)
    public Response getOfferLogs(@Context HttpHeaders headers, @PathParam(value="type") DataCategory type, OfferLogRequest offerLogRequest) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        try {
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            List offerIdHeaders = Optional.of(HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER)).orElse(Collections.emptyList());
            RequestResponse<OfferLog> jsonNodeRequestResponse = CollectionUtils.isNotEmpty(offerIdHeaders) ? this.distribution.getOfferLogsByOfferId(strategyId, (String)offerIdHeaders.get(0), type, offerLogRequest.getOffset(), offerLogRequest.getLimit(), offerLogRequest.getOrder()) : this.distribution.getOfferLogs(strategyId, type, offerLogRequest.getOffset(), offerLogRequest.getLimit(), offerLogRequest.getOrder());
            return jsonNodeRequestResponse.toResponse();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.STORAGE_BAD_REQUEST, null).toResponse();
        }
        catch (Exception exc) {
            LOGGER.error((Throwable)exc);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, null).toResponse();
        }
    }

    @Path(value="/info/{type}/{id_object}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=false)
    public Response getInformation(@Context HttpHeaders headers, @PathParam(value="type") String typeStr, @PathParam(value="id_object") String objectId) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.OFFERS_IDS, VitamHttpHeader.OFFER_NO_CACHE);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        DataCategory type = DataCategory.getByCollectionName((String)typeStr);
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        String listOffer = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFERS_IDS).get(0);
        List<String> offerIds = Arrays.asList(listOffer.split(","));
        boolean noCache = Boolean.parseBoolean((String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER_NO_CACHE).get(0));
        try {
            JsonNode offerMetadataInfo = this.distribution.getContainerInformation(strategyId, type, objectId, offerIds, noCache);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)offerMetadataInfo).build();
        }
        catch (StorageException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_NOT_FOUND);
        }
    }

    @Path(value="/batch_info/{type}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=false)
    public Response getBatchObjectInformation(@Context HttpHeaders headers, @PathParam(value="type") String typeStr, List<String> objectIds) {
        List<BatchObjectInformationResponse> objectInformationResponses;
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.OFFERS_IDS);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        DataCategory type = DataCategory.getByCollectionName((String)typeStr);
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        String listOffer = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFERS_IDS).get(0);
        List<String> offerIds = Arrays.asList(listOffer.split(","));
        try {
            objectInformationResponses = this.distribution.getBatchObjectInformation(strategyId, type, objectIds, offerIds);
        }
        catch (StorageException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(objectInformationResponses)).build();
    }

    @Path(value="/objects/{id_object}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getObject(@Context HttpHeaders headers, @PathParam(value="id_object") String objectId, AccessLogInfoModel logInfo) {
        return this.getObject(headers, objectId, DataCategory.OBJECT, logInfo);
    }

    private Response getObject(HttpHeaders headers, String objectId, DataCategory dataCategory, AccessLogInfoModel accessLogInfoModel) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        List offerIdHeaders = Optional.of(HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER)).orElse(Collections.emptyList());
        try {
            if (CollectionUtils.isEmpty(offerIdHeaders)) {
                return new VitamAsyncInputStreamResponse(this.getByCategory(objectId, dataCategory, strategyId, vitamCode, accessLogInfoModel), Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            }
            return new VitamAsyncInputStreamResponse(this.getByCategory(objectId, dataCategory, strategyId, vitamCode, (String)offerIdHeaders.get(0)), Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        }
        catch (StorageNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_NOT_FOUND;
        }
        catch (StorageUnavailableDataFromAsyncOfferException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildCustomErrorResponse(CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER, exc.getMessage());
        }
        catch (StorageException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR;
        }
        return this.buildErrorResponse(vitamCode);
    }

    @Path(value="/backup/{backupfile}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getBackupFile(@Context HttpHeaders headers, @PathParam(value="backupfile") String backupfile) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        try {
            Response response;
            if (HttpHeaderHelper.hasValuesFor((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER)) {
                String offerId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER).get(0);
                response = this.getByCategory(backupfile, DataCategory.BACKUP, strategyId, vitamCode, offerId);
            } else {
                response = this.getByCategory(backupfile, DataCategory.BACKUP, strategyId, vitamCode, AccessLogUtils.getNoLogAccessLog());
            }
            return new VitamAsyncInputStreamResponse(response, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        }
        catch (StorageNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_NOT_FOUND;
        }
        catch (StorageUnavailableDataFromAsyncOfferException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildCustomErrorResponse(CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER, exc.getMessage());
        }
        catch (StorageException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR;
        }
        return this.buildErrorResponse(vitamCode);
    }

    private Response getByCategory(String objectId, DataCategory category, String strategyId, VitamCode vitamCode, AccessLogInfoModel logInformation) throws StorageException {
        if (vitamCode == null) {
            return this.distribution.getContainerByCategory(strategyId, "normal", objectId, category, logInformation);
        }
        return this.buildErrorResponse(vitamCode);
    }

    private Response getByCategory(String objectId, DataCategory category, String strategyId, VitamCode vitamCode, String offerId) throws StorageException {
        if (vitamCode == null) {
            return this.distribution.getContainerByCategory(strategyId, "normal", objectId, category, offerId);
        }
        return this.buildErrorResponse(vitamCode);
    }

    @Path(value="/objects/{id_object}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createObject(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_object") String objectId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, objectId, createObjectDescription, DataCategory.OBJECT, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/backupoperations/{id_operation}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response createOrUpdateBackupOperation(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_operation") String operationId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, operationId, createObjectDescription, DataCategory.BACKUP_OPERATION, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/storageaccesslog/{storageaccesslogfile}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getAccessLogFile(@Context HttpHeaders headers, @PathParam(value="storageaccesslogfile") String storageAccessLogFile) {
        return this.getObject(headers, storageAccessLogFile, DataCategory.STORAGEACCESSLOG, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/storagelog/{storagelogfile}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getStorageLogFile(@Context HttpHeaders headers, @PathParam(value="storagelogfile") String storageAccessLogFile) {
        return this.getObject(headers, storageAccessLogFile, DataCategory.STORAGELOG, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/offers")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response getOffers(@HeaderParam(value="X-Strategy-Id") String strategyId) {
        try {
            List<String> offerIds = this.distribution.getOfferIds(strategyId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonHandler.toJsonNode(offerIds)).build();
        }
        catch (InvalidParseOperationException | StorageException e) {
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @Path(value="/referentOffer")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response getReferentOffer(@HeaderParam(value="X-Strategy-Id") String strategyId) {
        try {
            RequestResponseOK entity = new RequestResponseOK().addResult((Object)this.distribution.getReferentOffer(strategyId));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
        }
        catch (StorageException e) {
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @Path(value="/backupoperations/{id_operation}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getBackupOperation(@Context HttpHeaders headers, @PathParam(value="id_operation") String operationId) {
        return this.getObject(headers, operationId, DataCategory.BACKUP_OPERATION, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/delete/{id_object}")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response deleteObject(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_object") String objectId) {
        DataCategory category;
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.X_DATA_CATEGORY);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        try {
            category = this.getDataCategory(headers);
        }
        catch (IllegalArgumentException e) {
            return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
        }
        if (!category.canDelete()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorEntity(Response.Status.UNAUTHORIZED, Response.Status.UNAUTHORIZED.getReasonPhrase())).build();
        }
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        try {
            DataContext context = new DataContext(objectId, category, httpServletRequest.getRemoteHost(), ParameterHelper.getTenantParameter(), strategyId);
            List headerValues = headers.getRequestHeader("X-Offer-Ids");
            if (headerValues == null || headerValues.isEmpty()) {
                this.distribution.deleteObjectInAllOffers(strategyId, context);
            } else {
                this.distribution.deleteObjectInOffers(strategyId, context, Arrays.asList(((String)headerValues.get(0)).split(",")));
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (StorageNotFoundException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_NOT_FOUND);
        }
        catch (StorageException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST);
        }
    }

    private DataCategory getDataCategory(@Context HttpHeaders headers) {
        String dataCategoryString = headers.getHeaderString("X-Data-Category");
        if (dataCategoryString == null || dataCategoryString.isEmpty()) {
            throw new IllegalArgumentException("category connot be empty or null ");
        }
        DataCategory category = DataCategory.valueOf((String)dataCategoryString);
        return category;
    }

    @Path(value="/{type:UNIT|OBJECT|OBJECTGROUP|LOGBOOK|REPORT|MANIFEST|PROFILE|STORAGELOG|STORAGETRACEABILITY|RULES|DIP|AGENCIES|BACKUP|BACKUP_OPERATION|CHECKLOGBOOKREPORTS|OBJECTGROUP_GRAPH|UNIT_GRAPH|DISTRIBUTIONREPORTS|ACCESSION_REGISTER_DETAIL|ACCESSION_REGISTER_SYMBOLIC}/{id_object}")
    @HEAD
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=false)
    public Response checkObject(@Context HttpHeaders headers, @PathParam(value="type") DataCategory type, @PathParam(value="id_object") String objectId) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.OFFERS_IDS);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        String listOffer = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFERS_IDS).get(0);
        List<String> offerIds = Arrays.asList(listOffer.split(","));
        try {
            Map<String, Boolean> resultByOffer = this.distribution.checkObjectExisting(strategyId, objectId, type, offerIds);
            Response.ResponseBuilder responseBuilder = resultByOffer.containsValue(Boolean.FALSE) ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.status((Response.Status)Response.Status.NO_CONTENT);
            resultByOffer.entrySet().forEach(entry -> responseBuilder.header((String)entry.getKey(), (Object)BooleanUtils.toStringTrueFalse((Boolean)((Boolean)entry.getValue()))));
            return responseBuilder.build();
        }
        catch (StorageException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @Path(value="/logbooks/{id_logbook}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getLogbookStream(@Context HttpHeaders headers, @PathParam(value="id_logbook") String objectId) {
        return this.getObject(headers, objectId, DataCategory.LOGBOOK, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/logbooks/{id_logbook}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createLogbook(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_logbook") String logbookId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, logbookId, createObjectDescription, DataCategory.LOGBOOK, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/units/{id_md}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getUnit(@Context HttpHeaders headers, @PathParam(value="id_md") String unitId) {
        return this.getObject(headers, unitId, DataCategory.UNIT, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/units/{id_md}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createUnitMetadata(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_md") String metadataId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, metadataId, createObjectDescription, DataCategory.UNIT, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/objectgroups/{id_md}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getObjectGroup(@Context HttpHeaders headers, @PathParam(value="id_md") String metadataId) {
        return this.getObject(headers, metadataId, DataCategory.OBJECTGROUP, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/objectgroups/{id_md}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createObjectGroup(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_md") String metadataId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, metadataId, createObjectDescription, DataCategory.OBJECTGROUP, httpServletRequest.getRemoteAddr());
    }

    @POST
    @Path(value="/archivaltransferreply/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response storeArchivalTransferReply(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id") String id, ObjectDescription description) {
        return this.createObjectByType(headers, id, description, DataCategory.ARCHIVAL_TRANSFER_REPLY, httpServletRequest.getRemoteAddr());
    }

    @POST
    @Path(value="/tmp/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response storeTemporaryFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id") String id, ObjectDescription description) {
        return this.createObjectByType(headers, id, description, DataCategory.TMP, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/tmp/{file_name}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getTemporaryFile(@Context HttpHeaders headers, @PathParam(value="file_name") String file_name) {
        return this.getObject(headers, file_name, DataCategory.TMP, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/reports/{id_report}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createReport(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_report") String reportId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, reportId, createObjectDescription, DataCategory.REPORT, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/reports/{id_report}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getReport(@Context HttpHeaders headers, @PathParam(value="id_report") String objectId) {
        return this.getObject(headers, objectId, DataCategory.REPORT, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/distributionreports/{id_report}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getDistributionReport(@Context HttpHeaders headers, @PathParam(value="id_report") String objectId) {
        return this.getObject(headers, objectId, DataCategory.DISTRIBUTIONREPORTS, AccessLogUtils.getNoLogAccessLog());
    }

    private Response createObjectByType(HttpHeaders headers, String objectId, ObjectDescription createObjectDescription, DataCategory category, String requester) {
        VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        if (createObjectDescription == null) {
            LOGGER.error("Missing body. Cannot create object " + String.valueOf(category) + "/" + objectId);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
        try {
            StoredInfoResult result = this.distribution.storeDataInAllOffers(strategyId, objectId, createObjectDescription, category, requester);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        catch (StorageNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_NOT_FOUND;
        }
        catch (StorageAlreadyExistsException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_DRIVER_OBJECT_ALREADY_EXISTS;
        }
        catch (StorageException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR;
        }
        catch (UnsupportedOperationException exc) {
            LOGGER.error((Throwable)exc);
            vitamCode = VitamCode.STORAGE_BAD_REQUEST;
        }
        return this.buildErrorResponse(vitamCode);
    }

    @Path(value="/manifests/{id_manifest}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createManifest(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="id_manifest") String manifestId, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, manifestId, createObjectDescription, DataCategory.MANIFEST, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/manifests/{id_manifest}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getManifest(@Context HttpHeaders headers, @PathParam(value="id_manifest") String objectId) {
        return this.getObject(headers, objectId, DataCategory.MANIFEST, AccessLogUtils.getNoLogAccessLog());
    }

    @POST
    @Path(value="/storage/backup/accesslog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response backupStorageAccessLog(List<Integer> tenants) {
        VitamCode vitamCode = this.checkMultiTenantRequest(tenants);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        try {
            List<StorageLogBackupResult> backupResultList = this.storageLogAdministration.backupStorageAccessLog(VitamConfiguration.getDefaultStrategy(), tenants);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(backupResultList)).build();
        }
        catch (StorageLogException e) {
            LOGGER.error("Unable to generate backup log", (Throwable)((Object)e));
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @POST
    @Path(value="/storage/backup")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response backupStorageLog(List<Integer> tenants) {
        VitamCode vitamCode = this.checkMultiTenantRequest(tenants);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        try {
            List<StorageLogBackupResult> backupResultList = this.storageLogAdministration.backupStorageWriteLog(VitamConfiguration.getDefaultStrategy(), tenants);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(backupResultList)).build();
        }
        catch (StorageLogException e) {
            LOGGER.error("Unable to generate backup log", (Throwable)((Object)e));
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @POST
    @Path(value="/storage/traceability")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response traceabilityStorageLogbook(List<Integer> tenants) {
        VitamCode vitamCode = this.checkMultiTenantRequest(tenants);
        if (vitamCode != null) {
            return this.buildErrorResponse(vitamCode);
        }
        try {
            List<StorageLogTraceabilityResult> resultList = this.traceabilityLogbookAdministration.generateStorageLogTraceabilityOperations(VitamConfiguration.getDefaultStrategy(), tenants);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(resultList)).build();
        }
        catch (TraceabilityException e) {
            LOGGER.error("unable to generate secure  log", (Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    private VitamCode checkMultiTenantRequest(List<Integer> tenants) {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        if (VitamThreadUtils.getVitamSession().getTenantId() == null) {
            LOGGER.error("Missing tenantId");
            return VitamCode.STORAGE_MISSING_HEADER;
        }
        if (!tenantId.equals(VitamConfiguration.getAdminTenant())) {
            LOGGER.error("Expecting Admin tenant " + VitamConfiguration.getAdminTenant() + " found " + tenantId);
            return VitamCode.STORAGE_INVALID_ADMIN_TENANT;
        }
        if (CollectionUtils.isEmpty(tenants)) {
            LOGGER.error("Expecting non empty list of tenants");
            return VitamCode.STORAGE_INVALID_TENANT_LIST;
        }
        if (tenants.contains(null)) {
            LOGGER.error("Null tenant");
            return VitamCode.STORAGE_INVALID_TENANT_LIST;
        }
        if (new HashSet<Integer>(tenants).size() != tenants.size()) {
            LOGGER.error("Duplicate tenants");
            return VitamCode.STORAGE_INVALID_TENANT_LIST;
        }
        return null;
    }

    @Path(value="/storagelog/{storagelogname}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createStorageLog(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="storagelogname") String storageLogname, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, storageLogname, createObjectDescription, DataCategory.STORAGELOG, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/storageaccesslog/{storageaccesslogname}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createStorageAccessLog(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="storageaccesslogname") String storageAccessLogName, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, storageAccessLogName, createObjectDescription, DataCategory.STORAGEACCESSLOG, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/storagetraceability/{storagetraceabilityname}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createStorageTraceability(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="storagetraceabilityname") String storagetraceabilityname, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, storagetraceabilityname, createObjectDescription, DataCategory.STORAGETRACEABILITY, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/storagetraceability/{storagetraceability_name}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response downloadStorageTraceability(@Context HttpHeaders headers, @PathParam(value="storagetraceability_name") String filename) {
        return this.getObject(headers, filename, DataCategory.STORAGETRACEABILITY, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/backup/{backupfile}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createBackupFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="backupfile") String backupfile, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, backupfile, createObjectDescription, DataCategory.BACKUP, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/rules/{rulefile}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createRuleFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="rulefile") String ruleFile, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, ruleFile, createObjectDescription, DataCategory.RULES, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/rules/{id_object}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getRuleFile(@Context HttpHeaders headers, @PathParam(value="id_object") String objectId) {
        return this.getObject(headers, objectId, DataCategory.RULES, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/unitgraph/{graph_file_name}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createUnitGraphFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="graph_file_name") String graph_file_name, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, graph_file_name, createObjectDescription, DataCategory.UNIT_GRAPH, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/unitgraph/{graph_file_name}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getUnitGraphFile(@Context HttpHeaders headers, @PathParam(value="graph_file_name") String graph_file_name) {
        return this.getObject(headers, graph_file_name, DataCategory.UNIT_GRAPH, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/objectgroupgraph/{graph_file_name}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createObjectGroupGraphFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="graph_file_name") String graph_file_name, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, graph_file_name, createObjectDescription, DataCategory.OBJECTGROUP_GRAPH, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/objectgroupgraph/{graph_file_name}")
    @GET
    @Produces(value={"application/octet-stream"})
    @WriteProtection(value=false)
    public Response getObjectGroupGraphFile(@Context HttpHeaders headers, @PathParam(value="graph_file_name") String graph_file_name) {
        return this.getObject(headers, graph_file_name, DataCategory.OBJECTGROUP_GRAPH, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/agencies/{agencyfile}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createAgencyFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="agencyfile") String agencyfile, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, agencyfile, createObjectDescription, DataCategory.AGENCIES, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/profiles/{profile_file_name}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createProfile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="profile_file_name") String profileFileName, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, profileFileName, createObjectDescription, DataCategory.PROFILE, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/profiles/{profile_file_name}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response downloadProfile(@Context HttpHeaders headers, @PathParam(value="profile_file_name") String profileFileName) {
        return this.getObject(headers, profileFileName, DataCategory.PROFILE, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/distributionreports/{distributionreportfile}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createDistributionReportFile(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="distributionreportfile") String distributionreportfile, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, distributionreportfile, createObjectDescription, DataCategory.DISTRIBUTIONREPORTS, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/accessionregistersdetail/{fileName}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createAccessionRegisterDetail(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="fileName") String fileName, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, fileName, createObjectDescription, DataCategory.ACCESSION_REGISTER_DETAIL, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/accessionregistersdetail/{fileName}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getAccessionRegisterDetail(@Context HttpHeaders headers, @PathParam(value="fileName") String fileName) {
        return this.getObject(headers, fileName, DataCategory.ACCESSION_REGISTER_DETAIL, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/accessionregisterssymbolic/{fileName}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response createAccessionRegisterSymbolic(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="fileName") String fileName, ObjectDescription createObjectDescription) {
        return this.createObjectByType(headers, fileName, createObjectDescription, DataCategory.ACCESSION_REGISTER_SYMBOLIC, httpServletRequest.getRemoteAddr());
    }

    @Path(value="/accessionregisterssymbolic/{fileName}")
    @GET
    @Produces(value={"application/octet-stream", "application/zip"})
    @WriteProtection(value=false)
    public Response getAccessionRegisterSymbolic(@Context HttpHeaders headers, @PathParam(value="fileName") String fileName) {
        return this.getObject(headers, fileName, DataCategory.ACCESSION_REGISTER_SYMBOLIC, AccessLogUtils.getNoLogAccessLog());
    }

    @Path(value="/bulk/{folder}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WriteProtection(value=true)
    public Response bulkCreateFromWorkspace(@Context HttpServletRequest httpServletRequest, @Context HttpHeaders headers, @PathParam(value="folder") String folder, BulkObjectStoreRequest bulkObjectStoreRequest) {
        try {
            VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.STRATEGY_ID);
            if (vitamCode != null) {
                return this.buildErrorResponse(vitamCode);
            }
            String requester = httpServletRequest.getRemoteAddr();
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            ParametersChecker.checkParameter((String)"Strategy id is mandatory", (String[])new String[]{strategyId});
            ParametersChecker.checkParameter((String)"Request is mandatory", (Object[])new Object[]{bulkObjectStoreRequest});
            ParametersChecker.checkParameter((String)"DataCategory is mandatory", (Object[])new Object[]{bulkObjectStoreRequest.getType()});
            ParametersChecker.checkParameter((String)"Object names are mandatory", (Object[])new Object[]{bulkObjectStoreRequest.getObjectNames()});
            ParametersChecker.checkParameter((String)"Object names are mandatory", (Object[])bulkObjectStoreRequest.getObjectNames().toArray());
            ParametersChecker.checkParameter((String)"Workspace container is mandatory", (String[])new String[]{bulkObjectStoreRequest.getWorkspaceContainerGUID()});
            ParametersChecker.checkParameter((String)"Workspace object URIs are mandatory", (Object[])new Object[]{bulkObjectStoreRequest.getWorkspaceObjectURIs()});
            ParametersChecker.checkParameter((String)"Workspace object URIs are mandatory", (Object[])bulkObjectStoreRequest.getWorkspaceObjectURIs().toArray());
            if (bulkObjectStoreRequest.getObjectNames().isEmpty()) {
                throw new IllegalArgumentException("Empty object ids set");
            }
            if (bulkObjectStoreRequest.getObjectNames().size() != bulkObjectStoreRequest.getWorkspaceObjectURIs().size()) {
                throw new IllegalArgumentException("Object ids must match workspace URIs");
            }
            if (!folder.equals(bulkObjectStoreRequest.getType().getCollectionName())) {
                throw new IllegalArgumentException("Folder do not match collection name");
            }
            BulkObjectStoreResponse result = this.distribution.bulkCreateFromWorkspace(strategyId, bulkObjectStoreRequest, requester);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST);
        }
        catch (StorageInconsistentStateException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_INCONSISTENT_STATE);
        }
        catch (Exception exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @Path(value="/strategies")
    @GET
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response getStrategies() {
        try {
            Map<String, StorageStrategy> strategies = this.distribution.getStrategies();
            RequestResponseOK entity = new RequestResponseOK().addAllResults(new ArrayList<StorageStrategy>(strategies.values()));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
        }
        catch (StorageException exc) {
            LOGGER.error((Throwable)exc);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @POST
    @Path(value="/access-request/{dataCategory}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response createAccessRequestIfRequired(@PathParam(value="dataCategory") DataCategory dataCategory, List<String> objectsNames, @Context HttpHeaders headers) {
        try {
            String offerId;
            VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.STRATEGY_ID);
            if (vitamCode != null) {
                return this.buildErrorResponse(vitamCode);
            }
            try {
                ParametersChecker.checkParameter((String)"Data category is required", (Object[])new Object[]{dataCategory});
                ParametersChecker.checkParameter((String)"ObjectsNames are required", (Object[])new Object[]{objectsNames});
                ParametersChecker.checkParameter((String)"ObjectsNames are required", (String[])((String[])objectsNames.toArray(String[]::new)));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Throwable)e);
                return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
            }
            if (objectsNames.isEmpty()) {
                LOGGER.error("Empty objectsNames");
                return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST);
            }
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            Optional<String> accessRequestId = this.distribution.createAccessRequestIfRequired(strategyId, offerId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER).stream().findFirst().orElse(null), dataCategory, objectsNames);
            if (accessRequestId.isEmpty()) {
                LOGGER.debug("No access request required. Offer is not Async");
                return Response.noContent().build();
            }
            LOGGER.info("Access request created " + accessRequestId.get());
            return new RequestResponseOK().addResult((Object)accessRequestId.get()).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @GET
    @Path(value="/access-request/statuses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response checkAccessRequestStatuses(List<String> accessRequestIds, @Context HttpHeaders headers) {
        try {
            VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.X_ADMIN_CROSS_TENANT_ACCESS_REQUEST_ALLOWED);
            if (vitamCode != null) {
                return this.buildErrorResponse(vitamCode);
            }
            try {
                ParametersChecker.checkParameter((String)"AccessRequestIds are required", (Object[])new Object[]{accessRequestIds});
                ParametersChecker.checkParameter((String)"AccessRequestIds are required", (String[])((String[])accessRequestIds.toArray(String[]::new)));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Throwable)e);
                return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
            }
            if (accessRequestIds.isEmpty()) {
                LOGGER.error("Missing access request Ids");
                return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST);
            }
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            String offerId = HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER).stream().findFirst().orElse(null);
            String adminCrossTenantAccessRequestAllowedStr = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.X_ADMIN_CROSS_TENANT_ACCESS_REQUEST_ALLOWED).get(0);
            boolean adminCrossTenantAccessRequestAllowed = Boolean.parseBoolean(adminCrossTenantAccessRequestAllowedStr);
            Map<String, AccessRequestStatus> accessRequestStatuses = this.distribution.checkAccessRequestStatuses(strategyId, offerId, accessRequestIds, adminCrossTenantAccessRequestAllowed);
            LOGGER.debug("Access request statuses " + String.valueOf(accessRequestStatuses));
            return new RequestResponseOK().addResult(accessRequestStatuses).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (StorageIllegalOperationException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_ILLEGAL_OPERATION);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @DELETE
    @Path(value="/access-request/{accessRequestId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response removeAccessRequest(@PathParam(value="accessRequestId") String accessRequestId, @Context HttpHeaders headers) {
        try {
            VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.STRATEGY_ID, VitamHttpHeader.X_ADMIN_CROSS_TENANT_ACCESS_REQUEST_ALLOWED);
            if (vitamCode != null) {
                return this.buildErrorResponse(vitamCode);
            }
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            String offerId = HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER).stream().findFirst().orElse(null);
            try {
                ParametersChecker.checkParameter((String)"AccessRequestId is required", (String[])new String[]{accessRequestId});
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Throwable)e);
                return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
            }
            String adminCrossTenantAccessRequestAllowedStr = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.X_ADMIN_CROSS_TENANT_ACCESS_REQUEST_ALLOWED).get(0);
            boolean adminCrossTenantAccessRequestAllowed = Boolean.parseBoolean(adminCrossTenantAccessRequestAllowedStr);
            this.distribution.removeAccessRequest(strategyId, offerId, accessRequestId, adminCrossTenantAccessRequestAllowed);
            LOGGER.info("Access request removed successfully " + accessRequestId);
            return Response.accepted().build();
        }
        catch (StorageIllegalOperationException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_ILLEGAL_OPERATION);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @GET
    @Path(value="/object-availability-check/{dataCategory}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=false)
    public Response checkObjectAvailability(@PathParam(value="dataCategory") DataCategory dataCategory, List<String> objectsNames, @Context HttpHeaders headers) {
        try {
            VitamCode vitamCode = this.checkTenantAndHeaders(headers, VitamHttpHeader.TENANT_ID, VitamHttpHeader.STRATEGY_ID);
            if (vitamCode != null) {
                return this.buildErrorResponse(vitamCode);
            }
            try {
                ParametersChecker.checkParameter((String)"Data category is required", (Object[])new Object[]{dataCategory});
                ParametersChecker.checkParameter((String)"ObjectsNames are required", (Object[])new Object[]{objectsNames});
                ParametersChecker.checkParameter((String)"ObjectsNames are required", (String[])((String[])objectsNames.toArray(String[]::new)));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Throwable)e);
                return this.buildErrorResponse(VitamCode.STORAGE_MISSING_HEADER);
            }
            if (objectsNames.isEmpty()) {
                LOGGER.error("Empty objectsNames");
                return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST);
            }
            String strategyId = (String)HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.STRATEGY_ID).get(0);
            String offerId = HttpHeaderHelper.getHeaderValues((HttpHeaders)headers, (VitamHttpHeader)VitamHttpHeader.OFFER).stream().findFirst().orElse(null);
            boolean areObjectsAvailable = this.distribution.checkObjectAvailability(strategyId, offerId, dataCategory, objectsNames);
            LOGGER.debug("Availability status for objects {} of type {} is {}", new Object[]{objectsNames, dataCategory, areObjectsAvailable});
            return new RequestResponseOK().addResult((Object)new BulkObjectAvailabilityResponse(areObjectsAvailable)).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
        }
    }

    @POST
    @Path(value="/compaction")
    @Consumes(value={"application/json"})
    @WriteProtection(value=false)
    public void launchOfferLogCompaction(String offerId, @Context HttpHeaders headers) throws StorageException {
        LOGGER.info("Starting offer compaction for offer " + offerId);
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        this.distribution.launchOfferLogCompaction(offerId, tenantId);
        LOGGER.info("End offer compaction for offer " + offerId);
    }

    private Response buildErrorResponse(VitamCode vitamCode) {
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)new RequestResponseError().setError(new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(vitamCode.getMessage())).toString()).build();
    }

    private Response buildCustomErrorResponse(CustomVitamHttpStatusCode customStatusCode, String message) {
        return Response.status((int)customStatusCode.getStatusCode()).entity((Object)new RequestResponseError().setError(new VitamError(customStatusCode.toString()).setContext(ServiceName.STORAGE.getName()).setHttpCode(customStatusCode.getStatusCode()).setState(DomainName.STORAGE.getName()).setMessage(customStatusCode.getMessage()).setDescription(Strings.isNullOrEmpty((String)message) ? customStatusCode.getMessage() : message)).toString()).build();
    }

    private VitamCode checkTenantAndHeaders(HttpHeaders headers, VitamHttpHeader ... vitamHeaders) {
        if (VitamThreadUtils.getVitamSession().getTenantId() == null) {
            LOGGER.error("Missing tenantId");
            return VitamCode.STORAGE_MISSING_HEADER;
        }
        try {
            HttpHeaderHelper.checkVitamHeaders((HttpHeaders)headers);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Header validation failed", (Throwable)e);
            return VitamCode.STORAGE_MISSING_HEADER;
        }
        for (VitamHttpHeader vitamHeader : vitamHeaders) {
            if (HttpHeaderHelper.hasValuesFor((HttpHeaders)headers, (VitamHttpHeader)vitamHeader)) continue;
            LOGGER.error("Required header missing " + vitamHeader.getName());
            return VitamCode.STORAGE_MISSING_HEADER;
        }
        return null;
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(STORAGE_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    public void close() {
        this.storageLogService.close();
        this.distribution.close();
    }
}

