/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.OfferDiffRequest;
import fr.gouv.vitam.storage.engine.server.offerdiff.OfferDiffService;
import fr.gouv.vitam.storage.engine.server.offerdiff.OfferDiffStatus;
import fr.gouv.vitam.storage.engine.server.rest.writeprotection.WriteProtection;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/storage/v1")
@Tag(name="Admin-Offer")
public class AdminOfferDiffResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminOfferDiffResource.class);
    private final OfferDiffService offerDiffService;

    public AdminOfferDiffResource(OfferDiffService offerDiffService) {
        this.offerDiffService = offerDiffService;
    }

    @Path(value="/diff")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    @WriteProtection(value=true)
    public Response startOfferDiff(OfferDiffRequest offerDiffRequest) {
        Response.Status status;
        ParametersChecker.checkParameter((String)"Offer 1 is mandatory.", (String[])new String[]{offerDiffRequest.getOffer1()});
        ParametersChecker.checkParameter((String)"Offer 2 is mandatory.", (String[])new String[]{offerDiffRequest.getOffer2()});
        ParametersChecker.checkParameter((String)"Container is mandatory.", (String[])new String[]{offerDiffRequest.getContainer()});
        ParametersChecker.checkParameter((String)"TenantId is mandatory.", (Object[])new Object[]{offerDiffRequest.getTenantId()});
        if (!VitamConfiguration.getTenants().contains(offerDiffRequest.getTenantId())) {
            throw new IllegalArgumentException("Invalid tenant " + offerDiffRequest.getTenantId());
        }
        VitamThreadUtils.getVitamSession().setTenantId(offerDiffRequest.getTenantId());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        DataCategory dataCategory = DataCategory.getByCollectionName((String)offerDiffRequest.getContainer());
        if (offerDiffRequest.getOffer1().equals(offerDiffRequest.getOffer2())) {
            throw new IllegalArgumentException("Offer ids to compare must not be the same");
        }
        boolean started = this.offerDiffService.startOfferDiff(offerDiffRequest.getOffer1(), offerDiffRequest.getOffer2(), dataCategory);
        if (started) {
            LOGGER.info("Offer diff started");
            status = Response.Status.OK;
        } else {
            LOGGER.warn("Another offer diff process is already running");
            status = Response.Status.CONFLICT;
        }
        return Response.status((Response.Status)status).header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).build();
    }

    @Path(value="/diff")
    @HEAD
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    @WriteProtection(value=true)
    public Response isOfferDiffRunning() {
        return Response.ok().header("Running", (Object)this.offerDiffService.isRunning()).build();
    }

    @Path(value="/diff")
    @GET
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    @WriteProtection(value=true)
    public Response getLastOfferDiffStatus() {
        OfferDiffStatus lastOfferDiffStatus = this.offerDiffService.getLastOfferDiffStatus();
        if (lastOfferDiffStatus == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)lastOfferDiffStatus).build();
    }
}

