/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offerdiff.sort;

import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.model.storage.ObjectEntryReader;
import fr.gouv.vitam.storage.engine.server.offerdiff.sort.LargeFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.commons.io.IOUtils;

public class ObjectEntryLargeFileReader
implements LargeFileReader<ObjectEntry> {
    private final InputStream inputStream;
    private final ObjectEntryReader objectEntryReader;

    public ObjectEntryLargeFileReader(File file) {
        try {
            this.inputStream = new FileInputStream(file);
            this.objectEntryReader = new ObjectEntryReader(this.inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean hasNext() {
        return this.objectEntryReader.hasNext();
    }

    public ObjectEntry next() {
        return this.objectEntryReader.next();
    }

    public void close() {
        this.objectEntryReader.close();
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }
}

