/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offerdiff;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.storage.engine.server.offerdiff.ReportEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ReportWriter
implements AutoCloseable {
    private final OutputStream outputStream;
    private final Writer writer;
    private long totalObjectCount;
    private long errorCount;
    private boolean isEmpty = true;
    private boolean isClosed = false;

    public ReportWriter(File tempFile) throws IOException {
        this.outputStream = new FileOutputStream(tempFile);
        this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
    }

    public void reportMatchingObject(String objectId) {
        ++this.totalObjectCount;
    }

    public void reportObjectMismatch(String objectId, Long sizeOffer1, Long sizeOffer2) throws IOException {
        ++this.totalObjectCount;
        ++this.errorCount;
        if (!this.isEmpty) {
            this.writer.append("\n");
        }
        this.isEmpty = false;
        this.writer.append(JsonHandler.unprettyPrint((Object)new ReportEntry().setObjectId(objectId).setSizeInOffer1(sizeOffer1).setSizeInOffer2(sizeOffer2)));
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.outputStream.close();
        this.isClosed = true;
    }

    public long getTotalObjectCount() {
        return this.totalObjectCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }
}

