/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offerdiff;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.offerdiff.OfferDiffProcess;
import fr.gouv.vitam.storage.engine.server.offerdiff.OfferDiffStatus;
import java.util.concurrent.atomic.AtomicReference;

public class OfferDiffService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OfferDiffService.class);
    private final StorageDistribution distribution;
    private final AtomicReference<OfferDiffProcess> lastOfferDiffProcess = new AtomicReference<Object>(null);

    public OfferDiffService(StorageDistribution distribution) {
        this.distribution = distribution;
    }

    public boolean startOfferDiff(String offer1, String offer2, DataCategory dataCategory) {
        OfferDiffProcess currentOfferDiffProcess;
        OfferDiffProcess offerDiffProcess = this.createOfferDiffProcess(offer1, offer2, dataCategory);
        if (offerDiffProcess != (currentOfferDiffProcess = this.lastOfferDiffProcess.updateAndGet(previousOfferDiffService -> {
            if (previousOfferDiffService != null && previousOfferDiffService.isRunning()) {
                return previousOfferDiffService;
            }
            return offerDiffProcess;
        }))) {
            LOGGER.error("Another offer diff process is already running " + currentOfferDiffProcess.toString());
            return false;
        }
        this.runDiffAsync(offerDiffProcess);
        return true;
    }

    void runDiffAsync(OfferDiffProcess offerDiffProcess) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
                VitamThreadUtils.getVitamSession().setRequestId(requestId);
                offerDiffProcess.run();
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during offer diff process execution", (Throwable)e);
            }
        });
    }

    OfferDiffProcess createOfferDiffProcess(String offer1, String offer2, DataCategory dataCategory) {
        return new OfferDiffProcess(this.distribution, offer1, offer2, dataCategory);
    }

    public boolean isRunning() {
        OfferDiffProcess offerDiffProcess = this.lastOfferDiffProcess.get();
        return offerDiffProcess != null && offerDiffProcess.isRunning();
    }

    public OfferDiffStatus getLastOfferDiffStatus() {
        OfferDiffProcess offerDiffProcess = this.lastOfferDiffProcess.get();
        if (offerDiffProcess == null) {
            return null;
        }
        return offerDiffProcess.getOfferDiffStatus();
    }
}

