/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl.bulk;

import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.driver.Connection;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutRequest;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;

public class MultiplexedStreamTransferThread
implements Callable<StorageBulkPutResult> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MultiplexedStreamTransferThread.class);
    private final int tenantId;
    private final DataCategory dataCategory;
    private final List<String> objectIds;
    private final InputStream inputStream;
    private final long size;
    private final Driver driver;
    private final StorageOffer storageOffer;
    private final DigestType digestType;
    private final String requestId;

    public MultiplexedStreamTransferThread(int tenantId, String requestId, DataCategory dataCategory, List<String> objectIds, InputStream inputStream, long size, Driver driver, StorageOffer storageOffer, DigestType digestType) {
        this.tenantId = tenantId;
        this.requestId = requestId;
        this.dataCategory = dataCategory;
        this.objectIds = objectIds;
        this.inputStream = inputStream;
        this.size = size;
        this.driver = driver;
        this.storageOffer = storageOffer;
        this.digestType = digestType;
    }

    @Override
    public StorageBulkPutResult call() throws Exception {
        String initialThreadId = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(initialThreadId + "-BulkTransferThread-" + this.storageOffer.getId());
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.tenantId));
            VitamThreadUtils.getVitamSession().setRequestId(this.requestId);
            StorageBulkPutResult storageBulkPutResult = this.storeInOffer();
            return storageBulkPutResult;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred during bulk transfer to offer " + this.storageOffer.getId(), (Throwable)ex);
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            Thread.currentThread().setName(initialThreadId);
        }
    }

    private StorageBulkPutResult storeInOffer() throws Exception {
        try (Connection connection = this.driver.connect(this.storageOffer.getId());){
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            StorageBulkPutRequest storageBulkPutRequest = new StorageBulkPutRequest(Integer.valueOf(this.tenantId), this.dataCategory.getFolder(), this.objectIds, this.digestType, this.inputStream, this.size);
            LOGGER.debug("Bulk put request {}", (Object)storageBulkPutRequest);
            StorageBulkPutResult bulkPutObjectResult = connection.bulkPutObjects(storageBulkPutRequest);
            LOGGER.debug("Bulk put result {}", (Object)bulkPutObjectResult);
            StorageBulkPutResult storageBulkPutResult = bulkPutObjectResult;
            return storageBulkPutResult;
        }
    }
}

