/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl.bulk;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageInconsistentStateException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.server.distribution.impl.TransfertTimeoutHelper;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.BulkPutResult;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.BulkPutTransferManager;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.ObjectInfo;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.OfferBulkPutStatus;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookOutcome;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameters;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class BulkStorageDistribution {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BulkStorageDistribution.class);
    private static final String ATTEMPT = " attempt ";
    private static final int MIN_SLEEP_DELAY_BEFORE_RETRY = 10000;
    private static final int MAX_SLEEP_DELAY_BEFORE_RETRY = 30000;
    private final int nbReties;
    private final DigestType digestType;
    private final StorageLog storageLogService;
    private final BulkPutTransferManager bulkPutTransferManager;
    private final int minSleepDelayBeforeRetry;
    private final int maxSleepDelayBeforeRetry;

    public BulkStorageDistribution(int nbReties, WorkspaceClientFactory workspaceClientFactory, StorageLog storageLogService, TransfertTimeoutHelper transfertTimeoutHelper) {
        this(nbReties, storageLogService, VitamConfiguration.getDefaultDigestType(), new BulkPutTransferManager(workspaceClientFactory, transfertTimeoutHelper), 10000, 30000);
    }

    @VisibleForTesting
    BulkStorageDistribution(int nbReties, StorageLog storageLogService, DigestType digestType, BulkPutTransferManager bulkPutTransferManager, int minSleepDelayBeforeRetry, int maxSleepDelayBeforeRetry) {
        this.nbReties = nbReties;
        this.storageLogService = storageLogService;
        this.digestType = digestType;
        this.bulkPutTransferManager = bulkPutTransferManager;
        this.minSleepDelayBeforeRetry = minSleepDelayBeforeRetry;
        this.maxSleepDelayBeforeRetry = maxSleepDelayBeforeRetry;
    }

    public Map<String, String> bulkCreateFromWorkspaceWithRetries(String strategyId, int tenantId, List<String> allOfferIds, Map<String, Driver> storageDrivers, Map<String, StorageOffer> storageOffers, DataCategory dataCategory, String workspaceContainerGUID, List<String> workspaceObjectURIs, List<String> objectIds, String requester) throws StorageException {
        ArrayList<String> remainingOfferIds = new ArrayList<String>(allOfferIds);
        Map<String, ObjectInfo> objectInfos = null;
        ArrayList<String> events = new ArrayList<String>();
        try {
            for (int attempt = 1; attempt <= this.nbReties; ++attempt) {
                BulkPutResult bulkOutResult = this.bulkPutTransferManager.bulkSendDataToOffers(workspaceContainerGUID, strategyId, attempt, tenantId, dataCategory, remainingOfferIds, storageDrivers, storageOffers, workspaceObjectURIs, objectIds);
                if (bulkOutResult.getObjectInfos() != null) {
                    objectInfos = bulkOutResult.getObjectInfos().stream().collect(Collectors.toMap(ObjectInfo::getObjectId, objectInfo -> objectInfo));
                }
                for (Map.Entry<String, OfferBulkPutStatus> entry2 : bulkOutResult.getStatusByOfferIds().entrySet()) {
                    String offerId = entry2.getKey();
                    OfferBulkPutStatus status = entry2.getValue();
                    events.add(offerId + ATTEMPT + attempt + " : " + String.valueOf((Object)status));
                    if (status != OfferBulkPutStatus.OK) continue;
                    remainingOfferIds.remove(offerId);
                }
                boolean hasBlockerError = bulkOutResult.getStatusByOfferIds().values().contains((Object)OfferBulkPutStatus.BLOCKER);
                if (hasBlockerError) {
                    throw new StorageInconsistentStateException("A fatal error occurred during bulk object storage");
                }
                if (remainingOfferIds.isEmpty()) {
                    Map<String, String> map = objectInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ObjectInfo)entry.getValue()).getDigest()));
                    return map;
                }
                this.sleepBeforeRetry(remainingOfferIds);
            }
            throw new StorageException("Could not proceed bulk put operation after " + this.nbReties + " attempts");
        }
        finally {
            this.logStorageEvents(tenantId, dataCategory, objectIds, requester, remainingOfferIds, objectInfos, events);
        }
    }

    private void sleepBeforeRetry(List<String> remainingOfferIds) throws StorageException {
        int sleepDelay = ThreadLocalRandom.current().nextInt(this.minSleepDelayBeforeRetry, this.maxSleepDelayBeforeRetry);
        LOGGER.warn("Will retry writing to " + String.valueOf(remainingOfferIds) + " in " + sleepDelay + "ms");
        try {
            Thread.sleep(sleepDelay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException("Bulk write to offers interrupted", (Throwable)e);
        }
    }

    private void logStorageEvents(Integer tenantId, DataCategory dataCategory, List<String> objectIds, String requester, List<String> remainingOfferIds, Map<String, ObjectInfo> objectInfos, List<String> events) {
        for (String objectId : objectIds) {
            StorageLogbookParameters parameters = StorageLogbookParameters.createLogParameters(objectId, dataCategory.getFolder(), objectInfos != null ? objectInfos.get(objectId).getDigest() : null, this.digestType.getName(), objectInfos != null ? Long.toString(objectInfos.get(objectId).getSize()) : null, String.join((CharSequence)", ", events), requester, remainingOfferIds.isEmpty() ? StorageLogbookOutcome.OK : StorageLogbookOutcome.KO);
            try {
                this.storageLogService.appendWriteLog(tenantId, parameters);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
        }
    }
}

