/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl.bulk;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.stream.MultiplePipedInputStream;
import fr.gouv.vitam.common.stream.PrependedMultiplexedInputStream;
import fr.gouv.vitam.common.stream.VitamAsyncInputStream;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResultEntry;
import fr.gouv.vitam.storage.engine.common.exception.StorageInconsistentStateException;
import fr.gouv.vitam.storage.engine.common.metrics.UploadCountingInputStreamMetrics;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.server.distribution.impl.StreamAndInfo;
import fr.gouv.vitam.storage.engine.server.distribution.impl.TimeoutStopwatch;
import fr.gouv.vitam.storage.engine.server.distribution.impl.TransfertTimeoutHelper;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.BulkPutResult;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.MultiplexedStreamObjectInfoListenerThread;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.MultiplexedStreamTransferThread;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.ObjectInfo;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.OfferBulkPutStatus;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.ResultOrError;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.io.output.ByteArrayOutputStream;

class BulkPutTransferManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BulkPutTransferManager.class);
    public static final String BULK_ORIGIN = "bulk";
    private final WorkspaceClientFactory workspaceClientFactory;
    private final DigestType digestType;
    private final AlertService alertService;
    private final ExecutorService executor;
    private final TransfertTimeoutHelper transfertTimeoutHelper;

    BulkPutTransferManager(WorkspaceClientFactory workspaceClientFactory, TransfertTimeoutHelper transfertTimeoutHelper) {
        this(workspaceClientFactory, VitamConfiguration.getDefaultDigestType(), (AlertService)new AlertServiceImpl(), (ExecutorService)VitamThreadPoolExecutor.getDefaultExecutor(), transfertTimeoutHelper);
    }

    @VisibleForTesting
    BulkPutTransferManager(WorkspaceClientFactory workspaceClientFactory, DigestType digestType, AlertService alertService, ExecutorService executor, TransfertTimeoutHelper transfertTimeoutHelper) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.digestType = digestType;
        this.alertService = alertService;
        this.executor = executor;
        this.transfertTimeoutHelper = transfertTimeoutHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BulkPutResult bulkSendDataToOffers(String workspaceContainerGUID, String strategyId, int attempts, int tenantId, DataCategory dataCategory, List<String> offerIds, Map<String, Driver> storageDrivers, Map<String, StorageOffer> storageOffers, List<String> workspaceObjectURIs, List<String> objectIds) {
        BulkPutResult bulkPutResult;
        Future<List<ObjectInfo>> digestListenerFuture;
        MultiplePipedInputStream streams;
        ResultOrError<StreamAndInfo, BulkPutResult> prependedStreamWithInfo;
        ResultOrError<StreamAndInfo, BulkPutResult> streamWithInfoFromWorkspace;
        block38: {
            ResultOrError<List<ObjectInfo>, BulkPutResult> objectInfo;
            TimeoutStopwatch timeoutStopwatch;
            List<Future<StorageBulkPutResult>> transferThreadFutures;
            block36: {
                BulkPutResult bulkPutResult2;
                block37: {
                    block34: {
                        BulkPutResult bulkPutResult3;
                        block35: {
                            block32: {
                                BulkPutResult bulkPutResult4;
                                block33: {
                                    streamWithInfoFromWorkspace = null;
                                    prependedStreamWithInfo = null;
                                    streams = null;
                                    transferThreadFutures = null;
                                    digestListenerFuture = null;
                                    streamWithInfoFromWorkspace = this.retrieveBulkDataFromWorkspace(workspaceContainerGUID, workspaceObjectURIs, offerIds);
                                    if (!streamWithInfoFromWorkspace.hasError()) break block32;
                                    bulkPutResult4 = streamWithInfoFromWorkspace.getError();
                                    if (transferThreadFutures == null) break block33;
                                    for (Future future : transferThreadFutures) {
                                        future.cancel(true);
                                    }
                                }
                                if (digestListenerFuture != null) {
                                    digestListenerFuture.cancel(true);
                                }
                                if (streams != null) {
                                    streams.close();
                                }
                                if (prependedStreamWithInfo != null && prependedStreamWithInfo.hasResult()) {
                                    prependedStreamWithInfo.getResult().close();
                                }
                                if (streamWithInfoFromWorkspace != null && streamWithInfoFromWorkspace.hasResult()) {
                                    streamWithInfoFromWorkspace.getResult().close();
                                }
                                return bulkPutResult4;
                            }
                            prependedStreamWithInfo = this.prependWithObjectIdsHeaderEntry(objectIds, streamWithInfoFromWorkspace.getResult(), offerIds);
                            if (!prependedStreamWithInfo.hasError()) break block34;
                            bulkPutResult3 = prependedStreamWithInfo.getError();
                            if (transferThreadFutures == null) break block35;
                            for (Future future : transferThreadFutures) {
                                future.cancel(true);
                            }
                        }
                        if (digestListenerFuture != null) {
                            digestListenerFuture.cancel(true);
                        }
                        if (streams != null) {
                            streams.close();
                        }
                        if (prependedStreamWithInfo != null && prependedStreamWithInfo.hasResult()) {
                            prependedStreamWithInfo.getResult().close();
                        }
                        if (streamWithInfoFromWorkspace != null && streamWithInfoFromWorkspace.hasResult()) {
                            streamWithInfoFromWorkspace.getResult().close();
                        }
                        return bulkPutResult3;
                    }
                    streams = new MultiplePipedInputStream(prependedStreamWithInfo.getResult().getStream(), offerIds.size() + 1);
                    String requestId = VitamThreadUtils.getVitamSession().getRequestId();
                    transferThreadFutures = this.startTransferThreads(strategyId, attempts, tenantId, requestId, dataCategory, objectIds, offerIds, storageDrivers, storageOffers, streams, prependedStreamWithInfo.getResult().getSize());
                    digestListenerFuture = this.startDigestComputeThread(offerIds, streams, objectIds);
                    long finalTimeout = this.transfertTimeoutHelper.getBulkTransferTimeout(prependedStreamWithInfo.getResult().getSize(), objectIds.size());
                    timeoutStopwatch = new TimeoutStopwatch(finalTimeout);
                    objectInfo = this.awaitDigestListenerThread(digestListenerFuture, timeoutStopwatch, offerIds);
                    if (!objectInfo.hasError()) break block36;
                    bulkPutResult2 = objectInfo.getError();
                    if (transferThreadFutures == null) break block37;
                    for (Future<StorageBulkPutResult> transferThreadFuture : transferThreadFutures) {
                        transferThreadFuture.cancel(true);
                    }
                }
                if (digestListenerFuture != null) {
                    digestListenerFuture.cancel(true);
                }
                if (streams != null) {
                    streams.close();
                }
                if (prependedStreamWithInfo != null && prependedStreamWithInfo.hasResult()) {
                    prependedStreamWithInfo.getResult().close();
                }
                if (streamWithInfoFromWorkspace != null && streamWithInfoFromWorkspace.hasResult()) {
                    streamWithInfoFromWorkspace.getResult().close();
                }
                return bulkPutResult2;
            }
            try {
                HashMap<String, OfferBulkPutStatus> statusByOfferIds = new HashMap<String, OfferBulkPutStatus>();
                for (int rank = 0; rank < offerIds.size(); ++rank) {
                    String offerId = offerIds.get(rank);
                    Future<StorageBulkPutResult> transferThreadFuture = transferThreadFutures.get(rank);
                    OfferBulkPutStatus status = this.awaitTransferThread(timeoutStopwatch, objectInfo.getResult(), offerId, transferThreadFuture);
                    statusByOfferIds.put(offerId, status);
                }
                bulkPutResult = new BulkPutResult(objectInfo.getResult(), statusByOfferIds);
                if (transferThreadFutures == null) break block38;
            }
            catch (Throwable throwable) {
                if (transferThreadFutures != null) {
                    for (Future future : transferThreadFutures) {
                        future.cancel(true);
                    }
                }
                if (digestListenerFuture != null) {
                    digestListenerFuture.cancel(true);
                }
                if (streams != null) {
                    streams.close();
                }
                if (prependedStreamWithInfo != null && prependedStreamWithInfo.hasResult()) {
                    ((StreamAndInfo)prependedStreamWithInfo.getResult()).close();
                }
                if (streamWithInfoFromWorkspace != null && streamWithInfoFromWorkspace.hasResult()) {
                    streamWithInfoFromWorkspace.getResult().close();
                }
                throw throwable;
            }
            for (Future<StorageBulkPutResult> transferThreadFuture : transferThreadFutures) {
                transferThreadFuture.cancel(true);
            }
        }
        if (digestListenerFuture != null) {
            digestListenerFuture.cancel(true);
        }
        if (streams != null) {
            streams.close();
        }
        if (prependedStreamWithInfo != null && prependedStreamWithInfo.hasResult()) {
            prependedStreamWithInfo.getResult().close();
        }
        if (streamWithInfoFromWorkspace != null && streamWithInfoFromWorkspace.hasResult()) {
            streamWithInfoFromWorkspace.getResult().close();
        }
        return bulkPutResult;
    }

    private ResultOrError<StreamAndInfo, BulkPutResult> retrieveBulkDataFromWorkspace(String containerGUID, List<String> workspaceObjectURIs, List<String> offerIds) {
        ResultOrError<StreamAndInfo, BulkPutResult> resultOrError;
        block9: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                Response response = workspaceClient.bulkGetObjects(containerGUID, workspaceObjectURIs);
                Long size = Long.valueOf(response.getHeaderString(VitamHttpHeader.X_CONTENT_LENGTH.getName()));
                resultOrError = ResultOrError.result(new StreamAndInfo((InputStream)new VitamAsyncInputStream(response), size));
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageNotFoundException e) {
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OBJECT_NOT_FOUND, (Object[])new Object[]{containerGUID}), (Throwable)e);
                    return this.reportGlobalBlockerFailure(offerIds);
                }
                catch (ContentAddressableStorageServerException e) {
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), (Throwable)e);
                    return this.reportGlobalNonBlockerFailure(offerIds);
                }
            }
            workspaceClient.close();
        }
        return resultOrError;
    }

    private ResultOrError<StreamAndInfo, BulkPutResult> prependWithObjectIdsHeaderEntry(List<String> objectIds, StreamAndInfo streamAndInfo, List<String> offerIds) {
        try {
            ByteArrayOutputStream headerEntry = new ByteArrayOutputStream();
            JsonHandler.writeAsOutputStream(objectIds, (OutputStream)headerEntry);
            PrependedMultiplexedInputStream multiplexedInputStreamWithHeader = new PrependedMultiplexedInputStream(headerEntry.toInputStream(), (long)headerEntry.size(), streamAndInfo.getStream(), streamAndInfo.getSize().longValue());
            return ResultOrError.result(new StreamAndInfo((InputStream)multiplexedInputStreamWithHeader, multiplexedInputStreamWithHeader.size()));
        }
        catch (InvalidParseOperationException | IOException e) {
            LOGGER.error("Could not prepend header entry", e);
            return this.reportGlobalNonBlockerFailure(offerIds);
        }
    }

    private Future<List<ObjectInfo>> startDigestComputeThread(List<String> offerIds, MultiplePipedInputStream streams, List<String> objectIds) {
        return this.executor.submit(new MultiplexedStreamObjectInfoListenerThread(VitamThreadUtils.getVitamSession().getTenantId(), VitamThreadUtils.getVitamSession().getRequestId(), streams.getInputStream(offerIds.size()), this.digestType, objectIds));
    }

    private List<Future<StorageBulkPutResult>> startTransferThreads(String strategyId, int attempts, int tenantId, String requestId, DataCategory dataCategory, List<String> objectIds, List<String> offerIds, Map<String, Driver> storageDrivers, Map<String, StorageOffer> storageOffers, MultiplePipedInputStream streams, long size) {
        ArrayList<Future<StorageBulkPutResult>> transferThreadFutures = new ArrayList<Future<StorageBulkPutResult>>();
        for (int rank = 0; rank < offerIds.size(); ++rank) {
            String offerId = offerIds.get(rank);
            Driver driver = storageDrivers.get(offerId);
            StorageOffer storageOffer = storageOffers.get(offerId);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(streams.getInputStream(rank));
            UploadCountingInputStreamMetrics offerInputStream = new UploadCountingInputStreamMetrics(Integer.valueOf(tenantId), strategyId, offerId, BULK_ORIGIN, dataCategory, attempts, (InputStream)bufferedInputStream);
            transferThreadFutures.add(this.executor.submit(new MultiplexedStreamTransferThread(tenantId, requestId, dataCategory, objectIds, (InputStream)offerInputStream, size, driver, storageOffer, this.digestType)));
        }
        return transferThreadFutures;
    }

    private ResultOrError<List<ObjectInfo>, BulkPutResult> awaitDigestListenerThread(Future<List<ObjectInfo>> digestListenerFuture, TimeoutStopwatch timeoutStopwatch, List<String> offerIds) {
        try {
            return ResultOrError.result(digestListenerFuture.get(timeoutStopwatch.getRemainingDelayInMilliseconds(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted thread", (Throwable)e);
            return this.reportGlobalBlockerFailure(offerIds);
        }
        catch (Exception e) {
            LOGGER.error("Could not compute object information for all object ids", (Throwable)e);
            return this.reportGlobalNonBlockerFailure(offerIds);
        }
    }

    private OfferBulkPutStatus awaitTransferThread(TimeoutStopwatch timeoutStopwatch, List<ObjectInfo> objectInfos, String offerId, Future<StorageBulkPutResult> transferThreadFuture) {
        try {
            StorageBulkPutResult storageBulkPutResult = transferThreadFuture.get(timeoutStopwatch.getRemainingDelayInMilliseconds(), TimeUnit.MILLISECONDS);
            this.validationResponseDigestConsistency(objectInfos, offerId, storageBulkPutResult);
            return OfferBulkPutStatus.OK;
        }
        catch (StorageInconsistentStateException e) {
            LOGGER.error((Throwable)e);
            this.alertService.createAlert(VitamLogLevel.ERROR, e.getMessage());
            return OfferBulkPutStatus.BLOCKER;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted thread", (Throwable)e);
            return OfferBulkPutStatus.BLOCKER;
        }
        catch (ExecutionException e) {
            LOGGER.error("Transfer thread failed for offer " + offerId, (Throwable)e);
            if (e.getCause() instanceof StorageDriverException && !((StorageDriverException)e.getCause()).isShouldRetry()) {
                return OfferBulkPutStatus.BLOCKER;
            }
            return OfferBulkPutStatus.KO;
        }
        catch (RuntimeException | TimeoutException e) {
            LOGGER.error("Transfer thread failed for offer " + offerId, (Throwable)e);
            return OfferBulkPutStatus.KO;
        }
    }

    private void validationResponseDigestConsistency(List<ObjectInfo> objectInfos, String offerId, StorageBulkPutResult storageBulkPutResult) throws StorageInconsistentStateException {
        if (storageBulkPutResult.getEntries().size() != objectInfos.size()) {
            throw new StorageInconsistentStateException("Bulk put operation failed for offer " + offerId + ". Invalid result size. Expected " + objectInfos.size() + ". Received from offer " + storageBulkPutResult.getEntries().size());
        }
        for (int i = 0; i < objectInfos.size(); ++i) {
            StorageBulkPutResultEntry bulkPutResultEntry = (StorageBulkPutResultEntry)storageBulkPutResult.getEntries().get(i);
            if (!objectInfos.get(i).getObjectId().equals(bulkPutResultEntry.getObjectId())) {
                throw new StorageInconsistentStateException("Bulk put operation failed for offer " + offerId + ". Invalid object id. Expected '" + objectInfos.get(i).getObjectId() + "'. Received from offer '" + bulkPutResultEntry.getObjectId() + "'");
            }
            if (objectInfos.get(i).getDigest().equals(bulkPutResultEntry.getDigest())) continue;
            throw new StorageInconsistentStateException("Bulk put operation failed for offer " + offerId + ". Invalid digest for object '" + objectInfos.get(i).getObjectId() + "'. Expected " + objectInfos.get(i).getDigest() + ". Received from offer " + bulkPutResultEntry.getDigest());
        }
    }

    private <T> ResultOrError<T, BulkPutResult> reportGlobalBlockerFailure(List<String> offerIds) {
        return ResultOrError.error(new BulkPutResult(null, offerIds.stream().collect(Collectors.toMap(offerId -> offerId, offerId -> OfferBulkPutStatus.BLOCKER))));
    }

    private <T> ResultOrError<T, BulkPutResult> reportGlobalNonBlockerFailure(List<String> offerIds) {
        return ResultOrError.error(new BulkPutResult(null, offerIds.stream().collect(Collectors.toMap(offerId -> offerId, offerId -> OfferBulkPutStatus.KO))));
    }
}

