/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.response.BatchObjectInformationResponse;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectStoreResponse;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.distribution.impl.DataContext;
import fr.gouv.vitam.storage.engine.server.distribution.impl.StreamAndInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;

public class ReadOnlyShieldStorageDistribution
implements StorageDistribution {
    private final StorageDistribution innerStorageDistribution;
    private final AlertService alertService;

    ReadOnlyShieldStorageDistribution(StorageDistribution innerStorageDistribution, AlertService alertService) {
        this.innerStorageDistribution = innerStorageDistribution;
        this.alertService = alertService;
    }

    public void close() {
        this.innerStorageDistribution.close();
    }

    @Override
    public StoredInfoResult copyObjectFromOfferToOffer(DataContext context, String sourceOffer, String destinationOffer) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not copy object " + String.valueOf(context.getCategory()) + "/" + context.getObjectId() + " from offer " + sourceOffer + " to offer " + destinationOffer);
    }

    @Override
    public StoredInfoResult storeDataInAllOffers(String strategyId, String objectId, ObjectDescription createObjectDescription, DataCategory category, String requester) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not copy object " + String.valueOf(category) + "/" + objectId + " to all offers for strategy " + strategyId);
    }

    @Override
    public StoredInfoResult storeDataInOffers(String strategyId, String origin, String objectId, DataCategory category, String requester, List<String> offerIds, Response response) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not copy object " + String.valueOf(category) + "/" + objectId + " to offers " + String.valueOf(offerIds));
    }

    @Override
    public StoredInfoResult storeDataInOffers(String strategyId, String origin, StreamAndInfo streamAndInfo, String objectId, DataCategory category, String requester, List<String> offerIds) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not copy object " + String.valueOf(category) + "/" + objectId + " to offers " + String.valueOf(offerIds));
    }

    @Override
    public List<String> getOfferIds(String strategyId) throws StorageException {
        return this.innerStorageDistribution.getOfferIds(strategyId);
    }

    @Override
    public JsonNode getContainerInformation(String strategyId) throws StorageException {
        return this.innerStorageDistribution.getContainerInformation(strategyId);
    }

    @Override
    public CloseableIterator<ObjectEntry> listContainerObjects(String strategyId, DataCategory category) throws StorageException {
        return this.innerStorageDistribution.listContainerObjects(strategyId, category);
    }

    @Override
    public CloseableIterator<ObjectEntry> listContainerObjectsForOffer(DataCategory category, String offerId, boolean includeDisabled) throws StorageException {
        return this.innerStorageDistribution.listContainerObjectsForOffer(category, offerId, includeDisabled);
    }

    @Override
    public RequestResponse<OfferLog> getOfferLogs(String strategyId, DataCategory category, Long offset, int limit, Order order) throws StorageException {
        return this.innerStorageDistribution.getOfferLogs(strategyId, category, offset, limit, order);
    }

    @Override
    public RequestResponse<OfferLog> getOfferLogsByOfferId(String strategyId, String offerId, DataCategory category, Long offset, int limit, Order order) throws StorageException {
        return this.innerStorageDistribution.getOfferLogsByOfferId(strategyId, offerId, category, offset, limit, order);
    }

    @Override
    public Response getContainerByCategory(String strategyId, String origin, String objectId, DataCategory category, AccessLogInfoModel logInformation) throws StorageException {
        return this.innerStorageDistribution.getContainerByCategory(strategyId, origin, objectId, category, logInformation);
    }

    @Override
    public Response getContainerByCategory(String strategyId, String origin, String objectId, DataCategory category, String offerId) throws StorageException {
        return this.innerStorageDistribution.getContainerByCategory(strategyId, origin, objectId, category, offerId);
    }

    @Override
    public JsonNode getContainerInformation(String strategyId, DataCategory type, String objectId, List<String> offerIds, boolean noCache) throws StorageException {
        return this.innerStorageDistribution.getContainerInformation(strategyId, type, objectId, offerIds, noCache);
    }

    @Override
    public Map<String, Boolean> checkObjectExisting(String strategyId, String objectId, DataCategory category, List<String> offerIds) throws StorageException {
        return this.innerStorageDistribution.checkObjectExisting(strategyId, objectId, category, offerIds);
    }

    @Override
    public void deleteObjectInAllOffers(String strategyId, DataContext context) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not delete object " + String.valueOf(context.getCategory()) + "/" + context.getObjectId() + " from all offers of strategy " + strategyId);
    }

    @Override
    public void deleteObjectInOffers(String strategyId, DataContext context, List<String> offers) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not delete object " + String.valueOf(context.getCategory()) + "/" + context.getObjectId() + " from offers " + String.valueOf(offers));
    }

    @Override
    public List<BatchObjectInformationResponse> getBatchObjectInformation(String strategyId, DataCategory type, List<String> objectIds, List<String> offerIds) throws StorageException {
        return this.innerStorageDistribution.getBatchObjectInformation(strategyId, type, objectIds, offerIds);
    }

    @Override
    public BulkObjectStoreResponse bulkCreateFromWorkspace(String strategyId, BulkObjectStoreRequest bulkObjectStoreRequest, String requester) {
        throw this.reportIllegalAccess("Cannot write in ReadOnly mode. Could not proceed bulk objects write for container " + String.valueOf(bulkObjectStoreRequest.getType()) + " into all offers of strategy " + strategyId);
    }

    @Override
    public Map<String, StorageStrategy> getStrategies() throws StorageException {
        return this.innerStorageDistribution.getStrategies();
    }

    @Override
    public Optional<String> createAccessRequestIfRequired(String strategyId, String offerId, DataCategory dataCategory, List<String> objectsNames) throws StorageException {
        return this.innerStorageDistribution.createAccessRequestIfRequired(strategyId, offerId, dataCategory, objectsNames);
    }

    @Override
    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(String strategyId, String offerId, List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws StorageException {
        return this.innerStorageDistribution.checkAccessRequestStatuses(strategyId, offerId, accessRequestIds, adminCrossTenantAccessRequestAllowed);
    }

    @Override
    public void removeAccessRequest(String strategyId, String offerId, String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws StorageException {
        this.innerStorageDistribution.removeAccessRequest(strategyId, offerId, accessRequestId, adminCrossTenantAccessRequestAllowed);
    }

    @Override
    public boolean checkObjectAvailability(String strategyId, String offerId, DataCategory dataCategory, List<String> objectsNames) throws StorageException {
        return this.innerStorageDistribution.checkObjectAvailability(strategyId, offerId, dataCategory, objectsNames);
    }

    @Override
    public String getReferentOffer(String strategyId) throws StorageTechnicalException, StorageNotFoundException {
        return this.innerStorageDistribution.getReferentOffer(strategyId);
    }

    @Override
    public Response launchOfferLogCompaction(String offerReferenceId, Integer tenantId) throws StorageException {
        return this.innerStorageDistribution.launchOfferLogCompaction(offerReferenceId, tenantId);
    }

    private IllegalStateException reportIllegalAccess(String errorMessage) {
        IllegalStateException illegalStateException = new IllegalStateException(errorMessage);
        this.alertService.createAlert(VitamLogLevel.ERROR, errorMessage, (Throwable)illegalStateException);
        return illegalStateException;
    }
}

