/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl;

import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class OffersToCopyIn {
    private final List<String> okOffers;
    private final List<String> koOffers;
    private final Map<String, Response.Status> globalOfferResult = new HashMap<String, Response.Status>();
    private String readRequestID;
    private boolean readOrderCompleted;

    OffersToCopyIn(StorageOffer storageOffer) {
        this.okOffers = new ArrayList<String>();
        this.koOffers = new ArrayList<String>();
        this.koOffers.add(storageOffer.getId());
        this.globalOfferResult.put(storageOffer.getId(), Response.Status.INTERNAL_SERVER_ERROR);
    }

    public OffersToCopyIn(List<StorageOffer> storageOffers) {
        this.okOffers = new ArrayList<String>();
        this.koOffers = new ArrayList<String>();
        for (StorageOffer storageOffer : storageOffers) {
            this.koOffers.add(storageOffer.getId());
            this.globalOfferResult.put(storageOffer.getId(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public List<String> getOkOffers() {
        return this.okOffers;
    }

    public List<String> getKoOffers() {
        return new ArrayList<String>(this.koOffers);
    }

    public Map<String, Response.Status> getGlobalOfferResult() {
        return this.globalOfferResult;
    }

    public void koListToOkList(String offerId) {
        this.koOffers.remove(offerId);
        this.okOffers.add(offerId);
        this.globalOfferResult.put(offerId, Response.Status.CREATED);
    }

    public void changeStatus(String offerId, Response.Status status) {
        this.globalOfferResult.put(offerId, status);
    }

    public String getReadRequestID() {
        return this.readRequestID;
    }

    public void setReadRequestID(String readRequestID) {
        this.readRequestID = readRequestID;
    }

    public void setReadOrderCompleted(boolean readOrderCompleted) {
        this.readOrderCompleted = readOrderCompleted;
    }

    public boolean isReadOrderCompleted() {
        return this.readOrderCompleted;
    }
}

