/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.external.client.configuration;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;

public class ClientConfigurationImpl
implements ClientConfiguration {
    private static final String CONFIGURATION_PARAMETERS = "ClientConfiguration parameters";
    private String serverHost;
    private int serverPort;

    public ClientConfigurationImpl() {
    }

    public ClientConfigurationImpl(String serverHost, int serverPort) {
        ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (String[])new String[]{serverHost});
        if (serverPort <= 0) {
            throw new IllegalArgumentException("Port most be positive");
        }
        this.serverHost = serverHost;
        this.serverPort = serverPort;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ClientConfigurationImpl setServerHost(String serverHost) {
        ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (String[])new String[]{serverHost});
        this.serverHost = serverHost;
        return this;
    }

    public ClientConfigurationImpl setServerPort(int serverPort) {
        if (serverPort <= 0) {
            throw new IllegalArgumentException("Port most be positive");
        }
        this.serverPort = serverPort;
        return this;
    }

    public boolean isSecure() {
        return false;
    }
}

